/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.database.types.mysql;

import io.github.insideranh.stellarprotect.StellarProtect;
import io.github.insideranh.stellarprotect.arguments.DatabaseFilters;
import io.github.insideranh.stellarprotect.arguments.RadiusArg;
import io.github.insideranh.stellarprotect.arguments.TimeArg;
import io.github.insideranh.stellarprotect.arguments.UsersArg;
import io.github.insideranh.stellarprotect.cache.LoggerCache;
import io.github.insideranh.stellarprotect.cache.PlayerCache;
import io.github.insideranh.stellarprotect.cache.keys.LocationCache;
import io.github.insideranh.stellarprotect.callback.CallbackLookup;
import io.github.insideranh.stellarprotect.database.entries.LogEntry;
import io.github.insideranh.stellarprotect.database.repositories.RestoreRepository;
import io.github.insideranh.stellarprotect.database.types.factory.LogEntryFactory;
import io.github.insideranh.stellarprotect.enums.ActionType;
import io.github.insideranh.stellarprotect.libs.hikaricp.HikariDataSource;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.stream.Collectors;
import lombok.NonNull;

public class RestoreRepositoryMySQL
implements RestoreRepository {
    private final StellarProtect stellarProtect = StellarProtect.getInstance();
    private final HikariDataSource dataSource;

    public RestoreRepositoryMySQL(HikariDataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public CompletableFuture<CallbackLookup<Map<LocationCache, Set<LogEntry>>, Long>> getRestoreActions(@NonNull DatabaseFilters filters, int skip, int limit) {
        if (filters == null) {
            throw new NullPointerException("filters is marked non-null but is null");
        }
        return CompletableFuture.supplyAsync(() -> {
            TimeArg timeArg = filters.getTimeFilter();
            RadiusArg radiusArg = filters.getRadiusFilter();
            List<Integer> actionTypes = filters.getActionTypesFilter();
            ArrayList<ActionType> actionTypeObjects = actionTypes != null ? actionTypes.stream().map(ActionType::getById).filter(Objects::nonNull).collect(Collectors.toList()) : new ArrayList<ActionType>();
            List<Object> cachedLogs = new ArrayList();
            if (!filters.isIgnoreCache() && !actionTypeObjects.isEmpty()) {
                cachedLogs = LoggerCache.getLogs(timeArg, radiusArg, actionTypeObjects, skip, limit).stream().sorted(Comparator.comparingLong(LogEntry::getCreatedAt).reversed()).collect(Collectors.toList());
            }
            Map groupedResults = cachedLogs.stream().collect(Collectors.groupingBy(LocationCache::of, LinkedHashMap::new, Collectors.toCollection(LinkedHashSet::new)));
            int remaining = limit - cachedLogs.size();
            if (remaining > 0) {
                int dbSkip = skip + cachedLogs.size();
                CallbackLookup<Map<LocationCache, Set<LogEntry>>, Long> dbLookup = this.queryLogsFromDB(filters, dbSkip, remaining);
                List<Object> finalCachedLogs = cachedLogs;
                List dbLogs = dbLookup.getLogs().values().stream().flatMap(Collection::stream).filter(log -> finalCachedLogs.stream().noneMatch(c -> c.equals(log))).sorted(Comparator.comparingLong(LogEntry::getCreatedAt).reversed()).limit(remaining).collect(Collectors.toList());
                Map dbGrouped = dbLogs.stream().collect(Collectors.groupingBy(LocationCache::of, LinkedHashMap::new, Collectors.toCollection(LinkedHashSet::new)));
                dbGrouped.forEach((location, logs) -> groupedResults.merge(location, logs, (existing, newLogs) -> {
                    existing.addAll(newLogs);
                    return existing;
                }));
                return new CallbackLookup<Map, Long>(groupedResults, dbLookup.getTotal());
            }
            return new CallbackLookup<Map, Long>(groupedResults, (long)skip + (long)cachedLogs.size());
        }, (Executor)this.stellarProtect.getLookupExecutor());
    }

    @Override
    public CompletableFuture<Long> countRestoreActions(@NonNull DatabaseFilters filters) {
        if (filters == null) {
            throw new NullPointerException("filters is marked non-null but is null");
        }
        return CompletableFuture.supplyAsync(() -> {
            TimeArg timeArg = filters.getTimeFilter();
            RadiusArg radiusArg = filters.getRadiusFilter();
            List<Integer> actionTypes = filters.getActionTypesFilter();
            ArrayList<ActionType> actionTypeObjects = actionTypes != null ? actionTypes.stream().map(ActionType::getById).filter(Objects::nonNull).collect(Collectors.toList()) : new ArrayList<ActionType>();
            long cachedCount = 0L;
            if (!filters.isIgnoreCache() && !actionTypeObjects.isEmpty()) {
                cachedCount = LoggerCache.countLogs(timeArg, radiusArg, actionTypeObjects);
            }
            long dbCount = this.countLogsFromDB(filters);
            return cachedCount + dbCount;
        }, (Executor)this.stellarProtect.getLookupExecutor());
    }

    private long countLogsFromDB(@NonNull DatabaseFilters filters) {
        if (filters == null) {
            throw new NullPointerException("filters is marked non-null but is null");
        }
        QueryBuilder queryBuilder = this.buildBaseQuery(filters);
        String countQuery = "SELECT COUNT(*) " + queryBuilder.getCountQuery();
        List<Object> parameters = queryBuilder.getParameters();
        long totalCount = 0L;
        try (Connection connection = this.getConnection();){
            totalCount = this.executeCountQuery(connection, countQuery, parameters);
        }
        catch (SQLException e) {
            this.stellarProtect.getLogger().log(Level.SEVERE, "Error in count", e);
        }
        return totalCount;
    }

    private CallbackLookup<Map<LocationCache, Set<LogEntry>>, Long> queryLogsFromDB(@NonNull DatabaseFilters filters, int skip, int limit) {
        if (filters == null) {
            throw new NullPointerException("filters is marked non-null but is null");
        }
        Set<Object> logs = new LinkedHashSet();
        long totalCount = 0L;
        QueryBuilder queryBuilder = this.buildBaseQuery(filters);
        String countQuery = "SELECT COUNT(*) " + queryBuilder.getCountQuery();
        String dataQuery = "SELECT ple.*, p.name, p.uuid " + queryBuilder.getDataQuery() + " ORDER BY ple.created_at DESC LIMIT ? OFFSET ?";
        List<Object> parameters = queryBuilder.getParameters();
        try (Connection connection = this.getConnection();){
            totalCount = this.executeCountQuery(connection, countQuery, parameters);
            logs = this.executeDataQuery(connection, dataQuery, parameters, limit, skip);
        }
        catch (SQLException e) {
            this.stellarProtect.getLogger().log(Level.SEVERE, "Error in query", e);
        }
        Map groupedLogs = logs.stream().collect(Collectors.groupingBy(LocationCache::of, LinkedHashMap::new, Collectors.toCollection(LinkedHashSet::new)));
        return new CallbackLookup<Map<LocationCache, Set<LogEntry>>, Long>(groupedLogs, totalCount);
    }

    private QueryBuilder buildBaseQuery(DatabaseFilters databaseFilters) {
        QueryBuilder queryBuilder = new QueryBuilder(this.stellarProtect.getConfigManager().getTablesLogEntries(), this.stellarProtect.getConfigManager().getTablesPlayers()).addTimeFilter(databaseFilters.getTimeFilter()).addRadiusFilter(databaseFilters.getRadiusFilter()).addUsersFilter(databaseFilters.getUserFilters());
        queryBuilder.addCombinedIncludeFilters(databaseFilters.getAllIncludeFilters(), databaseFilters.getIncludeMaterialFilters(), databaseFilters.getIncludeBlockFilters());
        queryBuilder.addCombinedExcludeFilters(databaseFilters.getAllExcludeFilters(), databaseFilters.getExcludeMaterialFilters(), databaseFilters.getExcludeBlockFilters());
        return queryBuilder.addActionTypesFilter(databaseFilters.getActionTypesFilter());
    }

    private long executeCountQuery(Connection connection, String countQuery, List<Object> parameters) throws SQLException {
        try (PreparedStatement countStmt = connection.prepareStatement(countQuery);){
            this.setParameters(countStmt, parameters);
            try (ResultSet resultSet = countStmt.executeQuery();){
                if (resultSet.next()) {
                    long l = resultSet.getLong(1);
                    return l;
                }
            }
        }
        return 0L;
    }

    private Set<LogEntry> executeDataQuery(Connection connection, String dataQuery, List<Object> parameters, int limit, int skip) throws SQLException {
        LinkedHashSet<LogEntry> logs = new LinkedHashSet<LogEntry>();
        try (PreparedStatement dataStmt = connection.prepareStatement(dataQuery);){
            ArrayList<Object> allParams = new ArrayList<Object>(parameters);
            allParams.add(limit);
            allParams.add(skip);
            this.setParameters(dataStmt, allParams);
            try (ResultSet rs = dataStmt.executeQuery();){
                while (rs.next()) {
                    long playerId = rs.getLong("player_id");
                    String playerName = rs.getString("name");
                    PlayerCache.cacheName(playerId, playerName);
                    logs.add(LogEntryFactory.fromDatabase(rs));
                }
            }
        }
        return logs;
    }

    private void setParameters(PreparedStatement stmt, List<Object> parameters) throws SQLException {
        for (int i = 0; i < parameters.size(); ++i) {
            Object param = parameters.get(i);
            if (param instanceof Long) {
                stmt.setLong(i + 1, (Long)param);
                continue;
            }
            if (param instanceof Double) {
                stmt.setDouble(i + 1, (Double)param);
                continue;
            }
            if (param instanceof Integer) {
                stmt.setInt(i + 1, (Integer)param);
                continue;
            }
            stmt.setObject(i + 1, param);
        }
    }

    private Connection getConnection() {
        return this.dataSource.getConnection();
    }

    private static class QueryBuilder {
        private final List<String> whereConditions = new ArrayList<String>();
        private final List<Object> parameters = new ArrayList<Object>();
        private final String tablesLogEntries;
        private final String tablesPlayers;

        public QueryBuilder(String tablesLogEntries, String tablesPlayers) {
            this.tablesLogEntries = tablesLogEntries;
            this.tablesPlayers = tablesPlayers;
        }

        public QueryBuilder addTimeFilter(TimeArg timeArg) {
            if (timeArg != null) {
                this.whereConditions.add("ple.created_at BETWEEN ? AND ?");
                this.parameters.add(timeArg.getStart());
                this.parameters.add(timeArg.getEnd());
            }
            return this;
        }

        public QueryBuilder addRadiusFilter(RadiusArg radiusArg) {
            if (radiusArg != null) {
                if (radiusArg.getWorldId() != -1) {
                    this.whereConditions.add("ple.world_id = ?");
                }
                this.whereConditions.add("ple.x BETWEEN ? AND ?");
                this.whereConditions.add("ple.y BETWEEN ? AND ?");
                this.whereConditions.add("ple.z BETWEEN ? AND ?");
                if (radiusArg.getWorldId() != -1) {
                    this.parameters.add(radiusArg.getWorldId());
                }
                this.parameters.add(radiusArg.getMinX());
                this.parameters.add(radiusArg.getMaxX());
                this.parameters.add(radiusArg.getMinY());
                this.parameters.add(radiusArg.getMaxY());
                this.parameters.add(radiusArg.getMinZ());
                this.parameters.add(radiusArg.getMaxZ());
            }
            return this;
        }

        public QueryBuilder addCombinedIncludeFilters(List<Long> allIncludeFilters, List<Long> materialFilters, List<Long> blockFilters) {
            ArrayList<String> worldConditions;
            ArrayList<String> allIncludeConditions = new ArrayList<String>();
            if (allIncludeFilters != null && !allIncludeFilters.isEmpty()) {
                for (Long wordId : allIncludeFilters) {
                    worldConditions = new ArrayList<String>();
                    worldConditions.add("ple.extra_json LIKE ?");
                    this.parameters.add("%\"id\":" + wordId + ",%");
                    worldConditions.add("ple.extra_json LIKE ?");
                    this.parameters.add("%\"ai\":{%\"" + wordId + "\":%");
                    worldConditions.add("ple.extra_json LIKE ?");
                    this.parameters.add("%\"ri\":{%\"" + wordId + "\":%");
                    allIncludeConditions.add("(" + String.join((CharSequence)" OR ", worldConditions) + ")");
                }
            }
            if (materialFilters != null && !materialFilters.isEmpty()) {
                for (Long wordId : materialFilters) {
                    worldConditions = new ArrayList();
                    worldConditions.add("ple.extra_json LIKE ?");
                    this.parameters.add("%\"id\":" + wordId + ",%");
                    worldConditions.add("ple.extra_json LIKE ?");
                    this.parameters.add("%\"ai\":{%\"" + wordId + "\":%");
                    worldConditions.add("ple.extra_json LIKE ?");
                    this.parameters.add("%\"ri\":{%\"" + wordId + "\":%");
                    allIncludeConditions.add("(" + String.join((CharSequence)" OR ", worldConditions) + ")");
                }
            }
            if (blockFilters != null && !blockFilters.isEmpty()) {
                for (Long blockId : blockFilters) {
                    ArrayList<String> blockConditions = new ArrayList<String>();
                    blockConditions.add("ple.extra_json = ?");
                    this.parameters.add("{\"b\":" + blockId + "}");
                    blockConditions.add("ple.extra_json LIKE ?");
                    this.parameters.add("{\"b\":" + blockId + ",\"ob\":%}");
                    blockConditions.add("ple.extra_json LIKE ?");
                    this.parameters.add("{\"b\":%,\"ob\":" + blockId + "}");
                    blockConditions.add("ple.extra_json LIKE ?");
                    this.parameters.add("{\"nb\":\"" + blockId + "\",\"lb\":\"%\"}");
                    blockConditions.add("ple.extra_json LIKE ?");
                    this.parameters.add("{\"nb\":\"%\",\"lb\":\"" + blockId + "\"}");
                    allIncludeConditions.add("(" + String.join((CharSequence)" OR ", blockConditions) + ")");
                }
            }
            if (!allIncludeConditions.isEmpty()) {
                this.whereConditions.add("(" + String.join((CharSequence)" OR ", allIncludeConditions) + ")");
            }
            return this;
        }

        public QueryBuilder addCombinedExcludeFilters(List<Long> allExcludeFilters, List<Long> materialFilters, List<Long> blockFilters) {
            ArrayList<String> worldExcludeConditions;
            ArrayList<String> allExcludeConditions = new ArrayList<String>();
            if (allExcludeFilters != null && !allExcludeFilters.isEmpty()) {
                for (Long materialId : allExcludeFilters) {
                    worldExcludeConditions = new ArrayList<String>();
                    worldExcludeConditions.add("ple.extra_json NOT LIKE ?");
                    this.parameters.add("%\"id\":" + materialId + ",%");
                    worldExcludeConditions.add("ple.extra_json NOT LIKE ?");
                    this.parameters.add("%\"ai\":{%\"" + materialId + "\":%");
                    worldExcludeConditions.add("ple.extra_json NOT LIKE ?");
                    this.parameters.add("%\"ri\":{%\"" + materialId + "\":%");
                    allExcludeConditions.add("(" + String.join((CharSequence)" AND ", worldExcludeConditions) + ")");
                }
            }
            if (materialFilters != null && !materialFilters.isEmpty()) {
                for (Long materialId : materialFilters) {
                    worldExcludeConditions = new ArrayList();
                    worldExcludeConditions.add("ple.extra_json NOT LIKE ?");
                    this.parameters.add("%\"id\":" + materialId + ",%");
                    worldExcludeConditions.add("ple.extra_json NOT LIKE ?");
                    this.parameters.add("%\"ai\":{%\"" + materialId + "\":%");
                    worldExcludeConditions.add("ple.extra_json NOT LIKE ?");
                    this.parameters.add("%\"ri\":{%\"" + materialId + "\":%");
                    allExcludeConditions.add("(" + String.join((CharSequence)" AND ", worldExcludeConditions) + ")");
                }
            }
            if (blockFilters != null && !blockFilters.isEmpty()) {
                for (Long blockId : blockFilters) {
                    ArrayList<String> blockExcludeConditions = new ArrayList<String>();
                    blockExcludeConditions.add("ple.extra_json != ?");
                    this.parameters.add("{\"b\":" + blockId + "}");
                    blockExcludeConditions.add("ple.extra_json NOT LIKE ?");
                    this.parameters.add("{\"b\":" + blockId + ",\"ob\":%}");
                    blockExcludeConditions.add("ple.extra_json NOT LIKE ?");
                    this.parameters.add("{\"b\":%,\"ob\":" + blockId + "}");
                    blockExcludeConditions.add("ple.extra_json NOT LIKE ?");
                    this.parameters.add("{\"nb\":\"" + blockId + "\",\"lb\":\"%\"}");
                    blockExcludeConditions.add("ple.extra_json NOT LIKE ?");
                    this.parameters.add("{\"nb\":\"%\",\"lb\":\"" + blockId + "\"}");
                    allExcludeConditions.add("(" + String.join((CharSequence)" AND ", blockExcludeConditions) + ")");
                }
            }
            if (!allExcludeConditions.isEmpty()) {
                this.whereConditions.add("(" + String.join((CharSequence)" AND ", allExcludeConditions) + ")");
            }
            return this;
        }

        public QueryBuilder addUsersFilter(UsersArg usersArg) {
            if (usersArg != null && usersArg.getUserIds() != null && !usersArg.getUserIds().isEmpty()) {
                String placeholders = usersArg.getUserIds().stream().map(id -> "?").collect(Collectors.joining(","));
                this.whereConditions.add("ple.player_id IN (" + placeholders + ")");
                this.parameters.addAll(usersArg.getUserIds());
            }
            return this;
        }

        public QueryBuilder addActionTypesFilter(List<Integer> actionTypes) {
            if (actionTypes != null && !actionTypes.isEmpty()) {
                String placeholders = actionTypes.stream().map(type -> "?").collect(Collectors.joining(","));
                this.whereConditions.add("ple.action_type IN (" + placeholders + ")");
                this.parameters.addAll(actionTypes);
            }
            return this;
        }

        public String getCountQuery() {
            String whereClause = this.whereConditions.isEmpty() ? "" : " WHERE " + String.join((CharSequence)" AND ", this.whereConditions);
            return "FROM " + this.tablesLogEntries + " ple " + whereClause;
        }

        public String getDataQuery() {
            String whereClause = this.whereConditions.isEmpty() ? "" : " WHERE " + String.join((CharSequence)" AND ", this.whereConditions);
            return "FROM " + this.tablesLogEntries + " ple JOIN " + this.tablesPlayers + " p ON ple.player_id = p.id" + whereClause;
        }

        public List<Object> getParameters() {
            return new ArrayList<Object>(this.parameters);
        }
    }
}

