/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.foliascheduler.reflectionremapper.proxy;

import io.github.insideranh.stellarprotect.libs.foliascheduler.reflectionremapper.ReflectionRemapper;
import io.github.insideranh.stellarprotect.libs.foliascheduler.reflectionremapper.internal.util.Util;
import io.github.insideranh.stellarprotect.libs.foliascheduler.reflectionremapper.proxy.annotation.ConstructorInvoker;
import io.github.insideranh.stellarprotect.libs.foliascheduler.reflectionremapper.proxy.annotation.FieldGetter;
import io.github.insideranh.stellarprotect.libs.foliascheduler.reflectionremapper.proxy.annotation.FieldSetter;
import io.github.insideranh.stellarprotect.libs.foliascheduler.reflectionremapper.proxy.annotation.MethodName;
import io.github.insideranh.stellarprotect.libs.foliascheduler.reflectionremapper.proxy.annotation.Static;
import io.github.insideranh.stellarprotect.libs.foliascheduler.reflectionremapper.proxy.annotation.Type;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.UnaryOperator;
import org.checkerframework.checker.nullness.qual.Nullable;

final class ReflectionProxyInvocationHandler<I>
implements InvocationHandler {
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private final Class<I> interfaceClass;
    private final Map<Method, MethodHandle> methods = new HashMap<Method, MethodHandle>();
    private final Map<Method, MethodHandle> getters = new HashMap<Method, MethodHandle>();
    private final Map<Method, MethodHandle> setters = new HashMap<Method, MethodHandle>();
    private final Map<Method, MethodHandle> staticGetters = new HashMap<Method, MethodHandle>();
    private final Map<Method, MethodHandle> staticSetters = new HashMap<Method, MethodHandle>();
    private final Map<Method, MethodHandle> defaultMethods = new ConcurrentHashMap<Method, MethodHandle>();

    ReflectionProxyInvocationHandler(Class<I> interfaceClass, ReflectionRemapper reflectionRemapper) {
        this.interfaceClass = interfaceClass;
        this.scanInterface(reflectionRemapper);
    }

    @Override
    public @Nullable Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (ReflectionProxyInvocationHandler.isEqualsMethod(method)) {
            return proxy == args[0];
        }
        if (ReflectionProxyInvocationHandler.isHashCodeMethod(method)) {
            return 0;
        }
        if (ReflectionProxyInvocationHandler.isToStringMethod(method)) {
            return String.format("ReflectionProxy[interface=%s, implementation=%s]", this.interfaceClass.getTypeName(), proxy.getClass().getTypeName());
        }
        if (args == null) {
            args = EMPTY_OBJECT_ARRAY;
        }
        if (method.isDefault()) {
            return this.handleDefaultMethod(proxy, method, args);
        }
        @Nullable MethodHandle methodHandle = this.methods.get(method);
        if (methodHandle != null) {
            if (args.length == 0) {
                return methodHandle.invokeExact();
            }
            return methodHandle.invokeExact(args);
        }
        @Nullable MethodHandle getter = this.getters.get(method);
        if (getter != null) {
            return getter.invokeExact(args[0]);
        }
        @Nullable MethodHandle setter = this.setters.get(method);
        if (setter != null) {
            return setter.invokeExact(args[0], args[1]);
        }
        @Nullable MethodHandle staticGetter = this.staticGetters.get(method);
        if (staticGetter != null) {
            return staticGetter.invokeExact();
        }
        @Nullable MethodHandle staticSetter = this.staticSetters.get(method);
        if (staticSetter != null) {
            return staticSetter.invokeExact(args[0]);
        }
        throw new IllegalStateException();
    }

    private @Nullable Object handleDefaultMethod(Object proxy, Method method, Object[] args) throws Throwable {
        MethodHandle handle = this.defaultMethods.computeIfAbsent(method, m -> ReflectionProxyInvocationHandler.adapt(Util.sneakyThrows(() -> Util.handleForDefaultMethod(this.interfaceClass, m)).bindTo(proxy)));
        if (args.length == 0) {
            return handle.invokeExact();
        }
        return handle.invokeExact(args);
    }

    private void scanInterface(ReflectionRemapper reflectionRemapper) {
        Class<?> prevProxy = null;
        Class<?> prevProxied = null;
        for (Class<?> cls : Util.topDownInterfaceHierarchy(this.interfaceClass)) {
            Class<?> proxied = Util.findProxiedClass(cls, reflectionRemapper::remapClassName);
            if (prevProxied != null && !prevProxied.isAssignableFrom(proxied)) {
                throw new IllegalArgumentException("Reflection proxy interface " + cls.getName() + " proxies " + proxied.getName() + ", and extends from reflection proxy interface " + prevProxy.getName() + " which proxies " + prevProxied.getName() + ", but the proxied types are not compatible.");
            }
            this.scanInterface(cls, proxied, reflectionRemapper::remapClassOrArrayName, fieldName -> reflectionRemapper.remapFieldName(proxied, (String)fieldName), (methodName, parameters) -> reflectionRemapper.remapMethodName(proxied, (String)methodName, (Class<?>)parameters));
            prevProxied = proxied;
            prevProxy = cls;
        }
    }

    private void scanInterface(Class<?> interfaceClass, Class<?> proxiedClass, UnaryOperator<String> classMapper, UnaryOperator<String> fieldMapper, BiFunction<String, Class<?>[], String> methodMapper) {
        for (Method method : interfaceClass.getDeclaredMethods()) {
            MethodHandle handle;
            boolean hasStaticAnnotation;
            boolean constructorInvoker;
            if (ReflectionProxyInvocationHandler.isEqualsMethod(method) || ReflectionProxyInvocationHandler.isHashCodeMethod(method) || ReflectionProxyInvocationHandler.isToStringMethod(method) || Util.isSynthetic(method.getModifiers()) || method.isDefault()) continue;
            boolean bl = constructorInvoker = method.getDeclaredAnnotation(ConstructorInvoker.class) != null;
            if (constructorInvoker) {
                this.methods.put(method, ReflectionProxyInvocationHandler.adapt(Util.sneakyThrows(() -> LOOKUP.unreflectConstructor(this.findProxiedConstructor(proxiedClass, method, classMapper)))));
                continue;
            }
            @Nullable FieldGetter getterAnnotation = method.getDeclaredAnnotation(FieldGetter.class);
            @Nullable FieldSetter setterAnnotation = method.getDeclaredAnnotation(FieldSetter.class);
            if (getterAnnotation != null && setterAnnotation != null) {
                throw new IllegalArgumentException("Method " + method.getName() + " in " + interfaceClass.getTypeName() + " is annotated with @FieldGetter and @FieldSetter, don't know which to use.");
            }
            boolean bl2 = hasStaticAnnotation = method.getDeclaredAnnotation(Static.class) != null;
            if (getterAnnotation != null) {
                handle = Util.sneakyThrows(() -> LOOKUP.unreflectGetter(ReflectionProxyInvocationHandler.findProxiedField(proxiedClass, getterAnnotation.value(), fieldMapper)));
                if (hasStaticAnnotation) {
                    ReflectionProxyInvocationHandler.checkParameterCount(method, interfaceClass, 0, "Static @FieldGetters should have no parameters.");
                    this.staticGetters.put(method, handle.asType(MethodType.methodType(Object.class)));
                    continue;
                }
                ReflectionProxyInvocationHandler.checkParameterCount(method, interfaceClass, 1, "Non-static @FieldGetters should have one parameter.");
                this.getters.put(method, handle.asType(MethodType.methodType(Object.class, Object.class)));
                continue;
            }
            if (setterAnnotation != null) {
                handle = Util.sneakyThrows(() -> LOOKUP.unreflectSetter(ReflectionProxyInvocationHandler.findProxiedField(proxiedClass, setterAnnotation.value(), fieldMapper)));
                if (hasStaticAnnotation) {
                    ReflectionProxyInvocationHandler.checkParameterCount(method, interfaceClass, 1, "Static @FieldSetters should have one parameter.");
                    this.staticSetters.put(method, handle.asType(MethodType.methodType(Object.class, Object.class)));
                    continue;
                }
                ReflectionProxyInvocationHandler.checkParameterCount(method, interfaceClass, 2, "Non-static @FieldSetters should have two parameters.");
                this.setters.put(method, handle.asType(MethodType.methodType(Object.class, Object.class, Object.class)));
                continue;
            }
            if (!hasStaticAnnotation && method.getParameterCount() < 1) {
                throw new IllegalArgumentException("Non-static method invokers should have at least one parameter. Method " + method.getName() + " in " + interfaceClass.getTypeName() + " has " + method.getParameterCount());
            }
            this.methods.put(method, ReflectionProxyInvocationHandler.adapt(Util.sneakyThrows(() -> LOOKUP.unreflect(this.findProxiedMethod(proxiedClass, method, classMapper, methodMapper)))));
        }
    }

    private static MethodHandle adapt(MethodHandle handle) {
        if (handle.type().parameterCount() == 0) {
            return handle.asType(MethodType.methodType(Object.class));
        }
        return handle.asSpreader(Object[].class, handle.type().parameterCount()).asType(MethodType.methodType(Object.class, Object[].class));
    }

    private static void checkParameterCount(Method method, Class<?> holder, int expected, String message) {
        if (method.getParameterCount() != expected) {
            throw new IllegalArgumentException(String.format("Unexpected amount of parameters for method %s in %s, got %d while expecting %d. %s", method.getName(), holder.getTypeName(), method.getParameterCount(), expected, message));
        }
    }

    private static boolean isToStringMethod(Method method) {
        return method.getName().equals("toString") && method.getParameterCount() == 0 && method.getReturnType() == String.class;
    }

    private static boolean isHashCodeMethod(Method method) {
        return method.getName().equals("hashCode") && method.getParameterCount() == 0 && method.getReturnType() == Integer.TYPE;
    }

    private static boolean isEqualsMethod(Method method) {
        return method.getName().equals("equals") && method.getParameterCount() == 1 && method.getReturnType() == Boolean.TYPE;
    }

    private static Field findProxiedField(Class<?> proxiedClass, String fieldName, UnaryOperator<String> fieldMapper) {
        Field field;
        try {
            field = proxiedClass.getDeclaredField((String)fieldMapper.apply(fieldName));
        }
        catch (NoSuchFieldException e) {
            throw new IllegalArgumentException("Could not find field '" + fieldName + "' in " + proxiedClass.getTypeName(), e);
        }
        try {
            field.setAccessible(true);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Could not set access for field '" + fieldName + "' in " + proxiedClass.getTypeName(), ex);
        }
        return field;
    }

    private Constructor<?> findProxiedConstructor(Class<?> proxiedClass, Method method, UnaryOperator<String> classMapper) {
        Constructor<?> constructor;
        Class[] actualParams = (Class[])Arrays.stream(method.getParameters()).map(p -> ReflectionProxyInvocationHandler.resolveParameterTypeClass(p, classMapper)).toArray(Class[]::new);
        try {
            constructor = proxiedClass.getDeclaredConstructor(actualParams);
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalArgumentException("Could not find constructor of " + proxiedClass.getTypeName() + " with parameter types " + Arrays.toString(method.getParameterTypes()), ex);
        }
        try {
            constructor.setAccessible(true);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Could not set access for proxy method target constructor of " + proxiedClass.getTypeName() + " with parameter types " + Arrays.toString(method.getParameterTypes()), ex);
        }
        return constructor;
    }

    private Method findProxiedMethod(Class<?> proxiedClass, Method method, UnaryOperator<String> classMapper, BiFunction<String, Class<?>[], String> methodMapper) {
        Method proxiedMethod;
        boolean hasStaticAnnotation = method.getDeclaredAnnotation(Static.class) != null;
        Class[] actualParams = hasStaticAnnotation ? (Class[])Arrays.stream(method.getParameters()).map(p -> ReflectionProxyInvocationHandler.resolveParameterTypeClass(p, classMapper)).toArray(Class[]::new) : (Class[])Arrays.stream(method.getParameters()).skip(1L).map(p -> ReflectionProxyInvocationHandler.resolveParameterTypeClass(p, classMapper)).toArray(Class[]::new);
        @Nullable MethodName methodAnnotation = method.getDeclaredAnnotation(MethodName.class);
        String methodName = methodAnnotation == null ? method.getName() : methodAnnotation.value();
        try {
            proxiedMethod = proxiedClass.getDeclaredMethod(methodMapper.apply(methodName, actualParams), actualParams);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Could not find proxy method target method: " + proxiedClass.getTypeName() + " " + methodName);
        }
        try {
            proxiedMethod.setAccessible(true);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Could not set access for proxy method target method: " + proxiedClass.getTypeName() + " " + methodName, ex);
        }
        return proxiedMethod;
    }

    private static Class<?> resolveParameterTypeClass(Parameter parameter, UnaryOperator<String> classMapper) {
        Class<?> namedClass;
        @Nullable Type typeAnnotation = parameter.getDeclaredAnnotation(Type.class);
        if (typeAnnotation == null) {
            return parameter.getType();
        }
        if (typeAnnotation.value() == Object.class && typeAnnotation.className().isEmpty()) {
            throw new IllegalArgumentException("@Type annotation must either have value() or className() set.");
        }
        if (typeAnnotation.value() != Object.class) {
            return Util.findProxiedClass(typeAnnotation.value(), classMapper);
        }
        try {
            namedClass = Class.forName((String)classMapper.apply(typeAnnotation.className()));
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Class " + typeAnnotation.className() + " specified in @Type annotation not found.", e);
        }
        return namedClass;
    }
}

