/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.managers;

import io.github.insideranh.stellarprotect.StellarProtect;
import io.github.insideranh.stellarprotect.cache.keys.LocationCache;
import io.github.insideranh.stellarprotect.data.InventoryRollbackSession;
import io.github.insideranh.stellarprotect.data.PlayerProtect;
import io.github.insideranh.stellarprotect.database.entries.LogEntry;
import io.github.insideranh.stellarprotect.database.entries.players.PlayerTransactionEntry;
import io.github.insideranh.stellarprotect.enums.ActionType;
import io.github.insideranh.stellarprotect.items.ItemTemplate;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class ChestRollbackSessionManager {
    private final StellarProtect plugin = StellarProtect.getInstance();

    public void performInventoryRollback(Player player, Location location) {
        PlayerProtect playerProtect = PlayerProtect.getPlayer(player);
        if (playerProtect == null) {
            return;
        }
        InventoryRollbackSession session = playerProtect.getInventoryRollbackSession();
        if (session == null || !session.isActive()) {
            return;
        }
        Block block = location.getBlock();
        if (!(block.getState() instanceof InventoryHolder)) {
            this.plugin.getLangManager().sendMessage((CommandSender)player, "messages.inventoryRollback.invalidBlock");
            return;
        }
        InventoryHolder holder = (InventoryHolder)block.getState();
        Inventory inventory = holder.getInventory();
        ((CompletableFuture)this.plugin.getProtectDatabase().getRestoreActions(session.getDatabaseFilters(), 0, 10000).thenAccept(callbackLookup -> {
            Map groupedLogs = (Map)callbackLookup.getLogs();
            if (groupedLogs.isEmpty()) {
                if (!session.isSilent()) {
                    this.plugin.getLangManager().sendMessage((CommandSender)player, "messages.inventoryRollback.noTransactions");
                }
                return;
            }
            LocationCache targetLocationCache = LocationCache.of(location);
            Set locationLogs = (Set)groupedLogs.get(targetLocationCache);
            if (locationLogs == null || locationLogs.isEmpty()) {
                if (!session.isSilent()) {
                    this.plugin.getLangManager().sendMessage((CommandSender)player, "messages.inventoryRollback.noTransactions");
                }
                return;
            }
            ArrayList<PlayerTransactionEntry> transactions = new ArrayList<PlayerTransactionEntry>();
            for (LogEntry log : locationLogs) {
                if (!(log instanceof PlayerTransactionEntry) || log.getActionType() != ActionType.INVENTORY_TRANSACTION.getId()) continue;
                transactions.add((PlayerTransactionEntry)log);
            }
            if (transactions.isEmpty()) {
                if (!session.isSilent()) {
                    this.plugin.getLangManager().sendMessage((CommandSender)player, "messages.inventoryRollback.noTransactions");
                }
                return;
            }
            transactions.sort(Comparator.comparingLong(LogEntry::getCreatedAt));
            Map<Long, Integer> inventoryState = this.calculateInventoryState(transactions, session.getDatabaseFilters().getTimeFilter().getStart());
            this.applyInventoryRollback(inventory, inventoryState, session.isVerbose(), session.isSilent(), player);
            if (!session.isSilent()) {
                this.plugin.getLangManager().sendMessage((CommandSender)player, "messages.inventoryRollback.success");
            }
        })).exceptionally(error -> {
            this.plugin.getLangManager().sendMessage((CommandSender)player, "messages.error");
            this.plugin.getLogger().severe("Error performing inventory rollback: " + error.getMessage());
            return null;
        });
    }

    private Map<Long, Integer> calculateInventoryState(List<PlayerTransactionEntry> transactions, long targetTimestamp) {
        HashMap<Long, Integer> deltaToApply = new HashMap<Long, Integer>();
        for (PlayerTransactionEntry transaction : transactions) {
            int amount;
            long itemId;
            long transactionTime = transaction.getCreatedAt();
            if (transactionTime < targetTimestamp) continue;
            for (Map.Entry<Long, Integer> added : transaction.getAdded().entrySet()) {
                itemId = added.getKey();
                amount = added.getValue();
                deltaToApply.put(itemId, deltaToApply.getOrDefault(itemId, 0) + amount);
            }
            for (Map.Entry<Long, Integer> removed : transaction.getRemoved().entrySet()) {
                itemId = removed.getKey();
                amount = removed.getValue();
                deltaToApply.put(itemId, deltaToApply.getOrDefault(itemId, 0) - amount);
            }
        }
        return deltaToApply;
    }

    private void applyInventoryRollback(Inventory inventory, Map<Long, Integer> deltaState, boolean verbose, boolean silent, Player player) {
        int itemsChanged = 0;
        for (Map.Entry<Long, Integer> entry : deltaState.entrySet()) {
            long itemId = entry.getKey();
            int delta = entry.getValue();
            if (delta == 0) continue;
            ItemStack itemStack = null;
            ItemTemplate itemTemplate = this.plugin.getItemsManager().getItemCache().getById(itemId);
            if (itemTemplate != null) {
                itemStack = itemTemplate.getBukkitItem();
            }
            if (itemStack == null) {
                if (!verbose || silent) continue;
                player.sendMessage("\u00a77[VERBOSE] \u00a7cNo se pudo encontrar el item con ID: \u00a7f" + itemId);
                continue;
            }
            if (delta > 0) {
                ItemStack toAdd = itemStack.clone();
                toAdd.setAmount(delta);
                HashMap leftover = inventory.addItem(new ItemStack[]{toAdd});
                if (!leftover.isEmpty() && verbose && !silent) {
                    player.sendMessage("\u00a77[VERBOSE] \u00a7eInventario lleno, algunos items no pudieron ser agregados");
                }
                if (verbose && !silent) {
                    player.sendMessage("\u00a77[VERBOSE] \u00a7a+ " + delta + "x \u00a7f" + itemStack.getType().name());
                }
                itemsChanged += delta;
                continue;
            }
            if (delta >= 0) continue;
            int toRemove = Math.abs(delta);
            ItemStack toRemoveStack = itemStack.clone();
            toRemoveStack.setAmount(toRemove);
            HashMap notRemoved = inventory.removeItem(new ItemStack[]{toRemoveStack});
            if (!notRemoved.isEmpty() && verbose && !silent) {
                player.sendMessage("\u00a77[VERBOSE] \u00a7eNo se encontraron suficientes items para remover");
            }
            if (verbose && !silent) {
                player.sendMessage("\u00a77[VERBOSE] \u00a7c- " + toRemove + "x \u00a7f" + itemStack.getType().name());
            }
            itemsChanged += toRemove;
        }
        if (verbose && !silent) {
            player.sendMessage("\u00a77[VERBOSE] \u00a76Total de items modificados: \u00a7f" + itemsChanged);
        }
    }

    public boolean toggleInventoryRollbackMode(Player player) {
        PlayerProtect playerProtect = PlayerProtect.getPlayer(player);
        if (playerProtect == null) {
            return false;
        }
        InventoryRollbackSession session = playerProtect.getInventoryRollbackSession();
        if (session == null) {
            return false;
        }
        session.toggle();
        return session.isActive();
    }
}

