/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.managers;

import io.github.insideranh.stellarprotect.StellarProtect;
import io.github.insideranh.stellarprotect.cache.keys.LocationCache;
import io.github.insideranh.stellarprotect.data.PlayerProtect;
import io.github.insideranh.stellarprotect.data.UndoSession;
import io.github.insideranh.stellarprotect.database.entries.LogEntry;
import io.github.insideranh.stellarprotect.enums.ActionType;
import io.github.insideranh.stellarprotect.items.MinecraftItem;
import io.github.insideranh.stellarprotect.utils.PlayerUtils;
import io.github.insideranh.stellarprotect.utils.StringCleanerUtils;
import io.github.insideranh.stellarprotect.utils.TimeUtils;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class UndoSessionManager {
    private final StellarProtect plugin = StellarProtect.getInstance();

    public void showUndoSession(UndoSession session) {
        Player player = session.getPlayer();
        session.getUndoneLogHashes().clear();
        session.getProcessedLogHashes().clear();
        ((CompletableFuture)this.plugin.getProtectDatabase().getRestoreActions(session.getDatabaseFilters(), session.getCurrentOffset(), session.getLogsPerPage()).thenAccept(callbackLookup -> {
            Map groupedLogs = (Map)callbackLookup.getLogs();
            if (groupedLogs.isEmpty()) {
                this.plugin.getLangManager().sendMessage((CommandSender)player, "messages.noMoreLogs");
                return;
            }
            this.displayLogsToPlayer(session, groupedLogs);
        })).exceptionally(error -> {
            this.plugin.getLangManager().sendMessage((CommandSender)player, "messages.error");
            error.printStackTrace();
            return null;
        });
    }

    private void displayLogsToPlayer(UndoSession session, Map<LocationCache, Set<LogEntry>> groupedLogs) {
        Player player = session.getPlayer();
        if (!session.isSilent()) {
            player.sendMessage(this.plugin.getLangManager().get("messages.undo.sessions.title"));
            player.sendMessage(this.plugin.getLangManager().get("messages.undo.sessions.subtitle"));
            player.sendMessage("");
        }
        ArrayList<LogEntry> allLogs = new ArrayList<LogEntry>();
        for (Set<LogEntry> logs : groupedLogs.values()) {
            allLogs.addAll(logs);
        }
        allLogs.sort((a, b) -> Long.compare(b.getCreatedAt(), a.getCreatedAt()));
        for (LogEntry log : allLogs) {
            int logHash = log.hashCode();
            if (session.isProcessed(logHash)) continue;
            session.addProcessedLog(logHash, log);
            this.displayLogEntry(session, log, logHash);
        }
        this.displayNavigationButtons(session);
        session.nextPage();
    }

    private void displayLogEntry(UndoSession session, LogEntry logEntry, int logHash) {
        TextComponent actionButton;
        String data;
        Player player = session.getPlayer();
        boolean isUndone = session.isUndone(logHash);
        ActionType actionType = ActionType.getById(logEntry.getActionType());
        if (actionType == null) {
            return;
        }
        String action = actionType.name().toLowerCase();
        if (actionType.isParseMinecraftData()) {
            MinecraftItem minecraftItem = StringCleanerUtils.parseMinecraftData(logEntry.getDataString());
            data = minecraftItem.getCleanName();
        } else {
            data = logEntry.getDataString();
        }
        TextComponent message = new TextComponent();
        if (isUndone) {
            actionButton = new TextComponent("\u00a78[\u00a7cX\u00a78] ");
            actionButton.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/stellarprotect us redo " + logHash));
            actionButton.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, TextComponent.fromLegacyText((String)this.plugin.getLangManager().get("messages.undo.sessions.redo"))));
        } else {
            actionButton = new TextComponent("\u00a78[\u00a7e>>\u00a78] ");
            actionButton.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/stellarprotect us undo " + logHash));
            actionButton.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, TextComponent.fromLegacyText((String)this.plugin.getLangManager().get("messages.undo.sessions.undo"))));
        }
        message.addExtra((BaseComponent)actionButton);
        message.addExtra((BaseComponent)new TextComponent(this.plugin.getLangManager().get("messages.undo.sessions." + action, text -> text.replace("<time>", TimeUtils.formatMillisAsAgo(logEntry.getCreatedAt())).replace("<player>", PlayerUtils.getNameOfEntity(logEntry.getPlayerId())).replace("<data>", data))));
        player.spigot().sendMessage((BaseComponent)message);
    }

    private void displayNavigationButtons(UndoSession session) {
        Player player = session.getPlayer();
        player.sendMessage("");
        TextComponent undoAllButton = new TextComponent(this.plugin.getLangManager().get("messages.undo.sessions.undoall"));
        undoAllButton.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/stellarprotect us undoall"));
        undoAllButton.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, TextComponent.fromLegacyText((String)this.plugin.getLangManager().get("messages.undo.sessions.undoall-tip"))));
        TextComponent nextPageButton = new TextComponent(this.plugin.getLangManager().get("messages.undo.sessions.next"));
        nextPageButton.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/stellarprotect us next"));
        nextPageButton.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, TextComponent.fromLegacyText((String)this.plugin.getLangManager().get("messages.undo.sessions.next-tip"))));
        TextComponent exitButton = new TextComponent(this.plugin.getLangManager().get("messages.undo.sessions.exit"));
        exitButton.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/stellarprotect us exit"));
        exitButton.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, TextComponent.fromLegacyText((String)this.plugin.getLangManager().get("messages.undo.sessions.exit-tip"))));
        TextComponent navigationMessage = new TextComponent("");
        navigationMessage.addExtra((BaseComponent)undoAllButton);
        navigationMessage.addExtra((BaseComponent)nextPageButton);
        navigationMessage.addExtra((BaseComponent)exitButton);
        player.spigot().sendMessage((BaseComponent)navigationMessage);
        player.sendMessage("");
    }

    public void undoIndividualLog(UndoSession session, int logHash) {
        LogEntry log = (LogEntry)session.getProcessedLog(logHash);
        if (log == null) {
            this.plugin.getLangManager().sendMessage((CommandSender)session.getPlayer(), "messages.invalidLog");
            return;
        }
        if (!session.isUndone(logHash)) {
            this.plugin.getUndoManager().undoRestore(log, (CommandSender)session.getPlayer(), session.isVerbose());
        }
        session.markAsUndone(logHash, log);
        if (!session.isSilent()) {
            session.getPlayer().sendMessage(this.plugin.getLangManager().get("messages.undo.sessions.undone"));
        }
        this.showUndoSession(session);
    }

    public void redoIndividualLog(UndoSession session, int logHash) {
        LogEntry log = (LogEntry)session.getProcessedLog(logHash);
        if (log == null) {
            this.plugin.getLangManager().sendMessage((CommandSender)session.getPlayer(), "messages.invalidLog");
            return;
        }
        if (session.isUndone(logHash)) {
            this.plugin.getRestoreManager().restore(log, (CommandSender)session.getPlayer(), session.isVerbose());
        }
        session.unmarkUndone(logHash);
        if (!session.isSilent()) {
            session.getPlayer().sendMessage(this.plugin.getLangManager().get("messages.undo.sessions.redone"));
        }
        this.showUndoSession(session);
    }

    public void undoAllLogs(UndoSession session) {
        session.getProcessedLogHashes().forEach((hash, logEntry) -> {
            if (!session.isUndone((int)hash)) {
                this.plugin.getUndoManager().undoRestore((LogEntry)logEntry, (CommandSender)session.getPlayer(), session.isVerbose());
                session.markAsUndone((int)hash, logEntry);
            }
        });
        if (!session.isSilent()) {
            session.getPlayer().sendMessage(this.plugin.getLangManager().get("messages.undo.sessions.undoneall"));
        }
        this.showUndoSession(session);
    }

    public void exitSession(UndoSession session) {
        Player player = session.getPlayer();
        PlayerProtect playerProtect = PlayerProtect.getPlayer(player);
        if (playerProtect != null) {
            playerProtect.setUndoSession(null);
        }
        if (!session.isSilent()) {
            this.plugin.getLangManager().sendMessage((CommandSender)player, "messages.undo.sessions.exited");
        }
    }
}

