/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.maps;

import java.util.Arrays;
import java.util.Objects;

public final class ObjectLongMap<K> {
    private static final int DEFAULT_CAPACITY = 16;
    private static final float LOAD_FACTOR = 0.75f;
    private static final long EMPTY_VALUE = Long.MIN_VALUE;
    private Object[] keys;
    private long[] values;
    private boolean[] occupied;
    private int size;
    private int threshold;
    private int mask;

    public ObjectLongMap(int initialCapacity) {
        int capacity = Integer.highestOneBit(initialCapacity - 1) << 1;
        if (capacity < 16) {
            capacity = 16;
        }
        this.keys = new Object[capacity];
        this.values = new long[capacity];
        this.occupied = new boolean[capacity];
        this.mask = capacity - 1;
        this.threshold = (int)((float)capacity * 0.75f);
    }

    private static int hash(Object key) {
        int h = key.hashCode();
        h ^= h >>> 16;
        h *= 73244475;
        h ^= h >>> 16;
        return h;
    }

    public long getLong(Object key) {
        if (key == null) {
            return Long.MIN_VALUE;
        }
        int idx = ObjectLongMap.hash(key) & this.mask;
        while (this.occupied[idx]) {
            if (Objects.equals(this.keys[idx], key)) {
                return this.values[idx];
            }
            idx = idx + 1 & this.mask;
        }
        return Long.MIN_VALUE;
    }

    public boolean containsKey(Object key) {
        if (key == null) {
            return false;
        }
        int idx = ObjectLongMap.hash(key) & this.mask;
        while (this.occupied[idx]) {
            if (Objects.equals(this.keys[idx], key)) {
                return true;
            }
            idx = idx + 1 & this.mask;
        }
        return false;
    }

    public long put(K key, long value) {
        if (key == null) {
            throw new NullPointerException();
        }
        if (this.size >= this.threshold) {
            this.resize();
        }
        int idx = ObjectLongMap.hash(key) & this.mask;
        while (this.occupied[idx]) {
            if (Objects.equals(this.keys[idx], key)) {
                long oldValue = this.values[idx];
                this.values[idx] = value;
                return oldValue;
            }
            idx = idx + 1 & this.mask;
        }
        this.keys[idx] = key;
        this.values[idx] = value;
        this.occupied[idx] = true;
        ++this.size;
        return Long.MIN_VALUE;
    }

    public long removeLong(Object key) {
        if (key == null) {
            return Long.MIN_VALUE;
        }
        int idx = ObjectLongMap.hash(key) & this.mask;
        while (this.occupied[idx]) {
            if (Objects.equals(this.keys[idx], key)) {
                long oldValue = this.values[idx];
                this.keys[idx] = null;
                this.occupied[idx] = false;
                int nextIdx = idx + 1 & this.mask;
                while (this.occupied[nextIdx]) {
                    Object moveKey = this.keys[nextIdx];
                    long moveValue = this.values[nextIdx];
                    this.keys[nextIdx] = null;
                    this.occupied[nextIdx] = false;
                    int moveIdx = ObjectLongMap.hash(moveKey) & this.mask;
                    while (this.occupied[moveIdx]) {
                        moveIdx = moveIdx + 1 & this.mask;
                    }
                    this.keys[moveIdx] = moveKey;
                    this.values[moveIdx] = moveValue;
                    this.occupied[moveIdx] = true;
                    nextIdx = nextIdx + 1 & this.mask;
                }
                --this.size;
                return oldValue;
            }
            idx = idx + 1 & this.mask;
        }
        return Long.MIN_VALUE;
    }

    private void resize() {
        Object[] oldKeys = this.keys;
        long[] oldValues = this.values;
        boolean[] oldOccupied = this.occupied;
        int oldCapacity = this.keys.length;
        int newCapacity = oldCapacity << 1;
        this.keys = new Object[newCapacity];
        this.values = new long[newCapacity];
        this.occupied = new boolean[newCapacity];
        this.mask = newCapacity - 1;
        this.threshold = (int)((float)newCapacity * 0.75f);
        this.size = 0;
        for (int i = 0; i < oldCapacity; ++i) {
            if (!oldOccupied[i]) continue;
            this.put(oldKeys[i], oldValues[i]);
        }
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void clear() {
        Arrays.fill(this.keys, null);
        Arrays.fill(this.occupied, false);
        this.size = 0;
    }
}

