/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.maps;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;

public final class ObjectObjectMap<K, V> {
    private static final int DEFAULT_CAPACITY = 16;
    private static final float LOAD_FACTOR = 0.75f;
    private Object[] keys;
    private Object[] values;
    private byte[] distances;
    private int size;
    private int threshold;
    private int mask;

    public ObjectObjectMap(int initialCapacity) {
        int capacity = Integer.highestOneBit(initialCapacity - 1) << 1;
        if (capacity < 16) {
            capacity = 16;
        }
        this.keys = new Object[capacity];
        this.values = new Object[capacity];
        this.distances = new byte[capacity];
        this.mask = capacity - 1;
        this.threshold = (int)((float)capacity * 0.75f);
    }

    private static int hash(Object key) {
        int h = key.hashCode();
        h ^= h >>> 16;
        return h;
    }

    public V get(Object key) {
        if (key == null) {
            return null;
        }
        int hash = ObjectObjectMap.hash(key);
        int idx = hash & this.mask;
        for (byte distance = 0; this.keys[idx] != null && distance <= this.distances[idx]; distance = (byte)(distance + 1)) {
            if (Objects.equals(this.keys[idx], key)) {
                return (V)this.values[idx];
            }
            idx = idx + 1 & this.mask;
        }
        return null;
    }

    public V put(K key, V value) {
        if (key == null) {
            return null;
        }
        if (this.size >= this.threshold) {
            this.resize();
        }
        int hash = ObjectObjectMap.hash(key);
        int idx = hash & this.mask;
        Object insertKey = key;
        Object insertValue = value;
        byte insertDistance = 0;
        while (true) {
            if (this.keys[idx] == null) {
                this.keys[idx] = insertKey;
                this.values[idx] = insertValue;
                this.distances[idx] = insertDistance;
                ++this.size;
                return null;
            }
            if (Objects.equals(this.keys[idx], insertKey)) {
                Object oldValue = this.values[idx];
                this.values[idx] = insertValue;
                return (V)oldValue;
            }
            if (insertDistance > this.distances[idx]) {
                Object tempKey = this.keys[idx];
                Object tempValue = this.values[idx];
                byte tempDistance = this.distances[idx];
                this.keys[idx] = insertKey;
                this.values[idx] = insertValue;
                this.distances[idx] = insertDistance;
                insertKey = tempKey;
                insertValue = tempValue;
                insertDistance = tempDistance;
            }
            idx = idx + 1 & this.mask;
            insertDistance = (byte)(insertDistance + 1);
        }
    }

    public V remove(Object key) {
        if (key == null) {
            return null;
        }
        int hash = ObjectObjectMap.hash(key);
        int idx = hash & this.mask;
        for (byte distance = 0; this.keys[idx] != null && distance <= this.distances[idx]; distance = (byte)(distance + 1)) {
            if (Objects.equals(this.keys[idx], key)) {
                Object oldValue = this.values[idx];
                int nextIdx = idx + 1 & this.mask;
                while (this.keys[nextIdx] != null && this.distances[nextIdx] > 0) {
                    this.keys[idx] = this.keys[nextIdx];
                    this.values[idx] = this.values[nextIdx];
                    this.distances[idx] = (byte)(this.distances[nextIdx] - 1);
                    idx = nextIdx;
                    nextIdx = nextIdx + 1 & this.mask;
                }
                this.keys[idx] = null;
                this.values[idx] = null;
                this.distances[idx] = 0;
                --this.size;
                return (V)oldValue;
            }
            idx = idx + 1 & this.mask;
        }
        return null;
    }

    public Collection<V> values() {
        return new AbstractCollection<V>(){

            @Override
            public Iterator<V> iterator() {
                return new Iterator<V>(){
                    private int index = 0;
                    private int returned = 0;

                    @Override
                    public boolean hasNext() {
                        return this.returned < ObjectObjectMap.this.size;
                    }

                    @Override
                    public V next() {
                        while (ObjectObjectMap.this.keys[this.index] == null) {
                            ++this.index;
                        }
                        ++this.returned;
                        return ObjectObjectMap.this.values[this.index++];
                    }
                };
            }

            @Override
            public int size() {
                return ObjectObjectMap.this.size;
            }
        };
    }

    private void resize() {
        Object[] oldKeys = this.keys;
        Object[] oldValues = this.values;
        int oldCapacity = this.keys.length;
        int newCapacity = oldCapacity << 1;
        this.keys = new Object[newCapacity];
        this.values = new Object[newCapacity];
        this.distances = new byte[newCapacity];
        this.mask = newCapacity - 1;
        this.threshold = (int)((float)newCapacity * 0.75f);
        this.size = 0;
        for (int i = 0; i < oldCapacity; ++i) {
            if (oldKeys[i] == null) continue;
            this.put(oldKeys[i], oldValues[i]);
        }
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }
}

