/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.nms.v1_20_R3;

import io.github.insideranh.stellarprotect.entities.DataEntity;
import io.github.insideranh.stellarprotect.entities.DataEntityType;
import io.github.insideranh.stellarprotect.utils.InventorySerializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.Rotation;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Allay;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Axolotl;
import org.bukkit.entity.Bee;
import org.bukkit.entity.Camel;
import org.bukkit.entity.Cat;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Fox;
import org.bukkit.entity.Frog;
import org.bukkit.entity.GlowItemFrame;
import org.bukkit.entity.Goat;
import org.bukkit.entity.Hoglin;
import org.bukkit.entity.Horse;
import org.bukkit.entity.IronGolem;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Llama;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Panda;
import org.bukkit.entity.Parrot;
import org.bukkit.entity.Phantom;
import org.bukkit.entity.Pig;
import org.bukkit.entity.Piglin;
import org.bukkit.entity.Rabbit;
import org.bukkit.entity.Sheep;
import org.bukkit.entity.Shulker;
import org.bukkit.entity.Slime;
import org.bukkit.entity.Sniffer;
import org.bukkit.entity.Snowman;
import org.bukkit.entity.Strider;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.TropicalFish;
import org.bukkit.entity.Villager;
import org.bukkit.entity.Warden;
import org.bukkit.entity.Wolf;
import org.bukkit.entity.Zombie;
import org.bukkit.entity.ZombieVillager;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MerchantRecipe;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.EulerAngle;

public class DataEntity_v1_20_R3
implements DataEntity {
    private final HashMap<String, Object> data = new HashMap();
    private ItemStack[] armor;
    private ItemStack mainHand;
    private ItemStack offHand;

    public DataEntity_v1_20_R3(Entity entity) {
        this.readEntityData(entity);
    }

    public DataEntity_v1_20_R3(HashMap<String, Object> data) {
        this.data.putAll(data);
    }

    public DataEntity_v1_20_R3() {
    }

    private void readEntityData(Entity entity) {
        this.setData(DataEntityType.ENTITY_TYPE, entity.getType().name());
        if (entity.getCustomName() != null) {
            this.setData(DataEntityType.CUSTOM_NAME, entity.getCustomName());
        }
        this.setData((Enum<?>)DataEntityType.CUSTOM_NAME_VISIBLE, entity.isCustomNameVisible());
        this.setData((Enum<?>)DataEntityType.GLOWING, entity.isGlowing());
        this.setData((Enum<?>)DataEntityType.GRAVITY, entity.hasGravity());
        this.setData((Enum<?>)DataEntityType.INVULNERABLE, entity.isInvulnerable());
        this.setData((Enum<?>)DataEntityType.SILENT, entity.isSilent());
        if (entity instanceof LivingEntity) {
            this.readLivingEntityData((LivingEntity)entity);
        }
        if (entity instanceof ArmorStand) {
            this.readArmorStandData((ArmorStand)entity);
        }
        if (entity instanceof ItemFrame) {
            this.readItemFrameData((ItemFrame)entity);
        }
    }

    private void readLivingEntityData(LivingEntity entity) {
        Collection effects;
        this.setData((Enum<?>)DataEntityType.HEALTH, entity.getHealth());
        this.setData((Enum<?>)DataEntityType.MAX_HEALTH, entity.getAttribute(Attribute.GENERIC_MAX_HEALTH).getBaseValue());
        this.setData((Enum<?>)DataEntityType.AI, entity.hasAI());
        this.setData((Enum<?>)DataEntityType.CAN_PICKUP_ITEMS, entity.getCanPickupItems());
        this.setData((Enum<?>)DataEntityType.COLLIDABLE, entity.isCollidable());
        this.setData((Enum<?>)DataEntityType.REMAINING_AIR, entity.getRemainingAir());
        if (entity.getEquipment() != null) {
            EntityEquipment eq = entity.getEquipment();
            this.armor = eq.getArmorContents();
            this.mainHand = eq.getItemInMainHand();
            this.offHand = eq.getItemInOffHand();
        }
        if (!(effects = entity.getActivePotionEffects()).isEmpty()) {
            ArrayList<String> effectsList = new ArrayList<String>();
            for (PotionEffect effect : effects) {
                effectsList.add(effect.getType().getName() + ":" + effect.getDuration() + ":" + effect.getAmplifier());
            }
            this.setData(DataEntityType.POTION_EFFECTS, String.join((CharSequence)";", effectsList));
        }
        if (entity instanceof Mob) {
            this.readMobData((Mob)entity);
        }
        if (entity instanceof Ageable) {
            Ageable ageable = (Ageable)entity;
            this.setData((Enum<?>)DataEntityType.AGE, ageable.getAge());
            this.setData((Enum<?>)DataEntityType.BABY, !ageable.isAdult());
            this.setData((Enum<?>)DataEntityType.AGE_LOCK, ageable.getAgeLock());
        }
        if (entity instanceof Tameable) {
            Tameable tameable = (Tameable)entity;
            this.setData((Enum<?>)DataEntityType.TAMED, tameable.isTamed());
            if (tameable.getOwner() != null) {
                this.setData(DataEntityType.OWNER_UUID, tameable.getOwner().getUniqueId().toString());
            }
        }
        this.readSpecificMobData(entity);
    }

    private void readMobData(Mob mob) {
        this.setData((Enum<?>)DataEntityType.AWARE, mob.isAware());
        if (mob.getTarget() != null) {
            this.setData(DataEntityType.TARGET_UUID, mob.getTarget().getUniqueId().toString());
        }
    }

    private void readSpecificMobData(LivingEntity entity) {
        Shulker shulker;
        if (entity instanceof Villager) {
            Villager villager = (Villager)entity;
            this.setData(DataEntityType.VILLAGER_PROFESSION, villager.getProfession().getKey().getKey());
            this.setData(DataEntityType.VILLAGER_TYPE, villager.getVillagerType().getKey().getKey());
            this.setData((Enum<?>)DataEntityType.VILLAGER_LEVEL, villager.getVillagerLevel());
            this.setData((Enum<?>)DataEntityType.VILLAGER_EXPERIENCE, villager.getVillagerExperience());
            if (villager.getRecipes() != null && !villager.getRecipes().isEmpty()) {
                ArrayList<String> tradesData = new ArrayList<String>();
                for (MerchantRecipe recipe : villager.getRecipes()) {
                    StringBuilder tradeStr = new StringBuilder();
                    tradeStr.append(InventorySerializable.itemStackToBase64(recipe.getResult())).append("|");
                    tradeStr.append(InventorySerializable.itemStackToBase64((ItemStack)recipe.getIngredients().get(0))).append("|");
                    tradeStr.append(recipe.getIngredients().size() > 1 ? InventorySerializable.itemStackToBase64((ItemStack)recipe.getIngredients().get(1)) : "null").append("|");
                    tradeStr.append(recipe.getUses()).append("|");
                    tradeStr.append(recipe.getMaxUses()).append("|");
                    tradeStr.append(recipe.getVillagerExperience()).append("|");
                    tradeStr.append(recipe.getPriceMultiplier());
                    tradesData.add(tradeStr.toString());
                }
                this.setData(DataEntityType.VILLAGER_TRADES, String.join((CharSequence)";;", tradesData));
            }
        } else if (entity instanceof ZombieVillager) {
            ZombieVillager zVillager = (ZombieVillager)entity;
            this.setData(DataEntityType.VILLAGER_PROFESSION, zVillager.getVillagerProfession().getKey().getKey());
            this.setData(DataEntityType.VILLAGER_TYPE, zVillager.getVillagerType().getKey().getKey());
            this.setData((Enum<?>)DataEntityType.CONVERTING, zVillager.isConverting());
            if (zVillager.isConverting()) {
                this.setData((Enum<?>)DataEntityType.CONVERSION_TIME, zVillager.getConversionTime());
            }
        } else if (entity instanceof Wolf) {
            Wolf wolf = (Wolf)entity;
            this.setData((Enum<?>)DataEntityType.ANGRY, wolf.isAngry());
            if (wolf.isTamed()) {
                Color collarColor = wolf.getCollarColor().getColor();
                this.setData(DataEntityType.COLLAR_COLOR, collarColor.getRed() + "," + collarColor.getGreen() + "," + collarColor.getBlue());
            }
        } else if (entity instanceof Cat) {
            Cat cat = (Cat)entity;
            this.setData(DataEntityType.CAT_TYPE, cat.getCatType().getKey().getKey());
            if (cat.isTamed()) {
                Color collarColor = cat.getCollarColor().getColor();
                this.setData(DataEntityType.COLLAR_COLOR, collarColor.getRed() + "," + collarColor.getGreen() + "," + collarColor.getBlue());
            }
        } else if (entity instanceof Horse) {
            Horse horse = (Horse)entity;
            this.setData(DataEntityType.HORSE_COLOR, horse.getColor().name());
            this.setData(DataEntityType.HORSE_STYLE, horse.getStyle().name());
            this.setData((Enum<?>)DataEntityType.JUMP_STRENGTH, horse.getJumpStrength());
            if (horse.getInventory().getSaddle() != null) {
                this.setData((Enum<?>)DataEntityType.HAS_SADDLE, true);
            }
            if (horse.getInventory().getArmor() != null) {
                this.setData(DataEntityType.HORSE_ARMOR, horse.getInventory().getArmor());
            }
        } else if (entity instanceof Llama) {
            Llama llama = (Llama)entity;
            this.setData(DataEntityType.LLAMA_COLOR, llama.getColor().name());
            this.setData((Enum<?>)DataEntityType.LLAMA_STRENGTH, llama.getStrength());
            if (llama.getInventory().getDecor() != null) {
                this.setData(DataEntityType.LLAMA_CARPET, llama.getInventory().getDecor());
            }
        } else if (entity instanceof Parrot) {
            Parrot parrot = (Parrot)entity;
            this.setData(DataEntityType.PARROT_VARIANT, parrot.getVariant().name());
        } else if (entity instanceof Rabbit) {
            Rabbit rabbit = (Rabbit)entity;
            this.setData(DataEntityType.RABBIT_TYPE, rabbit.getRabbitType().name());
        } else if (entity instanceof Sheep) {
            Sheep sheep = (Sheep)entity;
            this.setData(DataEntityType.SHEEP_COLOR, sheep.getColor().name());
            this.setData((Enum<?>)DataEntityType.SHEEP_SHEARED, sheep.isSheared());
        } else if (entity instanceof Pig) {
            Pig pig = (Pig)entity;
            this.setData((Enum<?>)DataEntityType.PIG_SADDLED, pig.hasSaddle());
        } else if (entity instanceof Creeper) {
            Creeper creeper = (Creeper)entity;
            this.setData((Enum<?>)DataEntityType.CREEPER_POWERED, creeper.isPowered());
            this.setData((Enum<?>)DataEntityType.CREEPER_MAX_FUSE, creeper.getMaxFuseTicks());
            this.setData((Enum<?>)DataEntityType.CREEPER_EXPLOSION_RADIUS, creeper.getExplosionRadius());
        } else if (entity instanceof Enderman) {
            Enderman enderman = (Enderman)entity;
            if (enderman.getCarriedBlock() != null) {
                this.setData(DataEntityType.ENDERMAN_CARRIED_BLOCK, enderman.getCarriedBlock().getMaterial().name());
            }
        } else if (entity instanceof Slime) {
            Slime slime = (Slime)entity;
            this.setData((Enum<?>)DataEntityType.SLIME_SIZE, slime.getSize());
        } else if (entity instanceof Phantom) {
            Phantom phantom = (Phantom)entity;
            this.setData((Enum<?>)DataEntityType.PHANTOM_SIZE, phantom.getSize());
        } else if (entity instanceof TropicalFish) {
            TropicalFish fish = (TropicalFish)entity;
            this.setData(DataEntityType.TROPICAL_FISH_PATTERN, fish.getPattern().name());
            this.setData(DataEntityType.TROPICAL_FISH_BODY_COLOR, fish.getBodyColor().name());
            this.setData(DataEntityType.TROPICAL_FISH_PATTERN_COLOR, fish.getPatternColor().name());
        } else if (entity instanceof Axolotl) {
            Axolotl axolotl = (Axolotl)entity;
            this.setData(DataEntityType.AXOLOTL_VARIANT, axolotl.getVariant().name());
        } else if (entity instanceof Bee) {
            Bee bee = (Bee)entity;
            this.setData((Enum<?>)DataEntityType.BEE_HAS_NECTAR, bee.hasNectar());
            this.setData((Enum<?>)DataEntityType.BEE_HAS_STUNG, bee.hasStung());
            this.setData((Enum<?>)DataEntityType.BEE_ANGER, bee.getAnger());
        } else if (entity instanceof Fox) {
            Fox fox = (Fox)entity;
            this.setData(DataEntityType.FOX_TYPE, fox.getFoxType().name());
            this.setData((Enum<?>)DataEntityType.FOX_CROUCHING, fox.isCrouching());
            this.setData((Enum<?>)DataEntityType.FOX_SLEEPING, fox.isSleeping());
        } else if (entity instanceof Panda) {
            Panda panda = (Panda)entity;
            this.setData(DataEntityType.PANDA_MAIN_GENE, panda.getMainGene().name());
            this.setData(DataEntityType.PANDA_HIDDEN_GENE, panda.getHiddenGene().name());
        } else if (entity instanceof Piglin) {
            Piglin piglin = (Piglin)entity;
            this.setData((Enum<?>)DataEntityType.PIGLIN_IMMUNE_TO_ZOMBIFICATION, piglin.isImmuneToZombification());
            this.setData((Enum<?>)DataEntityType.PIGLIN_BABY, piglin.isBaby());
        } else if (entity instanceof Hoglin) {
            Hoglin hoglin = (Hoglin)entity;
            this.setData((Enum<?>)DataEntityType.HOGLIN_IMMUNE_TO_ZOMBIFICATION, hoglin.isImmuneToZombification());
            if (hoglin.isConverting()) {
                this.setData((Enum<?>)DataEntityType.HOGLIN_HUNTING_COOLDOWN, hoglin.getConversionTime());
            }
        } else if (entity instanceof Strider) {
            Strider strider = (Strider)entity;
            this.setData((Enum<?>)DataEntityType.STRIDER_SADDLED, strider.isShivering());
        } else if (entity instanceof Goat) {
            Goat goat = (Goat)entity;
            this.setData((Enum<?>)DataEntityType.GOAT_SCREAMING, goat.isScreaming());
        } else if (entity instanceof Frog) {
            Frog frog = (Frog)entity;
            this.setData(DataEntityType.FROG_VARIANT, frog.getVariant().getKey().getKey());
        } else if (entity instanceof Allay) {
            Allay allay = (Allay)entity;
            this.setData((Enum<?>)DataEntityType.ALLAY_CAN_DUPLICATE, allay.canDuplicate());
            this.setData((Enum<?>)DataEntityType.ALLAY_DUPLICATION_COOLDOWN, allay.getDuplicationCooldown());
        } else if (entity instanceof Warden) {
            Warden warden = (Warden)entity;
            this.setData((Enum<?>)DataEntityType.WARDEN_ANGER, warden.getAnger());
        } else if (entity instanceof Sniffer) {
            Sniffer sniffer = (Sniffer)entity;
            this.setData(DataEntityType.SNIFFER_STATE, sniffer.getState().name());
        } else if (entity instanceof Camel) {
            Camel camel = (Camel)entity;
            this.setData((Enum<?>)DataEntityType.CAMEL_DASHING, camel.isDashing());
        } else if (entity instanceof Zombie) {
            Zombie zombie = (Zombie)entity;
            this.setData((Enum<?>)DataEntityType.ZOMBIE_BABY, zombie.isBaby());
            this.setData((Enum<?>)DataEntityType.ZOMBIE_CONVERTING_DROWNED, zombie.isConverting());
        } else if (entity instanceof IronGolem) {
            IronGolem golem = (IronGolem)entity;
            this.setData((Enum<?>)DataEntityType.IRON_GOLEM_PLAYER_CREATED, golem.isPlayerCreated());
        } else if (entity instanceof Snowman) {
            Snowman snowman = (Snowman)entity;
            this.setData((Enum<?>)DataEntityType.SNOWMAN_DERP, snowman.isDerp());
        } else if (entity instanceof Shulker && (shulker = (Shulker)entity).getColor() != null) {
            this.setData(DataEntityType.SHULKER_COLOR, shulker.getColor().name());
        }
    }

    private void readArmorStandData(ArmorStand stand) {
        this.setData((Enum<?>)DataEntityType.ARMOR_STAND_ARMS, stand.hasArms());
        this.setData((Enum<?>)DataEntityType.ARMOR_STAND_BASE_PLATE, stand.hasBasePlate());
        this.setData((Enum<?>)DataEntityType.ARMOR_STAND_MARKER, stand.isMarker());
        this.setData((Enum<?>)DataEntityType.ARMOR_STAND_SMALL, stand.isSmall());
        this.setData((Enum<?>)DataEntityType.ARMOR_STAND_VISIBLE, stand.isVisible());
        this.setData(DataEntityType.ARMOR_STAND_HEAD_POSE, this.eulerToString(stand.getHeadPose()));
        this.setData(DataEntityType.ARMOR_STAND_BODY_POSE, this.eulerToString(stand.getBodyPose()));
        this.setData(DataEntityType.ARMOR_STAND_LEFT_ARM_POSE, this.eulerToString(stand.getLeftArmPose()));
        this.setData(DataEntityType.ARMOR_STAND_RIGHT_ARM_POSE, this.eulerToString(stand.getRightArmPose()));
        this.setData(DataEntityType.ARMOR_STAND_LEFT_LEG_POSE, this.eulerToString(stand.getLeftLegPose()));
        this.setData(DataEntityType.ARMOR_STAND_RIGHT_LEG_POSE, this.eulerToString(stand.getRightLegPose()));
        if (stand.getEquipment() != null) {
            EntityEquipment eq = stand.getEquipment();
            this.armor = eq.getArmorContents();
            this.mainHand = eq.getItemInMainHand();
            this.offHand = eq.getItemInOffHand();
        }
    }

    private void readItemFrameData(ItemFrame frame) {
        this.setData(DataEntityType.ITEM_FRAME_ITEM, frame.getItem());
        this.setData(DataEntityType.ITEM_FRAME_ROTATION, frame.getRotation().name());
        this.setData((Enum<?>)DataEntityType.ITEM_FRAME_VISIBLE, frame.isVisible());
        this.setData((Enum<?>)DataEntityType.ITEM_FRAME_FIXED, frame.isFixed());
        if (frame instanceof GlowItemFrame) {
            this.setData((Enum<?>)DataEntityType.ITEM_FRAME_GLOWING, true);
        }
    }

    @Override
    public void applyToEntity(Entity entity) {
        if (this.hasData(DataEntityType.CUSTOM_NAME)) {
            entity.setCustomName((String)this.getData(DataEntityType.CUSTOM_NAME));
        }
        entity.setCustomNameVisible(this.getBoolean(DataEntityType.CUSTOM_NAME_VISIBLE));
        entity.setGlowing(this.getBoolean(DataEntityType.GLOWING));
        entity.setGravity(this.getBoolean(DataEntityType.GRAVITY));
        entity.setInvulnerable(this.getBoolean(DataEntityType.INVULNERABLE));
        entity.setSilent(this.getBoolean(DataEntityType.SILENT));
        if (entity instanceof LivingEntity) {
            this.applyLivingEntityData((LivingEntity)entity);
        }
        if (entity instanceof ArmorStand) {
            this.applyArmorStandData((ArmorStand)entity);
        }
        if (entity instanceof ItemFrame) {
            this.applyItemFrameData((ItemFrame)entity);
        }
    }

    private void applyLivingEntityData(LivingEntity entity) {
        if (this.hasData(DataEntityType.HEALTH)) {
            entity.setHealth(Math.max(this.getDouble(DataEntityType.HEALTH), 1.0));
        }
        if (this.hasData(DataEntityType.MAX_HEALTH)) {
            entity.getAttribute(Attribute.GENERIC_MAX_HEALTH).setBaseValue(this.getDouble(DataEntityType.MAX_HEALTH));
        }
        entity.setAI(this.getBoolean(DataEntityType.AI));
        entity.setCanPickupItems(this.getBoolean(DataEntityType.CAN_PICKUP_ITEMS));
        entity.setCollidable(this.getBoolean(DataEntityType.COLLIDABLE));
        if (this.hasData(DataEntityType.REMAINING_AIR)) {
            entity.setRemainingAir(this.getInt(DataEntityType.REMAINING_AIR));
        }
        if (entity.getEquipment() != null) {
            EntityEquipment eq = entity.getEquipment();
            if (this.armor != null) {
                eq.setArmorContents(this.armor);
            }
            if (this.mainHand != null) {
                eq.setItemInMainHand(this.mainHand);
            }
            if (this.offHand != null) {
                eq.setItemInOffHand(this.offHand);
            }
        }
        if (this.hasData(DataEntityType.POTION_EFFECTS)) {
            String[] effects;
            String effectsStr = this.getString(DataEntityType.POTION_EFFECTS);
            for (String effect : effects = effectsStr.split(";")) {
                String[] parts = effect.split(":");
                PotionEffectType type = PotionEffectType.getByName((String)parts[0]);
                int duration = Integer.parseInt(parts[1]);
                int amplifier = Integer.parseInt(parts[2]);
                entity.addPotionEffect(new PotionEffect(type, duration, amplifier));
            }
        }
        if (entity instanceof Mob) {
            this.applyMobData((Mob)entity);
        }
        if (entity instanceof Ageable) {
            Ageable ageable = (Ageable)entity;
            if (this.hasData(DataEntityType.AGE)) {
                ageable.setAge(this.getInt(DataEntityType.AGE));
            }
            if (this.hasData(DataEntityType.AGE_LOCK)) {
                ageable.setAgeLock(this.getBoolean(DataEntityType.AGE_LOCK));
            }
        }
        if (entity instanceof Tameable) {
            Tameable tameable = (Tameable)entity;
            if (this.hasData(DataEntityType.TAMED)) {
                tameable.setTamed(this.getBoolean(DataEntityType.TAMED));
            }
            if (this.hasData(DataEntityType.OWNER_UUID)) {
                OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)UUID.fromString(this.getString(DataEntityType.OWNER_UUID)));
                tameable.setOwner((AnimalTamer)offlinePlayer);
            }
        }
        this.applySpecificMobData(entity);
    }

    private void applyMobData(Mob mob) {
        if (this.hasData(DataEntityType.AWARE)) {
            mob.setAware(this.getBoolean(DataEntityType.AWARE));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void applySpecificMobData(LivingEntity entity) {
        if (entity instanceof Villager) {
            String typeKey;
            Villager villager = (Villager)entity;
            if (this.hasData(DataEntityType.VILLAGER_PROFESSION)) {
                typeKey = this.getString(DataEntityType.VILLAGER_PROFESSION);
                for (Villager.Profession profession : Villager.Profession.values()) {
                    if (!profession.getKey().getKey().equals(typeKey)) continue;
                    villager.setProfession(profession);
                    break;
                }
            }
            if (this.hasData(DataEntityType.VILLAGER_TYPE)) {
                typeKey = this.getString(DataEntityType.VILLAGER_TYPE);
                for (Villager.Profession profession : Villager.Type.values()) {
                    if (!profession.getKey().getKey().equals(typeKey)) continue;
                    Bukkit.getLogger().info("Type " + typeKey);
                    villager.setVillagerType((Villager.Type)profession);
                    break;
                }
            }
            if (this.hasData(DataEntityType.VILLAGER_LEVEL)) {
                villager.setVillagerLevel(this.getInt(DataEntityType.VILLAGER_LEVEL));
            }
            if (this.hasData(DataEntityType.VILLAGER_EXPERIENCE)) {
                villager.setVillagerExperience(this.getInt(DataEntityType.VILLAGER_EXPERIENCE));
            }
            if (this.hasData(DataEntityType.VILLAGER_TRADES)) {
                String tradesStr = this.getString(DataEntityType.VILLAGER_TRADES);
                String[] tradesArray = tradesStr.split(";;");
                ArrayList<MerchantRecipe> recipes = new ArrayList<MerchantRecipe>();
                for (String tradeData : tradesArray) {
                    String[] parts = tradeData.split("\\|");
                    ItemStack result = InventorySerializable.itemStackFromBase64(parts[0]);
                    ItemStack ingredient1 = InventorySerializable.itemStackFromBase64(parts[1]);
                    ItemStack ingredient2 = InventorySerializable.itemStackFromBase64(parts[2]);
                    int uses = Integer.parseInt(parts[3]);
                    int maxUses = Integer.parseInt(parts[4]);
                    int exp = Integer.parseInt(parts[5]);
                    float priceMultiplier = Float.parseFloat(parts[6]);
                    MerchantRecipe recipe = new MerchantRecipe(result, maxUses);
                    recipe.addIngredient(ingredient1);
                    if (ingredient2 != null) {
                        recipe.addIngredient(ingredient2);
                    }
                    recipe.setUses(uses);
                    recipe.setVillagerExperience(exp);
                    recipe.setPriceMultiplier(priceMultiplier);
                    recipes.add(recipe);
                }
                villager.setRecipes(recipes);
            }
        } else if (entity instanceof ZombieVillager) {
            String typeKey;
            ZombieVillager zVillager = (ZombieVillager)entity;
            if (this.hasData(DataEntityType.VILLAGER_PROFESSION)) {
                typeKey = this.getString(DataEntityType.VILLAGER_PROFESSION);
                for (Villager.Profession profession : Villager.Profession.values()) {
                    if (!profession.getKey().getKey().equals(typeKey)) continue;
                    zVillager.setVillagerProfession(profession);
                    break;
                }
            }
            if (this.hasData(DataEntityType.VILLAGER_TYPE)) {
                typeKey = this.getString(DataEntityType.VILLAGER_TYPE);
                for (Villager.Profession profession : Villager.Type.values()) {
                    if (!profession.getKey().getKey().equals(typeKey)) continue;
                    zVillager.setVillagerType((Villager.Type)profession);
                    break;
                }
            }
        } else if (entity instanceof Wolf) {
            Wolf wolf = (Wolf)entity;
            if (this.hasData(DataEntityType.ANGRY)) {
                wolf.setAngry(this.getBoolean(DataEntityType.ANGRY));
            }
            if (this.hasData(DataEntityType.COLLAR_COLOR) && wolf.isTamed()) {
                void var7_64;
                String[] rgb = this.getString(DataEntityType.COLLAR_COLOR).split(",");
                Color color = Color.fromRGB((int)Integer.parseInt(rgb[0]), (int)Integer.parseInt(rgb[1]), (int)Integer.parseInt(rgb[2]));
                DyeColor[] dyeColorArray = DyeColor.values();
                int n = dyeColorArray.length;
                boolean bl = false;
                while (var7_64 < n) {
                    DyeColor dyeColor = dyeColorArray[var7_64];
                    if (dyeColor.getColor().equals((Object)color)) {
                        wolf.setCollarColor(dyeColor);
                        break;
                    }
                    ++var7_64;
                }
            }
        } else if (entity instanceof Cat) {
            Cat cat = (Cat)entity;
            if (this.hasData(DataEntityType.CAT_TYPE)) {
                String typeKey = this.getString(DataEntityType.CAT_TYPE);
                for (Cat.Type type : Cat.Type.values()) {
                    if (!type.getKey().getKey().equals(typeKey)) continue;
                    cat.setCatType(type);
                    break;
                }
            }
            if (this.hasData(DataEntityType.COLLAR_COLOR) && cat.isTamed()) {
                void var7_67;
                String[] rgb = this.getString(DataEntityType.COLLAR_COLOR).split(",");
                Color color = Color.fromRGB((int)Integer.parseInt(rgb[0]), (int)Integer.parseInt(rgb[1]), (int)Integer.parseInt(rgb[2]));
                DyeColor[] dyeColorArray = DyeColor.values();
                int n = dyeColorArray.length;
                boolean bl = false;
                while (var7_67 < n) {
                    DyeColor dyeColor = dyeColorArray[var7_67];
                    if (dyeColor.getColor().equals((Object)color)) {
                        cat.setCollarColor(dyeColor);
                        break;
                    }
                    ++var7_67;
                }
            }
        } else if (entity instanceof Horse) {
            Horse horse = (Horse)entity;
            if (this.hasData(DataEntityType.HORSE_COLOR)) {
                horse.setColor(Horse.Color.valueOf((String)this.getString(DataEntityType.HORSE_COLOR)));
            }
            if (this.hasData(DataEntityType.HORSE_STYLE)) {
                horse.setStyle(Horse.Style.valueOf((String)this.getString(DataEntityType.HORSE_STYLE)));
            }
            if (this.hasData(DataEntityType.JUMP_STRENGTH)) {
                horse.setJumpStrength(this.getDouble(DataEntityType.JUMP_STRENGTH));
            }
            if (this.hasData(DataEntityType.HORSE_ARMOR)) {
                horse.getInventory().setArmor((ItemStack)this.getData(DataEntityType.HORSE_ARMOR));
            }
        } else if (entity instanceof Llama) {
            Llama llama = (Llama)entity;
            if (this.hasData(DataEntityType.LLAMA_COLOR)) {
                llama.setColor(Llama.Color.valueOf((String)this.getString(DataEntityType.LLAMA_COLOR)));
            }
            if (this.hasData(DataEntityType.LLAMA_STRENGTH)) {
                llama.setStrength(this.getInt(DataEntityType.LLAMA_STRENGTH));
            }
            if (this.hasData(DataEntityType.LLAMA_CARPET)) {
                llama.getInventory().setDecor((ItemStack)this.getData(DataEntityType.LLAMA_CARPET));
            }
        } else if (entity instanceof Parrot) {
            Parrot parrot = (Parrot)entity;
            if (this.hasData(DataEntityType.PARROT_VARIANT)) {
                parrot.setVariant(Parrot.Variant.valueOf((String)this.getString(DataEntityType.PARROT_VARIANT)));
            }
        } else if (entity instanceof Rabbit) {
            Rabbit rabbit = (Rabbit)entity;
            if (this.hasData(DataEntityType.RABBIT_TYPE)) {
                rabbit.setRabbitType(Rabbit.Type.valueOf((String)this.getString(DataEntityType.RABBIT_TYPE)));
            }
        } else if (entity instanceof Sheep) {
            Sheep sheep = (Sheep)entity;
            if (this.hasData(DataEntityType.SHEEP_COLOR)) {
                sheep.setColor(DyeColor.valueOf((String)this.getString(DataEntityType.SHEEP_COLOR)));
            }
            if (this.hasData(DataEntityType.SHEEP_SHEARED)) {
                sheep.setSheared(this.getBoolean(DataEntityType.SHEEP_SHEARED));
            }
        } else if (entity instanceof Pig) {
            Pig pig = (Pig)entity;
            if (this.hasData(DataEntityType.PIG_SADDLED)) {
                pig.setSaddle(this.getBoolean(DataEntityType.PIG_SADDLED));
            }
        } else if (entity instanceof Creeper) {
            Creeper creeper = (Creeper)entity;
            if (this.hasData(DataEntityType.CREEPER_POWERED)) {
                creeper.setPowered(this.getBoolean(DataEntityType.CREEPER_POWERED));
            }
            if (this.hasData(DataEntityType.CREEPER_MAX_FUSE)) {
                creeper.setMaxFuseTicks(this.getInt(DataEntityType.CREEPER_MAX_FUSE));
            }
            if (this.hasData(DataEntityType.CREEPER_EXPLOSION_RADIUS)) {
                creeper.setExplosionRadius(this.getInt(DataEntityType.CREEPER_EXPLOSION_RADIUS));
            }
        } else if (entity instanceof Slime) {
            Slime slime = (Slime)entity;
            if (this.hasData(DataEntityType.SLIME_SIZE)) {
                slime.setSize(this.getInt(DataEntityType.SLIME_SIZE));
            }
        } else if (entity instanceof Phantom) {
            Phantom phantom = (Phantom)entity;
            if (this.hasData(DataEntityType.PHANTOM_SIZE)) {
                phantom.setSize(this.getInt(DataEntityType.PHANTOM_SIZE));
            }
        } else if (entity instanceof TropicalFish) {
            TropicalFish fish = (TropicalFish)entity;
            if (this.hasData(DataEntityType.TROPICAL_FISH_PATTERN)) {
                fish.setPattern(TropicalFish.Pattern.valueOf((String)this.getString(DataEntityType.TROPICAL_FISH_PATTERN)));
            }
            if (this.hasData(DataEntityType.TROPICAL_FISH_BODY_COLOR)) {
                fish.setBodyColor(DyeColor.valueOf((String)this.getString(DataEntityType.TROPICAL_FISH_BODY_COLOR)));
            }
            if (this.hasData(DataEntityType.TROPICAL_FISH_PATTERN_COLOR)) {
                fish.setPatternColor(DyeColor.valueOf((String)this.getString(DataEntityType.TROPICAL_FISH_PATTERN_COLOR)));
            }
        } else if (entity instanceof Axolotl) {
            Axolotl axolotl = (Axolotl)entity;
            if (this.hasData(DataEntityType.AXOLOTL_VARIANT)) {
                axolotl.setVariant(Axolotl.Variant.valueOf((String)this.getString(DataEntityType.AXOLOTL_VARIANT)));
            }
        } else if (entity instanceof Bee) {
            Bee bee = (Bee)entity;
            if (this.hasData(DataEntityType.BEE_HAS_NECTAR)) {
                bee.setHasNectar(this.getBoolean(DataEntityType.BEE_HAS_NECTAR));
            }
            if (this.hasData(DataEntityType.BEE_HAS_STUNG)) {
                bee.setHasStung(this.getBoolean(DataEntityType.BEE_HAS_STUNG));
            }
            if (this.hasData(DataEntityType.BEE_ANGER)) {
                bee.setAnger(this.getInt(DataEntityType.BEE_ANGER));
            }
        } else if (entity instanceof Fox) {
            Fox fox = (Fox)entity;
            if (this.hasData(DataEntityType.FOX_TYPE)) {
                fox.setFoxType(Fox.Type.valueOf((String)this.getString(DataEntityType.FOX_TYPE)));
            }
            if (this.hasData(DataEntityType.FOX_CROUCHING)) {
                fox.setCrouching(this.getBoolean(DataEntityType.FOX_CROUCHING));
            }
            if (this.hasData(DataEntityType.FOX_SLEEPING)) {
                fox.setSleeping(this.getBoolean(DataEntityType.FOX_SLEEPING));
            }
        } else if (entity instanceof Panda) {
            Panda panda = (Panda)entity;
            if (this.hasData(DataEntityType.PANDA_MAIN_GENE)) {
                panda.setMainGene(Panda.Gene.valueOf((String)this.getString(DataEntityType.PANDA_MAIN_GENE)));
            }
            if (this.hasData(DataEntityType.PANDA_HIDDEN_GENE)) {
                panda.setHiddenGene(Panda.Gene.valueOf((String)this.getString(DataEntityType.PANDA_HIDDEN_GENE)));
            }
        } else if (entity instanceof Piglin) {
            Piglin piglin = (Piglin)entity;
            if (this.hasData(DataEntityType.PIGLIN_IMMUNE_TO_ZOMBIFICATION)) {
                piglin.setImmuneToZombification(this.getBoolean(DataEntityType.PIGLIN_IMMUNE_TO_ZOMBIFICATION));
            }
            if (this.hasData(DataEntityType.PIGLIN_BABY)) {
                piglin.setBaby(this.getBoolean(DataEntityType.PIGLIN_BABY));
            }
        } else if (entity instanceof Hoglin) {
            Hoglin hoglin = (Hoglin)entity;
            if (this.hasData(DataEntityType.HOGLIN_IMMUNE_TO_ZOMBIFICATION)) {
                hoglin.setImmuneToZombification(this.getBoolean(DataEntityType.HOGLIN_IMMUNE_TO_ZOMBIFICATION));
            }
        } else if (entity instanceof Strider) {
            Strider strider = (Strider)entity;
            if (this.hasData(DataEntityType.STRIDER_SADDLED)) {
                strider.setSaddle(this.getBoolean(DataEntityType.STRIDER_SADDLED));
            }
        } else if (entity instanceof Goat) {
            Goat goat = (Goat)entity;
            if (this.hasData(DataEntityType.GOAT_SCREAMING)) {
                goat.setScreaming(this.getBoolean(DataEntityType.GOAT_SCREAMING));
            }
        } else if (entity instanceof Frog) {
            Frog frog = (Frog)entity;
            if (this.hasData(DataEntityType.FROG_VARIANT)) {
                String variantKey = this.getString(DataEntityType.FROG_VARIANT);
                for (Frog.Variant variant : Frog.Variant.values()) {
                    if (!variant.getKey().getKey().equals(variantKey)) continue;
                    frog.setVariant(variant);
                    break;
                }
            }
        } else if (entity instanceof Allay) {
            Allay allay = (Allay)entity;
            if (this.hasData(DataEntityType.ALLAY_CAN_DUPLICATE)) {
                allay.setCanDuplicate(this.getBoolean(DataEntityType.ALLAY_CAN_DUPLICATE));
            }
        } else if (entity instanceof Warden) {
            Warden allay = (Warden)entity;
        } else if (entity instanceof Sniffer) {
            Sniffer sniffer = (Sniffer)entity;
            if (this.hasData(DataEntityType.SNIFFER_STATE)) {
                sniffer.setState(Sniffer.State.valueOf((String)this.getString(DataEntityType.SNIFFER_STATE)));
            }
        } else if (entity instanceof Camel) {
            Camel camel = (Camel)entity;
            if (this.hasData(DataEntityType.CAMEL_DASHING)) {
                camel.setDashing(this.getBoolean(DataEntityType.CAMEL_DASHING));
            }
        } else if (entity instanceof Zombie) {
            Zombie zombie = (Zombie)entity;
            if (this.hasData(DataEntityType.ZOMBIE_BABY)) {
                zombie.setBaby(this.getBoolean(DataEntityType.ZOMBIE_BABY));
            }
        } else if (entity instanceof IronGolem) {
            IronGolem golem = (IronGolem)entity;
            if (this.hasData(DataEntityType.IRON_GOLEM_PLAYER_CREATED)) {
                golem.setPlayerCreated(this.getBoolean(DataEntityType.IRON_GOLEM_PLAYER_CREATED));
            }
        } else if (entity instanceof Snowman) {
            Snowman snowman = (Snowman)entity;
            if (this.hasData(DataEntityType.SNOWMAN_DERP)) {
                snowman.setDerp(this.getBoolean(DataEntityType.SNOWMAN_DERP));
            }
        } else if (entity instanceof Shulker) {
            Shulker shulker = (Shulker)entity;
            if (this.hasData(DataEntityType.SHULKER_COLOR)) {
                shulker.setColor(DyeColor.valueOf((String)this.getString(DataEntityType.SHULKER_COLOR)));
            }
        }
    }

    private void applyArmorStandData(ArmorStand stand) {
        if (this.hasData(DataEntityType.ARMOR_STAND_ARMS)) {
            stand.setArms(this.getBoolean(DataEntityType.ARMOR_STAND_ARMS));
        }
        if (this.hasData(DataEntityType.ARMOR_STAND_BASE_PLATE)) {
            stand.setBasePlate(this.getBoolean(DataEntityType.ARMOR_STAND_BASE_PLATE));
        }
        if (this.hasData(DataEntityType.ARMOR_STAND_MARKER)) {
            stand.setMarker(this.getBoolean(DataEntityType.ARMOR_STAND_MARKER));
        }
        if (this.hasData(DataEntityType.ARMOR_STAND_SMALL)) {
            stand.setSmall(this.getBoolean(DataEntityType.ARMOR_STAND_SMALL));
        }
        if (this.hasData(DataEntityType.ARMOR_STAND_VISIBLE)) {
            stand.setVisible(this.getBoolean(DataEntityType.ARMOR_STAND_VISIBLE));
        }
        if (this.hasData(DataEntityType.ARMOR_STAND_HEAD_POSE)) {
            stand.setHeadPose(this.stringToEuler(this.getString(DataEntityType.ARMOR_STAND_HEAD_POSE)));
        }
        if (this.hasData(DataEntityType.ARMOR_STAND_BODY_POSE)) {
            stand.setBodyPose(this.stringToEuler(this.getString(DataEntityType.ARMOR_STAND_BODY_POSE)));
        }
        if (this.hasData(DataEntityType.ARMOR_STAND_LEFT_ARM_POSE)) {
            stand.setLeftArmPose(this.stringToEuler(this.getString(DataEntityType.ARMOR_STAND_LEFT_ARM_POSE)));
        }
        if (this.hasData(DataEntityType.ARMOR_STAND_RIGHT_ARM_POSE)) {
            stand.setRightArmPose(this.stringToEuler(this.getString(DataEntityType.ARMOR_STAND_RIGHT_ARM_POSE)));
        }
        if (this.hasData(DataEntityType.ARMOR_STAND_LEFT_LEG_POSE)) {
            stand.setLeftLegPose(this.stringToEuler(this.getString(DataEntityType.ARMOR_STAND_LEFT_LEG_POSE)));
        }
        if (this.hasData(DataEntityType.ARMOR_STAND_RIGHT_LEG_POSE)) {
            stand.setRightLegPose(this.stringToEuler(this.getString(DataEntityType.ARMOR_STAND_RIGHT_LEG_POSE)));
        }
        if (stand.getEquipment() != null) {
            EntityEquipment eq = stand.getEquipment();
            if (this.armor != null) {
                eq.setArmorContents(this.armor);
            }
            if (this.mainHand != null) {
                eq.setItemInMainHand(this.mainHand);
            }
            if (this.offHand != null) {
                eq.setItemInOffHand(this.offHand);
            }
        }
    }

    private void applyItemFrameData(ItemFrame frame) {
        if (this.hasData(DataEntityType.ITEM_FRAME_ITEM)) {
            frame.setItem((ItemStack)this.getData(DataEntityType.ITEM_FRAME_ITEM));
        }
        if (this.hasData(DataEntityType.ITEM_FRAME_ROTATION)) {
            frame.setRotation(Rotation.valueOf((String)this.getString(DataEntityType.ITEM_FRAME_ROTATION)));
        }
        if (this.hasData(DataEntityType.ITEM_FRAME_VISIBLE)) {
            frame.setVisible(this.getBoolean(DataEntityType.ITEM_FRAME_VISIBLE));
        }
        if (this.hasData(DataEntityType.ITEM_FRAME_FIXED)) {
            frame.setFixed(this.getBoolean(DataEntityType.ITEM_FRAME_FIXED));
        }
    }

    private void setData(Enum<?> key, boolean value) {
        this.data.put(key.name(), value);
    }

    private void setData(Enum<?> key, int value) {
        this.data.put(key.name(), value);
    }

    private void setData(Enum<?> key, double value) {
        this.data.put(key.name(), value);
    }

    private void setData(Enum<?> key, String value) {
        if (value != null && !value.isEmpty()) {
            this.data.put(key.name(), value);
        }
    }

    private void setData(Enum<?> key, Object value) {
        if (value != null) {
            this.data.put(key.name(), value);
        }
    }

    private boolean hasData(Enum<?> key) {
        return this.data.containsKey(key.name());
    }

    private Object getData(Enum<?> key) {
        return this.data.get(key.name());
    }

    private boolean getBoolean(Enum<?> key) {
        return this.hasData(key) && (Boolean)this.getData(key) != false;
    }

    private int getInt(Enum<?> key) {
        return this.hasData(key) ? ((Number)this.getData(key)).intValue() : 0;
    }

    private double getDouble(Enum<?> key) {
        return this.hasData(key) ? ((Number)this.getData(key)).doubleValue() : 0.0;
    }

    private String getString(Enum<?> key) {
        return this.hasData(key) ? (String)this.getData(key) : "";
    }

    private String eulerToString(EulerAngle angle) {
        return angle.getX() + "," + angle.getY() + "," + angle.getZ();
    }

    private EulerAngle stringToEuler(String str) {
        String[] parts = str.split(",");
        return new EulerAngle(Double.parseDouble(parts[0]), Double.parseDouble(parts[1]), Double.parseDouble(parts[2]));
    }

    @Override
    public HashMap<String, Object> getData() {
        return this.data;
    }

    public ItemStack[] getArmor() {
        return this.armor;
    }

    public ItemStack getMainHand() {
        return this.mainHand;
    }

    public ItemStack getOffHand() {
        return this.offHand;
    }
}

