/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.trackers;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.insideranh.stellarprotect.StellarProtect;
import io.github.insideranh.stellarprotect.api.ProtectNMS;
import io.github.insideranh.stellarprotect.cache.LoggerCache;
import io.github.insideranh.stellarprotect.data.PlayerProtect;
import io.github.insideranh.stellarprotect.database.entries.players.PlayerTransactionEntry;
import io.github.insideranh.stellarprotect.enums.ActionType;
import io.github.insideranh.stellarprotect.items.ItemReference;
import io.github.insideranh.stellarprotect.maps.StringBooleanMap;
import io.github.insideranh.stellarprotect.utils.Debugger;
import io.github.insideranh.stellarprotect.utils.WorldUtils;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.DoubleChest;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ChestTransactionTracker
implements Listener {
    private static final ProtectNMS protectNMS = StellarProtect.getInstance().getProtectNMS();
    private static final ConcurrentHashMap<String, Location> playerChestLocations = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, ItemCount[]> initialInventoryStates = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, Long> lastActivity = new ConcurrentHashMap();
    private static final StringBooleanMap activeEditing = new StringBooleanMap();
    private static final long CLEANUP_THRESHOLD = 1800000L;
    private static final ArrayDeque<ItemCount[]> ARRAY_POOL = new ArrayDeque();
    private static final ArrayDeque<ItemCounter> COUNTER_POOL = new ArrayDeque();
    private static final int POOL_SIZE = 32;
    private final StellarProtect plugin = StellarProtect.getInstance();

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Block block = event.getClickedBlock();
        if (block == null || !WorldUtils.isValidChestBlock(block.getType())) {
            return;
        }
        Player player = event.getPlayer();
        Location chestLocation = block.getLocation();
        String playerName = player.getName();
        if (activeEditing.get(playerName)) {
            this.finishChestEditing(player);
        }
        playerChestLocations.put(playerName, chestLocation);
        activeEditing.put(playerName, true);
        this.plugin.getStellarTaskHook(() -> {
            if (activeEditing.get(playerName)) {
                this.captureInitialState(player, chestLocation);
            }
        }).runTask(chestLocation, 1L);
        String inventoryId = this.getInventoryId(playerName, chestLocation);
        lastActivity.put(inventoryId, System.currentTimeMillis());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onInventoryClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        if (!this.isValidChestInventory(event.getInventory())) {
            return;
        }
        String playerName = player.getName();
        Location chestLocation = playerChestLocations.get(playerName);
        if (chestLocation == null || !activeEditing.get(playerName)) {
            return;
        }
        String inventoryId = this.getInventoryId(playerName, chestLocation);
        lastActivity.put(inventoryId, System.currentTimeMillis());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onInventoryDrag(InventoryDragEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        if (!this.isValidChestInventory(event.getInventory())) {
            return;
        }
        String playerName = player.getName();
        Location chestLocation = playerChestLocations.get(playerName);
        if (chestLocation == null || !activeEditing.get(playerName)) {
            return;
        }
        String inventoryId = this.getInventoryId(playerName, chestLocation);
        lastActivity.put(inventoryId, System.currentTimeMillis());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onInventoryClose(InventoryCloseEvent event) {
        if (!(event.getPlayer() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getPlayer();
        if (activeEditing.get(player.getName())) {
            this.finishChestEditing(player);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        if (activeEditing.get(player.getName())) {
            this.finishChestEditing(player);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        Block block = event.getBlock();
        if (!WorldUtils.isValidChestBlock(block.getType())) {
            return;
        }
        Location chestLocation = block.getLocation();
        for (Map.Entry<String, Location> entry : playerChestLocations.entrySet()) {
            if (!entry.getValue().equals((Object)chestLocation)) continue;
            Player player = Bukkit.getPlayer((String)entry.getKey());
            if (player == null || !activeEditing.get(player.getName())) break;
            this.finishChestEditing(player);
            break;
        }
    }

    private void captureInitialState(Player player, Location chestLocation) {
        Block block = chestLocation.getBlock();
        if (!WorldUtils.isValidChestBlock(block.getType())) {
            return;
        }
        BlockState state = block.getState();
        if (!(state instanceof InventoryHolder)) {
            return;
        }
        InventoryHolder holder = (InventoryHolder)state;
        Inventory inventory = holder.getInventory();
        String inventoryId = this.getInventoryId(player.getName(), chestLocation);
        ItemCount[] snapshot = this.captureInventorySnapshot(inventory.getContents());
        initialInventoryStates.put(inventoryId, snapshot);
    }

    private void finishChestEditing(Player player) {
        BlockState state;
        Block block;
        String playerName = player.getName();
        Location chestLocation = playerChestLocations.get(playerName);
        if (chestLocation == null) {
            return;
        }
        String inventoryId = this.getInventoryId(playerName, chestLocation);
        ItemCount[] initialSnapshot = initialInventoryStates.get(inventoryId);
        if (initialSnapshot != null && WorldUtils.isValidChestBlock((block = chestLocation.getBlock()).getType()) && (state = block.getState()) instanceof InventoryHolder) {
            InventoryHolder holder = (InventoryHolder)state;
            Inventory inventory = holder.getInventory();
            ItemStack[] inventoryContents = inventory.getContents();
            this.plugin.getExecutor().execute(() -> {
                ItemCount[] currentSnapshot = this.captureInventorySnapshot(inventoryContents);
                TransactionResult result = this.compareSnapshots(playerName, chestLocation, initialSnapshot, currentSnapshot);
                if (!result.itemsAdded.isEmpty() || !result.itemsRemoved.isEmpty()) {
                    this.handleTransaction(player, result);
                }
                this.returnToPool(initialSnapshot);
                this.returnToPool(currentSnapshot);
            });
        }
        playerChestLocations.remove(playerName);
        activeEditing.remove(playerName);
        initialInventoryStates.remove(inventoryId);
        lastActivity.remove(inventoryId);
    }

    private boolean isValidChestInventory(Inventory inventory) {
        InventoryHolder holder = inventory.getHolder();
        if (holder instanceof BlockState) {
            BlockState state = (BlockState)holder;
            return WorldUtils.isValidChestBlock(state.getType());
        }
        return holder instanceof DoubleChest;
    }

    private String getInventoryId(String playerName, Location location) {
        return playerName.toLowerCase() + ":" + location.getWorld().getName() + ":" + location.getBlockX() + ":" + location.getBlockY() + ":" + location.getBlockZ();
    }

    private ItemCount[] captureInventorySnapshot(ItemStack[] contents) {
        ItemCounter counter;
        ItemCount[] array = this.getFromPool();
        if (array == null) {
            array = new ItemCount[54];
        }
        if ((counter = this.getCounterFromPool()) == null) {
            counter = new ItemCounter();
        }
        counter.reset();
        for (ItemStack item : contents) {
            if (item == null || item.getType() == Material.AIR) continue;
            counter.addItem(item);
        }
        int index = 0;
        for (int i = 0; i < counter.capacity && index < array.length; ++i) {
            if (counter.items[i] == null) continue;
            if (array[index] == null) {
                array[index] = new ItemCount();
            }
            array[index].item = counter.items[i];
            array[index].count = counter.counts[i];
            ++index;
        }
        if (index < array.length && array[index] != null) {
            array[index].item = null;
            array[index].count = 0;
        }
        this.returnCounterToPool(counter);
        return array;
    }

    /*
     * WARNING - void declaration
     */
    private TransactionResult compareSnapshots(String playerName, Location location, ItemCount[] initial, ItemCount[] current) {
        int hash;
        ItemCount ic;
        void var11_13;
        HashMap<ItemStack, Integer> added = new HashMap<ItemStack, Integer>();
        HashMap<ItemStack, Integer> removed = new HashMap<ItemStack, Integer>();
        HashMap<Integer, Integer> initialCounts = new HashMap<Integer, Integer>();
        HashMap<Integer, ItemStack> itemMap = new HashMap<Integer, ItemStack>();
        ItemCount[] itemCountArray = initial;
        int n = itemCountArray.length;
        boolean bl = false;
        while (var11_13 < n && (ic = itemCountArray[var11_13]) != null && ic.item != null) {
            int hash2 = this.generateItemHash(ic.item);
            initialCounts.put(hash2, initialCounts.getOrDefault(hash2, 0) + ic.count);
            itemMap.put(hash2, ic.item);
            ++var11_13;
        }
        HashMap<Integer, Integer> currentCounts = new HashMap<Integer, Integer>();
        for (ItemCount ic2 : current) {
            if (ic2 == null || ic2.item == null) break;
            int hash3 = this.generateItemHash(ic2.item);
            currentCounts.put(hash3, currentCounts.getOrDefault(hash3, 0) + ic2.count);
            itemMap.put(hash3, ic2.item);
        }
        for (Map.Entry entry : currentCounts.entrySet()) {
            int initialCount;
            hash = (Integer)entry.getKey();
            int currentCount = (Integer)entry.getValue();
            if (currentCount <= (initialCount = initialCounts.getOrDefault(hash, 0).intValue())) continue;
            added.put((ItemStack)itemMap.get(hash), currentCount - initialCount);
        }
        for (Map.Entry entry : initialCounts.entrySet()) {
            int currentCount;
            hash = (Integer)entry.getKey();
            int initialCount = (Integer)entry.getValue();
            if (initialCount <= (currentCount = currentCounts.getOrDefault(hash, 0).intValue())) continue;
            removed.put((ItemStack)itemMap.get(hash), initialCount - currentCount);
        }
        return new TransactionResult(playerName, location, added, removed);
    }

    private int generateItemHash(ItemStack item) {
        int hash = item.getType().ordinal();
        if (item.hasItemMeta()) {
            ItemMeta meta = item.getItemMeta();
            int customModelData = protectNMS.modelDataHashCode(meta);
            if (meta.hasDisplayName()) {
                hash = hash * 31 + meta.getDisplayName().hashCode();
            }
            if (meta.hasLore()) {
                hash = hash * 31 + Objects.hashCode(meta.getLore());
            }
            if (meta.hasEnchants()) {
                hash = hash * 31 + meta.getEnchants().hashCode();
            }
            if (customModelData != 0) {
                hash = hash * 31 + customModelData;
            }
        }
        return hash;
    }

    private void handleTransaction(Player player, TransactionResult result) {
        ItemReference itemReference;
        PlayerProtect playerProtect = PlayerProtect.getPlayer(player);
        if (playerProtect == null) {
            return;
        }
        HashMap<Long, Integer> itemsAdded = new HashMap<Long, Integer>();
        HashMap<Long, Integer> itemsRemoved = new HashMap<Long, Integer>();
        for (Map.Entry<ItemStack, Integer> entry : result.itemsAdded.entrySet()) {
            itemReference = this.plugin.getItemsManager().getItemReference(entry.getKey(), entry.getValue());
            itemsAdded.put(itemReference.getTemplateId(), entry.getValue());
        }
        for (Map.Entry<ItemStack, Integer> entry : result.itemsRemoved.entrySet()) {
            itemReference = this.plugin.getItemsManager().getItemReference(entry.getKey(), entry.getValue());
            itemsRemoved.put(itemReference.getTemplateId(), entry.getValue());
        }
        LoggerCache.addLog(new PlayerTransactionEntry(playerProtect.getPlayerId(), itemsAdded, itemsRemoved, result.chestLocation, ActionType.INVENTORY_TRANSACTION));
    }

    public JsonObject getInventoryContent(Inventory inventory) {
        JsonObject jsonObject = new JsonObject();
        ItemStack[] contents = inventory.getContents();
        for (int slot = 0; slot < contents.length; ++slot) {
            ItemStack item = contents[slot];
            if (item == null || item.getType() == Material.AIR) continue;
            ItemReference itemReference = this.plugin.getItemsManager().getItemReference(item, item.getAmount());
            JsonObject slotData = new JsonObject();
            slotData.addProperty("t", (Number)itemReference.getTemplateId());
            slotData.addProperty("a", (Number)item.getAmount());
            jsonObject.add(String.valueOf(slot), (JsonElement)slotData);
        }
        return jsonObject;
    }

    public void cleanupOldStates() {
        long currentTime = System.currentTimeMillis();
        ArrayList<String> keysToRemove = new ArrayList<String>();
        for (Map.Entry<String, Long> entry : lastActivity.entrySet()) {
            if (currentTime - entry.getValue() <= 1800000L) continue;
            keysToRemove.add(entry.getKey());
        }
        for (String key : keysToRemove) {
            ItemCount[] snapshot = initialInventoryStates.remove(key);
            if (snapshot != null) {
                this.returnToPool(snapshot);
            }
            lastActivity.remove(key);
        }
        ArrayList<String> playersToRemove = new ArrayList<String>();
        for (String playerName : playerChestLocations.keySet()) {
            if (Bukkit.getPlayer((String)playerName) != null) continue;
            playersToRemove.add(playerName);
        }
        for (String playerName : playersToRemove) {
            playerChestLocations.remove(playerName);
            activeEditing.remove(playerName);
        }
        Debugger.debugExtras("Limpieza completada. Eliminados " + keysToRemove.size() + " estados antiguos y " + playersToRemove.size() + " jugadores desconectados.");
    }

    private ItemCount[] getFromPool() {
        return ARRAY_POOL.poll();
    }

    private void returnToPool(ItemCount[] array) {
        if (array != null && ARRAY_POOL.size() < 32) {
            for (ItemCount ic : array) {
                if (ic == null) continue;
                ic.item = null;
                ic.count = 0;
            }
            ARRAY_POOL.offer(array);
        }
    }

    private ItemCounter getCounterFromPool() {
        return COUNTER_POOL.poll();
    }

    private void returnCounterToPool(ItemCounter counter) {
        if (counter != null && COUNTER_POOL.size() < 32) {
            COUNTER_POOL.offer(counter);
        }
    }

    static {
        for (int i = 0; i < 32; ++i) {
            ARRAY_POOL.offer(new ItemCount[54]);
            COUNTER_POOL.offer(new ItemCounter());
        }
    }

    private static class ItemCount {
        ItemStack item;
        int count;

        private ItemCount() {
        }
    }

    private static class ItemCounter {
        private static final int DEFAULT_CAPACITY = 64;
        ItemStack[] items = new ItemStack[this.capacity];
        int[] counts = new int[this.capacity];
        int[] hashes = new int[this.capacity];
        int capacity = 64;
        int size;

        ItemCounter() {
        }

        void reset() {
            Arrays.fill(this.items, 0, this.size, null);
            Arrays.fill(this.counts, 0, this.size, 0);
            Arrays.fill(this.hashes, 0, this.size, 0);
            this.size = 0;
        }

        void addItem(ItemStack item) {
            int hash = this.hashItem(item);
            for (int i = 0; i < this.size; ++i) {
                if (this.hashes[i] != hash || !this.itemsEqual(this.items[i], item)) continue;
                int n = i;
                this.counts[n] = this.counts[n] + item.getAmount();
                return;
            }
            if (this.size < this.capacity) {
                this.items[this.size] = item.clone();
                this.items[this.size].setAmount(1);
                this.counts[this.size] = item.getAmount();
                this.hashes[this.size] = hash;
                ++this.size;
            }
        }

        private int hashItem(ItemStack item) {
            int hash = item.getType().ordinal();
            ItemMeta meta = item.getItemMeta();
            if (meta != null) {
                int customModelData = protectNMS.modelDataHashCode(meta);
                if (meta.hasDisplayName()) {
                    hash = hash * 31 + meta.getDisplayName().hashCode();
                }
                if (meta.hasLore()) {
                    hash = hash * 31 + Objects.hashCode(meta.getLore());
                }
                if (meta.hasEnchants()) {
                    hash = hash * 31 + meta.getEnchants().hashCode();
                }
                if (customModelData != 0) {
                    hash = hash * 31 + customModelData;
                }
            }
            return hash;
        }

        private boolean itemsEqual(ItemStack a, ItemStack b) {
            int modelB;
            boolean bMeta;
            if (a.getType() != b.getType()) {
                return false;
            }
            boolean aMeta = a.hasItemMeta();
            if (aMeta != (bMeta = b.hasItemMeta())) {
                return false;
            }
            if (!aMeta) {
                return true;
            }
            ItemMeta metaA = a.getItemMeta();
            ItemMeta metaB = b.getItemMeta();
            int modelA = protectNMS.modelDataHashCode(metaA);
            return modelA == (modelB = protectNMS.modelDataHashCode(metaB)) && Objects.equals(metaA.getDisplayName(), metaB.getDisplayName()) && Objects.equals(metaA.getLore(), metaB.getLore()) && Objects.equals(metaA.getEnchants(), metaB.getEnchants());
        }
    }

    public static class TransactionResult {
        public final String playerName;
        public final Location chestLocation;
        public final Map<ItemStack, Integer> itemsAdded;
        public final Map<ItemStack, Integer> itemsRemoved;
        public final long timestamp;

        public TransactionResult(String playerName, Location chestLocation, Map<ItemStack, Integer> itemsAdded, Map<ItemStack, Integer> itemsRemoved) {
            this.playerName = playerName;
            this.chestLocation = chestLocation;
            this.itemsAdded = itemsAdded;
            this.itemsRemoved = itemsRemoved;
            this.timestamp = System.currentTimeMillis();
        }
    }
}

