/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.utils;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import io.github.insideranh.stellarprotect.api.ItemsProvider;
import io.github.insideranh.stellarprotect.api.ItemsProviderRegistry;
import io.github.insideranh.stellarprotect.items.ItemTemplate;
import lombok.Generated;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class SerializerUtils {
    private static final Gson gson = new Gson();

    public static String escapeJson(String value) {
        if (value == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder(value.length() + 16);
        block9: for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '\"': {
                    sb.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                default: {
                    if (c < ' ') {
                        sb.append(String.format("\\u%04x", c));
                        continue block9;
                    }
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static void setInventoryContent(Inventory inventory, JsonObject jsonObject) {
        ItemsProvider itemsProvider = ItemsProviderRegistry.getProvider();
        if (itemsProvider == null) {
            return;
        }
        inventory.clear();
        for (String slotKey : jsonObject.keySet()) {
            try {
                int slot = Integer.parseInt(slotKey);
                if (slot < 0 || slot >= inventory.getSize()) continue;
                JsonObject slotData = jsonObject.getAsJsonObject(slotKey);
                long templateId = slotData.get("t").getAsLong();
                int amount = slotData.get("a").getAsInt();
                ItemTemplate itemTemplate = itemsProvider.getItemTemplate(templateId);
                if (itemTemplate == null) continue;
                ItemStack item = itemTemplate.getBukkitItem().clone();
                item.setAmount(amount);
                inventory.setItem(slot, item);
            }
            catch (NullPointerException | NumberFormatException runtimeException) {}
        }
    }

    @Generated
    public static Gson getGson() {
        return gson;
    }
}

