/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.utils;

import io.github.insideranh.stellarprotect.StellarProtect;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Scanner;
import lombok.Generated;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.entity.Player;

public class UpdateChecker {
    private String version = "none";
    private boolean isNewVersion = false;

    public UpdateChecker() {
        String currentVersion = StellarProtect.getInstance().getDescription().getVersion();
        StellarProtect.getInstance().getStellarTaskHook(() -> {
            try (InputStream is = new URL("https://api.spigotmc.org/legacy/update.php?resource=127280/~").openStream();
                 Scanner scanner = new Scanner(is);){
                if (scanner.hasNext()) {
                    this.version = scanner.next();
                    this.isNewVersion = this.isNewerVersion(currentVersion, this.version);
                }
            }
            catch (IOException e) {
                StellarProtect.getInstance().getLogger().info("Unable to check for updates: " + e.getMessage());
            }
        }).runTask();
    }

    private boolean isNewerVersion(String currentVersion, String remoteVersion) {
        if (currentVersion.equals(remoteVersion)) {
            return false;
        }
        try {
            String[] currentParts = this.splitVersionAndSuffix(currentVersion);
            String[] remoteParts = this.splitVersionAndSuffix(remoteVersion);
            String currentNumeric = currentParts[0];
            String currentSuffix = currentParts[1];
            String remoteNumeric = remoteParts[0];
            String remoteSuffix = remoteParts[1];
            int numericComparison = this.compareNumericVersion(currentNumeric, remoteNumeric);
            if (numericComparison > 0) {
                return false;
            }
            if (numericComparison < 0) {
                return true;
            }
            return this.compareSuffix(currentSuffix, remoteSuffix) < 0;
        }
        catch (Exception e) {
            StellarProtect.getInstance().getLogger().warning("Error comparing versions: " + e.getMessage());
            return !currentVersion.equals(remoteVersion);
        }
    }

    private String[] splitVersionAndSuffix(String version) {
        String numeric = version.replaceAll("[^0-9.]", "");
        String suffix = version.replaceAll("[0-9.]", "");
        return new String[]{numeric, suffix};
    }

    private int compareNumericVersion(String v1, String v2) {
        String[] parts1 = v1.split("\\.");
        String[] parts2 = v2.split("\\.");
        int maxLength = Math.max(parts1.length, parts2.length);
        for (int i = 0; i < maxLength; ++i) {
            int num2;
            int num1 = i < parts1.length ? this.parseVersionPart(parts1[i]) : 0;
            int n = num2 = i < parts2.length ? this.parseVersionPart(parts2[i]) : 0;
            if (num1 == num2) continue;
            return Integer.compare(num1, num2);
        }
        return 0;
    }

    private int parseVersionPart(String part) {
        try {
            return Integer.parseInt(part);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private int compareSuffix(String s1, String s2) {
        if (s1.isEmpty() && !s2.isEmpty()) {
            return 1;
        }
        if (!s1.isEmpty() && s2.isEmpty()) {
            return -1;
        }
        if (s1.isEmpty() && s2.isEmpty()) {
            return 0;
        }
        return s1.compareTo(s2);
    }

    public void sendUpdateMessage(Player player) {
        if (this.version.equals("none") || !this.isNewVersion) {
            return;
        }
        String currentVersion = StellarProtect.getInstance().getDescription().getVersion();
        TextComponent textComponent = new TextComponent("\u00a76\u00a7lStellarProtect \u00a78| \u00a7fNew version available: \u00a7a" + this.version + " \u00a7fYour: \u00a7c" + currentVersion + " ");
        TextComponent download = new TextComponent("\u00a76[Download]");
        download.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, TextComponent.fromLegacyText((String)"\u00a7fClick to download")));
        download.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://modrinth.com/plugin/stellarprotect"));
        TextComponent changelog = new TextComponent(" \u00a76[Changelog]");
        changelog.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, TextComponent.fromLegacyText((String)"\u00a7fClick to see changelog")));
        changelog.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://modrinth.com/plugin/stellarprotect/changelog"));
        textComponent.addExtra((BaseComponent)download);
        textComponent.addExtra((BaseComponent)changelog);
        player.spigot().sendMessage((BaseComponent)textComponent);
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public boolean isNewVersion() {
        return this.isNewVersion;
    }
}

