/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.commands.arguments.lookups;

import io.github.insideranh.stellarprotect.StellarProtect;
import io.github.insideranh.stellarprotect.arguments.ArgumentsParser;
import io.github.insideranh.stellarprotect.arguments.PageArg;
import io.github.insideranh.stellarprotect.cache.keys.LocationCache;
import io.github.insideranh.stellarprotect.commands.StellarArgument;
import io.github.insideranh.stellarprotect.data.LookupSession;
import io.github.insideranh.stellarprotect.data.PlayerProtect;
import io.github.insideranh.stellarprotect.database.entries.LogEntry;
import io.github.insideranh.stellarprotect.enums.ActionType;
import io.github.insideranh.stellarprotect.utils.Debugger;
import io.github.insideranh.stellarprotect.utils.WorldUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class NextLookupArgument
extends StellarArgument {
    private final StellarProtect plugin = StellarProtect.getInstance();

    @Override
    public void onCommand(@NotNull CommandSender sender, String[] arguments) {
        if (!(sender instanceof Player)) {
            this.plugin.getLangManager().sendMessage(sender, "messages.onlyPlayer");
            return;
        }
        Player player = (Player)sender;
        PlayerProtect playerProtect = PlayerProtect.getPlayer(player);
        if (playerProtect == null) {
            return;
        }
        LookupSession lookupSession = playerProtect.getLookupSession();
        if (lookupSession == null) {
            return;
        }
        PageArg pageArg = ArgumentsParser.parsePage(arguments);
        if (playerProtect.getNextLookup() > System.currentTimeMillis()) {
            this.plugin.getLangManager().sendMessage(sender, "messages.waitingForLookup");
            return;
        }
        playerProtect.setNextLookup(System.currentTimeMillis() + 5000L);
        playerProtect.getPosibleLogs().clear();
        this.plugin.getLangManager().sendMessage(sender, "messages.loadingLookup");
        ((CompletableFuture)this.plugin.getProtectDatabase().getLogs(lookupSession.getDatabaseFilters(), false, pageArg.getSkip(), pageArg.getLimit()).thenAccept(callbackLookup -> {
            Map groupedLogs = (Map)callbackLookup.getLogs();
            long total = (long)Math.ceil((double)((Long)callbackLookup.getTotal()).longValue() / (double)pageArg.getPerPage());
            for (Map.Entry entry : groupedLogs.entrySet()) {
                LocationCache location = (LocationCache)entry.getKey();
                Set logs = (Set)entry.getValue();
                for (LogEntry logEntry : logs) {
                    ActionType actionType = ActionType.getById(logEntry.getActionType());
                    if (actionType == null) continue;
                    this.plugin.getInspectHandler().processLogEntry(player, logEntry);
                }
                this.plugin.getProtectNMS().sendActionTitle(player, this.plugin.getLangManager().get("messages.actions.location"), "\u00a7fClick to teleport!", "/stellarprotect t " + WorldUtils.getWorld(location.getWorldId()) + " " + location.getX() + " " + location.getY() + " " + location.getZ(), text -> text.replace("<location>", WorldUtils.getFormatedLocation(location)));
            }
            this.plugin.getProtectNMS().sendPageButtons(player, this.plugin.getLangManager().get("messages.pagesNav"), this.plugin.getLangManager().get("messages.clickPage"), pageArg.getPage(), pageArg.getPerPage(), (int)total);
            playerProtect.setNextLookup(System.currentTimeMillis() + 500L);
        })).exceptionally(error -> {
            this.plugin.getLangManager().sendMessage((CommandSender)player, "messages.noLogs");
            playerProtect.setNextLookup(System.currentTimeMillis() + 500L);
            error.printStackTrace();
            Debugger.debugLog("Error on lookup: " + error.getMessage());
            return null;
        });
    }

    @Override
    public List<String> onTabComplete(@NotNull CommandSender sender, String[] arguments) {
        return new ArrayList<String>();
    }
}

