/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.bson.codecs;

import io.github.insideranh.stellarprotect.libs.bson.BsonReader;
import io.github.insideranh.stellarprotect.libs.bson.BsonWriter;
import io.github.insideranh.stellarprotect.libs.bson.codecs.Codec;
import io.github.insideranh.stellarprotect.libs.bson.codecs.DecoderContext;
import io.github.insideranh.stellarprotect.libs.bson.codecs.EncoderContext;

public final class EnumCodec<T extends Enum<T>>
implements Codec<T> {
    private final Class<T> clazz;

    public EnumCodec(Class<T> clazz) {
        this.clazz = clazz;
    }

    @Override
    public T decode(BsonReader reader, DecoderContext decoderContext) {
        return Enum.valueOf(this.clazz, reader.readString());
    }

    @Override
    public void encode(BsonWriter writer, T value, EncoderContext encoderContext) {
        writer.writeString(((Enum)value).name());
    }

    @Override
    public Class<T> getEncoderClass() {
        return this.clazz;
    }
}

