/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.bson.codecs;

import io.github.insideranh.stellarprotect.libs.bson.BsonReader;
import io.github.insideranh.stellarprotect.libs.bson.BsonWriter;
import io.github.insideranh.stellarprotect.libs.bson.Transformer;
import io.github.insideranh.stellarprotect.libs.bson.UuidRepresentation;
import io.github.insideranh.stellarprotect.libs.bson.assertions.Assertions;
import io.github.insideranh.stellarprotect.libs.bson.codecs.AbstractMapCodec;
import io.github.insideranh.stellarprotect.libs.bson.codecs.BsonTypeClassMap;
import io.github.insideranh.stellarprotect.libs.bson.codecs.BsonTypeCodecMap;
import io.github.insideranh.stellarprotect.libs.bson.codecs.Codec;
import io.github.insideranh.stellarprotect.libs.bson.codecs.ContainerCodecHelper;
import io.github.insideranh.stellarprotect.libs.bson.codecs.DecoderContext;
import io.github.insideranh.stellarprotect.libs.bson.codecs.EncoderContext;
import io.github.insideranh.stellarprotect.libs.bson.codecs.OverridableUuidRepresentationCodec;
import io.github.insideranh.stellarprotect.libs.bson.codecs.configuration.CodecRegistry;
import java.util.Map;

final class MapCodec<M extends Map<String, Object>>
extends AbstractMapCodec<Object, M>
implements OverridableUuidRepresentationCodec<M> {
    private final BsonTypeCodecMap bsonTypeCodecMap;
    private final CodecRegistry registry;
    private final Transformer valueTransformer;
    private final UuidRepresentation uuidRepresentation;

    MapCodec(CodecRegistry registry, BsonTypeClassMap bsonTypeClassMap, Transformer valueTransformer, Class<M> clazz) {
        this(registry, new BsonTypeCodecMap(Assertions.notNull("bsonTypeClassMap", bsonTypeClassMap), registry), valueTransformer, UuidRepresentation.UNSPECIFIED, clazz);
    }

    private MapCodec(CodecRegistry registry, BsonTypeCodecMap bsonTypeCodecMap, Transformer valueTransformer, UuidRepresentation uuidRepresentation, Class<M> clazz) {
        super(clazz);
        this.registry = Assertions.notNull("registry", registry);
        this.bsonTypeCodecMap = bsonTypeCodecMap;
        this.valueTransformer = valueTransformer != null ? valueTransformer : value -> value;
        this.uuidRepresentation = uuidRepresentation;
    }

    @Override
    public Codec<M> withUuidRepresentation(UuidRepresentation uuidRepresentation) {
        if (this.uuidRepresentation.equals((Object)uuidRepresentation)) {
            return this;
        }
        return new MapCodec(this.registry, this.bsonTypeCodecMap, this.valueTransformer, uuidRepresentation, this.getEncoderClass());
    }

    @Override
    Object readValue(BsonReader reader, DecoderContext decoderContext) {
        return ContainerCodecHelper.readValue(reader, decoderContext, this.bsonTypeCodecMap, this.uuidRepresentation, this.registry, this.valueTransformer);
    }

    @Override
    void writeValue(BsonWriter writer, Object value, EncoderContext encoderContext) {
        Codec<?> codec = this.registry.get(value.getClass());
        encoderContext.encodeWithChildContext(codec, writer, value);
    }
}

