/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.mongodb.client.internal;

import io.github.insideranh.stellarprotect.libs.bson.BsonString;
import io.github.insideranh.stellarprotect.libs.bson.BsonValue;
import io.github.insideranh.stellarprotect.libs.bson.codecs.configuration.CodecRegistry;
import io.github.insideranh.stellarprotect.libs.bson.conversions.Bson;
import io.github.insideranh.stellarprotect.libs.mongodb.MongoNamespace;
import io.github.insideranh.stellarprotect.libs.mongodb.ReadConcern;
import io.github.insideranh.stellarprotect.libs.mongodb.ReadPreference;
import io.github.insideranh.stellarprotect.libs.mongodb.assertions.Assertions;
import io.github.insideranh.stellarprotect.libs.mongodb.client.ClientSession;
import io.github.insideranh.stellarprotect.libs.mongodb.client.DistinctIterable;
import io.github.insideranh.stellarprotect.libs.mongodb.client.cursor.TimeoutMode;
import io.github.insideranh.stellarprotect.libs.mongodb.client.internal.MongoIterableImpl;
import io.github.insideranh.stellarprotect.libs.mongodb.client.internal.OperationExecutor;
import io.github.insideranh.stellarprotect.libs.mongodb.client.model.Collation;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.TimeoutSettings;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.BatchCursor;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.ReadOperation;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.SyncOperations;
import io.github.insideranh.stellarprotect.libs.mongodb.lang.Nullable;
import java.util.concurrent.TimeUnit;

class DistinctIterableImpl<TDocument, TResult>
extends MongoIterableImpl<TResult>
implements DistinctIterable<TResult> {
    private final SyncOperations<TDocument> operations;
    private final Class<TResult> resultClass;
    private final String fieldName;
    private Bson filter;
    private long maxTimeMS;
    private Collation collation;
    private BsonValue comment;
    private Bson hint;
    private String hintString;

    DistinctIterableImpl(@Nullable ClientSession clientSession, MongoNamespace namespace, Class<TDocument> documentClass, Class<TResult> resultClass, CodecRegistry codecRegistry, ReadPreference readPreference, ReadConcern readConcern, OperationExecutor executor, String fieldName, Bson filter, boolean retryReads, TimeoutSettings timeoutSettings) {
        super(clientSession, executor, readConcern, readPreference, retryReads, timeoutSettings);
        this.operations = new SyncOperations<TDocument>(namespace, documentClass, readPreference, codecRegistry, retryReads, timeoutSettings);
        this.resultClass = Assertions.notNull("resultClass", resultClass);
        this.fieldName = Assertions.notNull("mapFunction", fieldName);
        this.filter = filter;
    }

    @Override
    public DistinctIterable<TResult> filter(@Nullable Bson filter) {
        this.filter = filter;
        return this;
    }

    @Override
    public DistinctIterable<TResult> maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }

    @Override
    public DistinctIterable<TResult> batchSize(int batchSize) {
        super.batchSize(batchSize);
        return this;
    }

    @Override
    public DistinctIterable<TResult> timeoutMode(TimeoutMode timeoutMode) {
        super.timeoutMode(timeoutMode);
        return this;
    }

    @Override
    public DistinctIterable<TResult> collation(@Nullable Collation collation) {
        this.collation = collation;
        return this;
    }

    @Override
    public DistinctIterable<TResult> comment(@Nullable String comment) {
        this.comment = comment == null ? null : new BsonString(comment);
        return this;
    }

    @Override
    public DistinctIterable<TResult> comment(@Nullable BsonValue comment) {
        this.comment = comment;
        return this;
    }

    @Override
    public DistinctIterable<TResult> hint(@Nullable Bson hint) {
        this.hint = hint;
        return this;
    }

    @Override
    public DistinctIterable<TResult> hintString(@Nullable String hint) {
        this.hintString = hint;
        return this;
    }

    @Override
    public ReadOperation<BatchCursor<TResult>> asReadOperation() {
        return this.operations.distinct(this.fieldName, this.filter, this.resultClass, this.collation, this.comment, this.hint, this.hintString);
    }

    @Override
    protected OperationExecutor getExecutor() {
        return this.getExecutor(this.operations.createTimeoutSettings(this.maxTimeMS));
    }
}

