/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.mongodb.client.model.search;

import io.github.insideranh.stellarprotect.libs.bson.BsonArray;
import io.github.insideranh.stellarprotect.libs.bson.BsonBinary;
import io.github.insideranh.stellarprotect.libs.bson.BsonBoolean;
import io.github.insideranh.stellarprotect.libs.bson.BsonDocument;
import io.github.insideranh.stellarprotect.libs.bson.BsonNull;
import io.github.insideranh.stellarprotect.libs.bson.Document;
import io.github.insideranh.stellarprotect.libs.bson.conversions.Bson;
import io.github.insideranh.stellarprotect.libs.bson.types.ObjectId;
import io.github.insideranh.stellarprotect.libs.mongodb.annotations.Beta;
import io.github.insideranh.stellarprotect.libs.mongodb.annotations.Reason;
import io.github.insideranh.stellarprotect.libs.mongodb.annotations.Sealed;
import io.github.insideranh.stellarprotect.libs.mongodb.assertions.Assertions;
import io.github.insideranh.stellarprotect.libs.mongodb.client.model.geojson.Point;
import io.github.insideranh.stellarprotect.libs.mongodb.client.model.search.AutocompleteSearchOperator;
import io.github.insideranh.stellarprotect.libs.mongodb.client.model.search.CompoundSearchOperatorBase;
import io.github.insideranh.stellarprotect.libs.mongodb.client.model.search.DateNearSearchOperator;
import io.github.insideranh.stellarprotect.libs.mongodb.client.model.search.DateRangeConstructibleBsonElement;
import io.github.insideranh.stellarprotect.libs.mongodb.client.model.search.DateRangeSearchOperatorBase;
import io.github.insideranh.stellarprotect.libs.mongodb.client.model.search.EqualsSearchOperator;
import io.github.insideranh.stellarprotect.libs.mongodb.client.model.search.ExistsSearchOperator;
import io.github.insideranh.stellarprotect.libs.mongodb.client.model.search.FieldSearchPath;
import io.github.insideranh.stellarprotect.libs.mongodb.client.model.search.GeoNearSearchOperator;
import io.github.insideranh.stellarprotect.libs.mongodb.client.model.search.InSearchOperator;
import io.github.insideranh.stellarprotect.libs.mongodb.client.model.search.MoreLikeThisSearchOperator;
import io.github.insideranh.stellarprotect.libs.mongodb.client.model.search.NumberNearSearchOperator;
import io.github.insideranh.stellarprotect.libs.mongodb.client.model.search.NumberRangeConstructibleBsonElement;
import io.github.insideranh.stellarprotect.libs.mongodb.client.model.search.NumberRangeSearchOperatorBase;
import io.github.insideranh.stellarprotect.libs.mongodb.client.model.search.PhraseConstructibleBsonElement;
import io.github.insideranh.stellarprotect.libs.mongodb.client.model.search.PhraseSearchOperator;
import io.github.insideranh.stellarprotect.libs.mongodb.client.model.search.QueryStringSearchOperator;
import io.github.insideranh.stellarprotect.libs.mongodb.client.model.search.RegexSearchOperator;
import io.github.insideranh.stellarprotect.libs.mongodb.client.model.search.SearchConstructibleBsonElement;
import io.github.insideranh.stellarprotect.libs.mongodb.client.model.search.SearchPath;
import io.github.insideranh.stellarprotect.libs.mongodb.client.model.search.SearchScore;
import io.github.insideranh.stellarprotect.libs.mongodb.client.model.search.TextSearchOperator;
import io.github.insideranh.stellarprotect.libs.mongodb.client.model.search.WildcardSearchOperator;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.Iterables;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.client.model.Util;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.Iterator;
import java.util.UUID;

@Sealed
@Beta(value={Reason.CLIENT})
public interface SearchOperator
extends Bson {
    public SearchOperator score(SearchScore var1);

    public static CompoundSearchOperatorBase compound() {
        return new SearchConstructibleBsonElement("compound");
    }

    public static ExistsSearchOperator exists(FieldSearchPath path) {
        return new SearchConstructibleBsonElement("exists", (Bson)new Document("path", Assertions.notNull("path", path).toValue()));
    }

    public static TextSearchOperator text(SearchPath path, String query) {
        return SearchOperator.text(Collections.singleton(Assertions.notNull("path", path)), Collections.singleton(Assertions.notNull("query", query)));
    }

    public static TextSearchOperator text(Iterable<? extends SearchPath> paths, Iterable<String> queries) {
        Iterator<String> queryIterator = Assertions.notNull("queries", queries).iterator();
        Assertions.isTrueArgument("queries must not be empty", queryIterator.hasNext());
        String firstQuery = queryIterator.next();
        Iterator<? extends SearchPath> pathIterator = Assertions.notNull("paths", paths).iterator();
        Assertions.isTrueArgument("paths must not be empty", pathIterator.hasNext());
        return new SearchConstructibleBsonElement("text", (Bson)new Document("query", queryIterator.hasNext() ? queries : firstQuery).append("path", Util.combineToBsonValue(pathIterator, false)));
    }

    public static AutocompleteSearchOperator autocomplete(FieldSearchPath path, String query, String ... queries) {
        return SearchOperator.autocomplete(path, Iterables.concat(Assertions.notNull("query", query), queries));
    }

    public static AutocompleteSearchOperator autocomplete(FieldSearchPath path, Iterable<String> queries) {
        Iterator<String> queryIterator = Assertions.notNull("queries", queries).iterator();
        Assertions.isTrueArgument("queries must not be empty", queryIterator.hasNext());
        String firstQuery = queryIterator.next();
        return new SearchConstructibleBsonElement("autocomplete", (Bson)new Document("query", queryIterator.hasNext() ? queries : firstQuery).append("path", Assertions.notNull("path", path).toValue()));
    }

    public static NumberRangeSearchOperatorBase numberRange(FieldSearchPath path, FieldSearchPath ... paths) {
        return SearchOperator.numberRange(Iterables.concat(Assertions.notNull("path", path), paths));
    }

    public static NumberRangeSearchOperatorBase numberRange(Iterable<? extends FieldSearchPath> paths) {
        Iterator<? extends FieldSearchPath> pathIterator = Assertions.notNull("paths", paths).iterator();
        Assertions.isTrueArgument("paths must not be empty", pathIterator.hasNext());
        return new NumberRangeConstructibleBsonElement("range", (Bson)new Document("path", Util.combineToBsonValue(pathIterator, true)));
    }

    public static DateRangeSearchOperatorBase dateRange(FieldSearchPath path, FieldSearchPath ... paths) {
        return SearchOperator.dateRange(Iterables.concat(Assertions.notNull("path", path), paths));
    }

    public static DateRangeSearchOperatorBase dateRange(Iterable<? extends FieldSearchPath> paths) {
        Iterator<? extends FieldSearchPath> pathIterator = Assertions.notNull("paths", paths).iterator();
        Assertions.isTrueArgument("paths must not be empty", pathIterator.hasNext());
        return new DateRangeConstructibleBsonElement("range", (Bson)new Document("path", Util.combineToBsonValue(pathIterator, true)));
    }

    public static NumberNearSearchOperator near(Number origin, Number pivot, FieldSearchPath path, FieldSearchPath ... paths) {
        return SearchOperator.near(origin, pivot, Iterables.concat(Assertions.notNull("path", path), paths));
    }

    public static NumberNearSearchOperator near(Number origin, Number pivot, Iterable<? extends FieldSearchPath> paths) {
        Iterator<? extends FieldSearchPath> pathIterator = Assertions.notNull("paths", paths).iterator();
        Assertions.isTrueArgument("paths must not be empty", pathIterator.hasNext());
        return new SearchConstructibleBsonElement("near", (Bson)new Document("origin", Assertions.notNull("origin", origin)).append("path", Util.combineToBsonValue(pathIterator, true)).append("pivot", Assertions.notNull("pivot", pivot)));
    }

    public static DateNearSearchOperator near(Instant origin, Duration pivot, FieldSearchPath path, FieldSearchPath ... paths) {
        return SearchOperator.near(origin, pivot, Iterables.concat(Assertions.notNull("path", path), paths));
    }

    public static DateNearSearchOperator near(Instant origin, Duration pivot, Iterable<? extends FieldSearchPath> paths) {
        Iterator<? extends FieldSearchPath> pathIterator = Assertions.notNull("paths", paths).iterator();
        Assertions.isTrueArgument("paths must not be empty", pathIterator.hasNext());
        Assertions.notNull("pivot", pivot);
        return new SearchConstructibleBsonElement("near", (Bson)new Document("origin", Assertions.notNull("origin", origin)).append("path", Util.combineToBsonValue(pathIterator, true)).append("pivot", pivot.toMillis()));
    }

    public static GeoNearSearchOperator near(Point origin, Number pivot, FieldSearchPath path, FieldSearchPath ... paths) {
        return SearchOperator.near(origin, pivot, Iterables.concat(Assertions.notNull("path", path), paths));
    }

    public static GeoNearSearchOperator near(Point origin, Number pivot, Iterable<? extends FieldSearchPath> paths) {
        Iterator<? extends FieldSearchPath> pathIterator = Assertions.notNull("paths", paths).iterator();
        Assertions.isTrueArgument("paths must not be empty", pathIterator.hasNext());
        return new SearchConstructibleBsonElement("near", (Bson)new Document("origin", Assertions.notNull("origin", origin)).append("path", Util.combineToBsonValue(pathIterator, true)).append("pivot", Assertions.notNull("pivot", pivot)));
    }

    public static InSearchOperator in(FieldSearchPath path, boolean value, boolean ... values) {
        Assertions.notNull("values", values);
        BsonArray bsonArray = new BsonArray();
        bsonArray.add(new BsonBoolean(value));
        for (boolean v : values) {
            bsonArray.add(new BsonBoolean(v));
        }
        return SearchOperator.in(Assertions.notNull("path", path), bsonArray);
    }

    public static InSearchOperator in(FieldSearchPath path, ObjectId value, ObjectId ... values) {
        return SearchOperator.in(Assertions.notNull("path", path), Iterables.concat(Assertions.notNull("value", value), values));
    }

    public static InSearchOperator in(FieldSearchPath path, Number value, Number ... values) {
        return SearchOperator.in(Assertions.notNull("path", path), Iterables.concat(Assertions.notNull("value", value), values));
    }

    public static InSearchOperator in(FieldSearchPath path, Instant value, Instant ... values) {
        return SearchOperator.in(Assertions.notNull("path", path), Iterables.concat(Assertions.notNull("value", value), values));
    }

    public static InSearchOperator in(FieldSearchPath path, UUID value, UUID ... values) {
        return SearchOperator.in(Assertions.notNull("path", path), Iterables.concat(Assertions.notNull("value", value), values));
    }

    public static InSearchOperator in(FieldSearchPath path, String value, String ... values) {
        return SearchOperator.in(Assertions.notNull("path", path), Iterables.concat(Assertions.notNull("value", value), values));
    }

    public static <T> InSearchOperator in(FieldSearchPath path, Iterable<? extends T> values) {
        Assertions.notNull("path", path);
        Iterator<T> valueIterator = Assertions.notNull("values", values).iterator();
        Assertions.isTrueArgument("values must not be empty", valueIterator.hasNext());
        T firstValue = valueIterator.next();
        boolean hasMore = valueIterator.hasNext();
        return new SearchConstructibleBsonElement("in", (Bson)new Document().append("path", path.toValue()).append("value", hasMore ? values : firstValue));
    }

    public static EqualsSearchOperator equals(FieldSearchPath path, boolean value) {
        return new SearchConstructibleBsonElement("equals", (Bson)new Document("path", Assertions.notNull("path", path).toValue()).append("value", value));
    }

    public static EqualsSearchOperator equals(FieldSearchPath path, ObjectId value) {
        return new SearchConstructibleBsonElement("equals", (Bson)new Document("path", Assertions.notNull("path", path).toValue()).append("value", Assertions.notNull("value", value)));
    }

    public static EqualsSearchOperator equals(FieldSearchPath path, Number value) {
        return new SearchConstructibleBsonElement("equals", (Bson)new Document("path", Assertions.notNull("path", path).toValue()).append("value", Assertions.notNull("value", value)));
    }

    public static EqualsSearchOperator equals(FieldSearchPath path, Instant value) {
        return new SearchConstructibleBsonElement("equals", (Bson)new Document("path", Assertions.notNull("path", path).toValue()).append("value", Assertions.notNull("value", value)));
    }

    public static EqualsSearchOperator equals(FieldSearchPath path, String value) {
        return new SearchConstructibleBsonElement("equals", (Bson)new Document("path", Assertions.notNull("path", path).toValue()).append("value", Assertions.notNull("value", value)));
    }

    public static EqualsSearchOperator equals(FieldSearchPath path, UUID value) {
        return new SearchConstructibleBsonElement("equals", (Bson)new Document("path", Assertions.notNull("path", path).toValue()).append("value", Assertions.notNull("value", new BsonBinary(value))));
    }

    public static EqualsSearchOperator equalsNull(FieldSearchPath path) {
        return new SearchConstructibleBsonElement("equals", (Bson)new Document("path", Assertions.notNull("path", path).toValue()).append("value", BsonNull.VALUE));
    }

    public static MoreLikeThisSearchOperator moreLikeThis(BsonDocument like) {
        return SearchOperator.moreLikeThis(Collections.singleton(Assertions.notNull("like", like)));
    }

    public static MoreLikeThisSearchOperator moreLikeThis(Iterable<BsonDocument> likes) {
        Iterator<BsonDocument> likesIterator = Assertions.notNull("likes", likes).iterator();
        Assertions.isTrueArgument("likes must not be empty", likesIterator.hasNext());
        BsonDocument firstLike = likesIterator.next();
        return new SearchConstructibleBsonElement("moreLikeThis", (Bson)new Document("like", likesIterator.hasNext() ? likes : firstLike));
    }

    public static QueryStringSearchOperator queryString(FieldSearchPath defaultPath, String query) {
        Assertions.isTrueArgument("path must not be empty", defaultPath != null);
        Assertions.isTrueArgument("query must not be empty", query != null);
        return new SearchConstructibleBsonElement("queryString", (Bson)new Document("defaultPath", defaultPath.toBsonValue()).append("query", query));
    }

    public static PhraseSearchOperator phrase(SearchPath path, String query) {
        return SearchOperator.phrase(Collections.singleton(Assertions.notNull("path", path)), Collections.singleton(Assertions.notNull("query", query)));
    }

    public static PhraseSearchOperator phrase(Iterable<? extends SearchPath> paths, Iterable<String> queries) {
        Iterator<? extends SearchPath> pathIterator = Assertions.notNull("paths", paths).iterator();
        Assertions.isTrueArgument("paths must not be empty", pathIterator.hasNext());
        Iterator<String> queryIterator = Assertions.notNull("queries", queries).iterator();
        Assertions.isTrueArgument("queries must not be empty", queryIterator.hasNext());
        String firstQuery = queryIterator.next();
        return new PhraseConstructibleBsonElement("phrase", (Bson)new Document("path", Util.combineToBsonValue(pathIterator, false)).append("query", queryIterator.hasNext() ? queries : firstQuery));
    }

    public static WildcardSearchOperator wildcard(SearchPath path, String query) {
        return SearchOperator.wildcard(Collections.singleton(Assertions.notNull("query", query)), Collections.singleton(Assertions.notNull("path", path)));
    }

    public static WildcardSearchOperator wildcard(Iterable<String> queries, Iterable<? extends SearchPath> paths) {
        Iterator<String> queryIterator = Assertions.notNull("queries", queries).iterator();
        Assertions.isTrueArgument("queries must not be empty", queryIterator.hasNext());
        String firstQuery = queryIterator.next();
        Iterator<? extends SearchPath> pathIterator = Assertions.notNull("paths", paths).iterator();
        Assertions.isTrueArgument("paths must not be empty", pathIterator.hasNext());
        return new SearchConstructibleBsonElement("wildcard", (Bson)new Document("query", queryIterator.hasNext() ? queries : firstQuery).append("path", Util.combineToBsonValue(pathIterator, false)));
    }

    public static RegexSearchOperator regex(SearchPath path, String query) {
        return SearchOperator.regex(Collections.singleton(Assertions.notNull("path", path)), Collections.singleton(Assertions.notNull("query", query)));
    }

    public static RegexSearchOperator regex(Iterable<? extends SearchPath> paths, Iterable<String> queries) {
        Iterator<? extends SearchPath> pathIterator = Assertions.notNull("paths", paths).iterator();
        Assertions.isTrueArgument("paths must not be empty", pathIterator.hasNext());
        Iterator<String> queryIterator = Assertions.notNull("queries", queries).iterator();
        Assertions.isTrueArgument("queries must not be empty", queryIterator.hasNext());
        String firstQuery = queryIterator.next();
        return new SearchConstructibleBsonElement("regex", (Bson)new Document("path", Util.combineToBsonValue(pathIterator, false)).append("query", queryIterator.hasNext() ? queries : firstQuery));
    }

    public static SearchOperator of(Bson operator) {
        return new SearchConstructibleBsonElement(Assertions.notNull("operator", operator));
    }
}

