/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.mongodb.internal.binding;

import io.github.insideranh.stellarprotect.libs.mongodb.connection.ClusterType;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.binding.AbstractReferenceCounted;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.binding.ReferenceCounted;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.Connection;
import io.github.insideranh.stellarprotect.libs.mongodb.lang.Nullable;
import io.github.insideranh.stellarprotect.libs.mongodb.session.ClientSession;
import java.util.function.BiConsumer;

public final class TransactionContext<C extends ReferenceCounted>
extends AbstractReferenceCounted {
    private final ClusterType clusterType;
    private C pinnedConnection;

    public TransactionContext(ClusterType clusterType) {
        this.clusterType = clusterType;
    }

    @Nullable
    public C getPinnedConnection() {
        return this.pinnedConnection;
    }

    public void pinConnection(C connection, BiConsumer<C, Connection.PinningMode> markAsPinnedOperation) {
        this.pinnedConnection = connection.retain();
        markAsPinnedOperation.accept(connection, Connection.PinningMode.TRANSACTION);
    }

    public boolean isConnectionPinningRequired() {
        return this.clusterType == ClusterType.LOAD_BALANCED;
    }

    @Override
    public int release() {
        int count = super.release();
        if (count == 0 && this.pinnedConnection != null) {
            this.pinnedConnection.release();
        }
        return count;
    }

    @Nullable
    public static <C extends TransactionContext<? extends ReferenceCounted>> C get(ClientSession session) {
        return (C)((TransactionContext)session.getTransactionContext());
    }
}

