/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.mongodb.internal.client.model.bulk;

import io.github.insideranh.stellarprotect.libs.mongodb.client.model.bulk.ClientBulkWriteResult;
import io.github.insideranh.stellarprotect.libs.mongodb.client.model.bulk.ClientDeleteResult;
import io.github.insideranh.stellarprotect.libs.mongodb.client.model.bulk.ClientInsertOneResult;
import io.github.insideranh.stellarprotect.libs.mongodb.client.model.bulk.ClientUpdateResult;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.client.model.bulk.AcknowledgedSummaryClientBulkWriteResult;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class AcknowledgedVerboseClientBulkWriteResult
implements ClientBulkWriteResult {
    private final AcknowledgedSummaryClientBulkWriteResult summaryResults;
    private final VerboseResults verboseResults;

    public AcknowledgedVerboseClientBulkWriteResult(AcknowledgedSummaryClientBulkWriteResult summaryResults, Map<Integer, ClientInsertOneResult> insertResults, Map<Integer, ClientUpdateResult> updateResults, Map<Integer, ClientDeleteResult> deleteResults) {
        this.summaryResults = summaryResults;
        this.verboseResults = new VerboseResults(insertResults, updateResults, deleteResults);
    }

    @Override
    public boolean isAcknowledged() {
        return true;
    }

    @Override
    public long getInsertedCount() {
        return this.summaryResults.getInsertedCount();
    }

    @Override
    public long getUpsertedCount() {
        return this.summaryResults.getUpsertedCount();
    }

    @Override
    public long getMatchedCount() {
        return this.summaryResults.getMatchedCount();
    }

    @Override
    public long getModifiedCount() {
        return this.summaryResults.getModifiedCount();
    }

    @Override
    public long getDeletedCount() {
        return this.summaryResults.getDeletedCount();
    }

    @Override
    public Optional<ClientBulkWriteResult.VerboseResults> getVerboseResults() {
        return Optional.of(this.verboseResults);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AcknowledgedVerboseClientBulkWriteResult that = (AcknowledgedVerboseClientBulkWriteResult)o;
        return Objects.equals(this.summaryResults, that.summaryResults) && Objects.equals(this.verboseResults, that.verboseResults);
    }

    public int hashCode() {
        return Objects.hash(this.summaryResults, this.verboseResults);
    }

    public String toString() {
        return "AcknowledgedVerboseClientBulkWriteResult{insertedCount=" + this.summaryResults.getInsertedCount() + ", upsertedCount=" + this.summaryResults.getUpsertedCount() + ", matchedCount=" + this.summaryResults.getMatchedCount() + ", modifiedCount=" + this.summaryResults.getModifiedCount() + ", deletedCount=" + this.summaryResults.getDeletedCount() + ", insertResults=" + this.verboseResults.insertResults + ", updateResults=" + this.verboseResults.updateResults + ", deleteResults=" + this.verboseResults.deleteResults + '}';
    }

    private static final class VerboseResults
    implements ClientBulkWriteResult.VerboseResults {
        private final Map<Integer, ClientInsertOneResult> insertResults;
        private final Map<Integer, ClientUpdateResult> updateResults;
        private final Map<Integer, ClientDeleteResult> deleteResults;

        VerboseResults(Map<Integer, ClientInsertOneResult> insertResults, Map<Integer, ClientUpdateResult> updateResults, Map<Integer, ClientDeleteResult> deleteResults) {
            this.insertResults = insertResults;
            this.updateResults = updateResults;
            this.deleteResults = deleteResults;
        }

        @Override
        public Map<Integer, ClientInsertOneResult> getInsertResults() {
            return this.insertResults;
        }

        @Override
        public Map<Integer, ClientUpdateResult> getUpdateResults() {
            return this.updateResults;
        }

        @Override
        public Map<Integer, ClientDeleteResult> getDeleteResults() {
            return this.deleteResults;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            VerboseResults verbose = (VerboseResults)o;
            return Objects.equals(this.insertResults, verbose.insertResults) && Objects.equals(this.updateResults, verbose.updateResults) && Objects.equals(this.deleteResults, verbose.deleteResults);
        }

        public int hashCode() {
            return Objects.hash(this.insertResults, this.updateResults, this.deleteResults);
        }

        public String toString() {
            return "AcknowledgedVerboseClientBulkWriteResult.VerboseResults{insertResults=" + this.insertResults + ", updateResults=" + this.updateResults + ", deleteResults=" + this.deleteResults + '}';
        }
    }
}

