/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.mongodb.internal.connection;

import io.github.insideranh.stellarprotect.libs.bson.BsonWriter;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.BsonWriterDecorator;

abstract class LevelCountingBsonWriter
extends BsonWriterDecorator {
    static final int DEFAULT_INITIAL_LEVEL = -1;
    private int level;

    LevelCountingBsonWriter(BsonWriter bsonWriter) {
        this(bsonWriter, -1);
    }

    LevelCountingBsonWriter(BsonWriter bsonWriter, int initialLevel) {
        super(bsonWriter);
        this.level = initialLevel;
    }

    int getCurrentLevel() {
        return this.level;
    }

    @Override
    public void writeStartDocument(String name) {
        ++this.level;
        super.writeStartDocument(name);
    }

    @Override
    public void writeStartDocument() {
        ++this.level;
        super.writeStartDocument();
    }

    @Override
    public void writeEndDocument() {
        --this.level;
        super.writeEndDocument();
    }

    @Override
    public void writeStartArray() {
        ++this.level;
        super.writeStartArray();
    }

    @Override
    public void writeStartArray(String name) {
        ++this.level;
        super.writeStartArray(name);
    }

    @Override
    public void writeEndArray() {
        --this.level;
        super.writeEndArray();
    }
}

