/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.mongodb.internal.operation;

import io.github.insideranh.stellarprotect.libs.bson.BsonDocument;
import io.github.insideranh.stellarprotect.libs.bson.BsonString;
import io.github.insideranh.stellarprotect.libs.bson.BsonValue;
import io.github.insideranh.stellarprotect.libs.bson.codecs.BsonDocumentCodec;
import io.github.insideranh.stellarprotect.libs.bson.codecs.Decoder;
import io.github.insideranh.stellarprotect.libs.mongodb.MongoCommandException;
import io.github.insideranh.stellarprotect.libs.mongodb.MongoNamespace;
import io.github.insideranh.stellarprotect.libs.mongodb.assertions.Assertions;
import io.github.insideranh.stellarprotect.libs.mongodb.connection.ConnectionDescription;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.async.SingleResultCallback;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.binding.AsyncReadBinding;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.binding.ReadBinding;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.AsyncOperationHelper;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.AsyncReadOperation;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.CommandOperationHelper;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.CommandResultDocumentCodec;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.OperationReadConcernHelper;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.ReadOperation;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.SyncOperationHelper;
import io.github.insideranh.stellarprotect.libs.mongodb.lang.Nullable;
import java.util.Collections;

public class EstimatedDocumentCountOperation
implements AsyncReadOperation<Long>,
ReadOperation<Long> {
    private static final Decoder<BsonDocument> DECODER = new BsonDocumentCodec();
    private final MongoNamespace namespace;
    private boolean retryReads;
    private BsonValue comment;

    public EstimatedDocumentCountOperation(MongoNamespace namespace) {
        this.namespace = Assertions.notNull("namespace", namespace);
    }

    public EstimatedDocumentCountOperation retryReads(boolean retryReads) {
        this.retryReads = retryReads;
        return this;
    }

    @Nullable
    public BsonValue getComment() {
        return this.comment;
    }

    public EstimatedDocumentCountOperation comment(@Nullable BsonValue comment) {
        this.comment = comment;
        return this;
    }

    @Override
    public Long execute(ReadBinding binding) {
        try {
            return SyncOperationHelper.executeRetryableRead(binding, this.namespace.getDatabaseName(), this.getCommandCreator(), CommandResultDocumentCodec.create(DECODER, Collections.singletonList("firstBatch")), this.transformer(), this.retryReads);
        }
        catch (MongoCommandException e) {
            return Assertions.assertNotNull(CommandOperationHelper.rethrowIfNotNamespaceError(e, 0L));
        }
    }

    @Override
    public void executeAsync(AsyncReadBinding binding, SingleResultCallback<Long> callback) {
        AsyncOperationHelper.executeRetryableReadAsync(binding, this.namespace.getDatabaseName(), this.getCommandCreator(), CommandResultDocumentCodec.create(DECODER, Collections.singletonList("firstBatch")), this.asyncTransformer(), this.retryReads, (result, t) -> {
            if (CommandOperationHelper.isNamespaceError(t)) {
                callback.onResult(0L, null);
            } else {
                callback.onResult((Long)result, t);
            }
        });
    }

    private SyncOperationHelper.CommandReadTransformer<BsonDocument, Long> transformer() {
        return (result, source, connection) -> this.transformResult((BsonDocument)result, connection.getDescription());
    }

    private AsyncOperationHelper.CommandReadTransformerAsync<BsonDocument, Long> asyncTransformer() {
        return (result, source, connection) -> this.transformResult((BsonDocument)result, connection.getDescription());
    }

    private long transformResult(BsonDocument result, ConnectionDescription connectionDescription) {
        return result.getNumber("n").longValue();
    }

    private CommandOperationHelper.CommandCreator getCommandCreator() {
        return (operationContext, serverDescription, connectionDescription) -> {
            BsonDocument document = new BsonDocument("count", new BsonString(this.namespace.getCollectionName()));
            OperationReadConcernHelper.appendReadConcernToCommand(operationContext.getSessionContext(), connectionDescription.getMaxWireVersion(), document);
            if (this.comment != null) {
                document.put("comment", this.comment);
            }
            return document;
        };
    }
}

