/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.mongodb.internal.operation;

import io.github.insideranh.stellarprotect.libs.bson.BsonDocument;
import io.github.insideranh.stellarprotect.libs.bson.BsonNumber;
import io.github.insideranh.stellarprotect.libs.bson.BsonString;
import io.github.insideranh.stellarprotect.libs.bson.BsonValue;
import io.github.insideranh.stellarprotect.libs.bson.codecs.configuration.CodecRegistry;
import io.github.insideranh.stellarprotect.libs.mongodb.client.model.IndexModel;
import io.github.insideranh.stellarprotect.libs.mongodb.client.model.SearchIndexModel;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public final class IndexHelper {
    public static List<String> getIndexNames(List<IndexModel> indexes, CodecRegistry codecRegistry) {
        ArrayList<String> indexNames = new ArrayList<String>(indexes.size());
        for (IndexModel index : indexes) {
            String name = index.getOptions().getName();
            if (name != null) {
                indexNames.add(name);
                continue;
            }
            indexNames.add(IndexHelper.generateIndexName(index.getKeys().toBsonDocument(BsonDocument.class, codecRegistry)));
        }
        return indexNames;
    }

    public static List<String> getSearchIndexNames(List<SearchIndexModel> indexes) {
        return indexes.stream().map(IndexHelper::getSearchIndexName).collect(Collectors.toList());
    }

    private static String getSearchIndexName(SearchIndexModel model) {
        String name = model.getName();
        return name != null ? name : "default";
    }

    public static String generateIndexName(BsonDocument index) {
        StringBuilder indexName = new StringBuilder();
        for (String keyNames : index.keySet()) {
            if (indexName.length() != 0) {
                indexName.append('_');
            }
            indexName.append(keyNames).append('_');
            BsonValue ascOrDescValue = index.get(keyNames);
            if (ascOrDescValue instanceof BsonNumber) {
                indexName.append(((BsonNumber)ascOrDescValue).intValue());
                continue;
            }
            if (!(ascOrDescValue instanceof BsonString)) continue;
            indexName.append(((BsonString)ascOrDescValue).getValue().replace(' ', '_'));
        }
        return indexName.toString();
    }

    private IndexHelper() {
    }
}

