/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.mongodb.internal.operation;

import io.github.insideranh.stellarprotect.libs.bson.BsonDocument;
import io.github.insideranh.stellarprotect.libs.bson.BsonString;
import io.github.insideranh.stellarprotect.libs.bson.BsonValue;
import io.github.insideranh.stellarprotect.libs.bson.codecs.Codec;
import io.github.insideranh.stellarprotect.libs.bson.codecs.Decoder;
import io.github.insideranh.stellarprotect.libs.mongodb.MongoCommandException;
import io.github.insideranh.stellarprotect.libs.mongodb.MongoNamespace;
import io.github.insideranh.stellarprotect.libs.mongodb.assertions.Assertions;
import io.github.insideranh.stellarprotect.libs.mongodb.client.cursor.TimeoutMode;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.async.AsyncBatchCursor;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.async.ErrorHandlingResultCallback;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.async.SingleResultCallback;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.async.function.AsyncCallbackSupplier;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.async.function.RetryState;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.binding.AsyncReadBinding;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.binding.ReadBinding;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.AsyncOperationHelper;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.AsyncReadOperation;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.AsyncSingleBatchCursor;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.BatchCursor;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.CommandOperationHelper;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.CommandResultDocumentCodec;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.CursorHelper;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.DocumentHelper;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.OperationHelper;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.ReadOperation;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.SingleBatchCursor;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.SyncOperationHelper;
import io.github.insideranh.stellarprotect.libs.mongodb.lang.Nullable;
import java.util.function.Supplier;

public class ListIndexesOperation<T>
implements AsyncReadOperation<AsyncBatchCursor<T>>,
ReadOperation<BatchCursor<T>> {
    private final MongoNamespace namespace;
    private final Decoder<T> decoder;
    private boolean retryReads;
    private int batchSize;
    private BsonValue comment;
    private TimeoutMode timeoutMode = TimeoutMode.CURSOR_LIFETIME;

    public ListIndexesOperation(MongoNamespace namespace, Decoder<T> decoder) {
        this.namespace = Assertions.notNull("namespace", namespace);
        this.decoder = Assertions.notNull("decoder", decoder);
    }

    public Integer getBatchSize() {
        return this.batchSize;
    }

    public ListIndexesOperation<T> batchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public ListIndexesOperation<T> retryReads(boolean retryReads) {
        this.retryReads = retryReads;
        return this;
    }

    public boolean getRetryReads() {
        return this.retryReads;
    }

    @Nullable
    public BsonValue getComment() {
        return this.comment;
    }

    public ListIndexesOperation<T> comment(@Nullable BsonValue comment) {
        this.comment = comment;
        return this;
    }

    public TimeoutMode getTimeoutMode() {
        return this.timeoutMode;
    }

    public ListIndexesOperation<T> timeoutMode(@Nullable TimeoutMode timeoutMode) {
        if (timeoutMode != null) {
            this.timeoutMode = timeoutMode;
        }
        return this;
    }

    @Override
    public BatchCursor<T> execute(ReadBinding binding) {
        RetryState retryState = CommandOperationHelper.initialRetryState(this.retryReads, binding.getOperationContext().getTimeoutContext());
        Supplier<BatchCursor> read = SyncOperationHelper.decorateReadWithRetries(retryState, binding.getOperationContext(), () -> SyncOperationHelper.withSourceAndConnection(binding::getReadConnectionSource, false, (source, connection) -> {
            retryState.breakAndThrowIfRetryAnd(() -> !OperationHelper.canRetryRead(source.getServerDescription(), binding.getOperationContext()));
            try {
                return SyncOperationHelper.createReadCommandAndExecute(retryState, binding.getOperationContext(), source, this.namespace.getDatabaseName(), this.getCommandCreator(), this.createCommandDecoder(), this.transformer(), connection);
            }
            catch (MongoCommandException e) {
                return CommandOperationHelper.rethrowIfNotNamespaceError(e, SingleBatchCursor.createEmptySingleBatchCursor(source.getServerDescription().getAddress(), this.batchSize));
            }
        }));
        return read.get();
    }

    @Override
    public void executeAsync(AsyncReadBinding binding, SingleResultCallback<AsyncBatchCursor<T>> callback) {
        RetryState retryState = CommandOperationHelper.initialRetryState(this.retryReads, binding.getOperationContext().getTimeoutContext());
        binding.retain();
        AsyncCallbackSupplier<AsyncBatchCursor<T>> asyncRead = AsyncOperationHelper.decorateReadWithRetriesAsync(retryState, binding.getOperationContext(), funcCallback -> AsyncOperationHelper.withAsyncSourceAndConnection(binding::getReadConnectionSource, false, funcCallback, (source, connection, releasingCallback) -> {
            if (retryState.breakAndCompleteIfRetryAnd(() -> !OperationHelper.canRetryRead(source.getServerDescription(), binding.getOperationContext()), releasingCallback)) {
                return;
            }
            AsyncOperationHelper.createReadCommandAndExecuteAsync(retryState, binding.getOperationContext(), source, this.namespace.getDatabaseName(), this.getCommandCreator(), this.createCommandDecoder(), this.asyncTransformer(), connection, (result, t) -> {
                if (t != null && !CommandOperationHelper.isNamespaceError(t)) {
                    releasingCallback.onResult(null, t);
                } else {
                    releasingCallback.onResult(result != null ? result : AsyncSingleBatchCursor.createEmptyAsyncSingleBatchCursor(this.getBatchSize()), null);
                }
            });
        })).whenComplete(binding::release);
        asyncRead.get(ErrorHandlingResultCallback.errorHandlingCallback(callback, OperationHelper.LOGGER));
    }

    private CommandOperationHelper.CommandCreator getCommandCreator() {
        return (operationContext, serverDescription, connectionDescription) -> {
            BsonDocument commandDocument = new BsonDocument("listIndexes", new BsonString(this.namespace.getCollectionName())).append("cursor", CursorHelper.getCursorDocumentFromBatchSize(this.batchSize == 0 ? null : Integer.valueOf(this.batchSize)));
            OperationHelper.setNonTailableCursorMaxTimeSupplier(this.timeoutMode, operationContext);
            DocumentHelper.putIfNotNull(commandDocument, "comment", this.comment);
            return commandDocument;
        };
    }

    private SyncOperationHelper.CommandReadTransformer<BsonDocument, BatchCursor<T>> transformer() {
        return (result, source, connection) -> SyncOperationHelper.cursorDocumentToBatchCursor(this.timeoutMode, result, this.batchSize, this.decoder, this.comment, source, connection);
    }

    private AsyncOperationHelper.CommandReadTransformerAsync<BsonDocument, AsyncBatchCursor<T>> asyncTransformer() {
        return (result, source, connection) -> AsyncOperationHelper.cursorDocumentToAsyncBatchCursor(this.timeoutMode, result, this.batchSize, this.decoder, this.comment, source, connection);
    }

    private Codec<BsonDocument> createCommandDecoder() {
        return CommandResultDocumentCodec.create(this.decoder, "firstBatch");
    }
}

