/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.mongodb.internal.operation;

import io.github.insideranh.stellarprotect.libs.bson.BsonDocument;
import io.github.insideranh.stellarprotect.libs.mongodb.ClientBulkWriteException;
import io.github.insideranh.stellarprotect.libs.mongodb.MongoClientException;
import io.github.insideranh.stellarprotect.libs.mongodb.MongoException;
import io.github.insideranh.stellarprotect.libs.mongodb.WriteConcern;
import io.github.insideranh.stellarprotect.libs.mongodb.assertions.Assertions;
import io.github.insideranh.stellarprotect.libs.mongodb.client.cursor.TimeoutMode;
import io.github.insideranh.stellarprotect.libs.mongodb.client.model.Collation;
import io.github.insideranh.stellarprotect.libs.mongodb.connection.ConnectionDescription;
import io.github.insideranh.stellarprotect.libs.mongodb.connection.ServerDescription;
import io.github.insideranh.stellarprotect.libs.mongodb.connection.ServerType;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.async.SingleResultCallback;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.bulk.DeleteRequest;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.bulk.UpdateRequest;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.bulk.WriteRequest;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.OperationContext;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.diagnostics.logging.Logger;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.diagnostics.logging.Loggers;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.ServerVersionHelper;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.session.SessionContext;
import io.github.insideranh.stellarprotect.libs.mongodb.lang.NonNull;
import io.github.insideranh.stellarprotect.libs.mongodb.lang.Nullable;
import java.util.List;

public final class OperationHelper {
    public static final Logger LOGGER = Loggers.getLogger("operation");

    static void validateCollationAndWriteConcern(@Nullable Collation collation, WriteConcern writeConcern) {
        if (collation != null && !writeConcern.isAcknowledged()) {
            throw new MongoClientException("Specifying collation with an unacknowledged WriteConcern is not supported");
        }
    }

    private static void validateArrayFilters(WriteConcern writeConcern) {
        if (!writeConcern.isAcknowledged()) {
            throw new MongoClientException("Specifying array filters with an unacknowledged WriteConcern is not supported");
        }
    }

    private static void validateWriteRequestHint(ConnectionDescription connectionDescription, WriteConcern writeConcern, WriteRequest request) {
        if (!writeConcern.isAcknowledged() && request instanceof DeleteRequest && ServerVersionHelper.serverIsLessThanVersionFourDotFour(connectionDescription)) {
            throw new IllegalArgumentException(String.format("Hint not supported by wire version: %s", connectionDescription.getMaxWireVersion()));
        }
    }

    static void validateHintForFindAndModify(ConnectionDescription connectionDescription, WriteConcern writeConcern) {
        if (!writeConcern.isAcknowledged() && ServerVersionHelper.serverIsLessThanVersionFourDotFour(connectionDescription)) {
            throw new IllegalArgumentException(String.format("Hint not supported by wire version: %s", connectionDescription.getMaxWireVersion()));
        }
    }

    private static void validateWriteRequestCollations(List<? extends WriteRequest> requests, WriteConcern writeConcern) {
        Collation collation = null;
        for (WriteRequest writeRequest : requests) {
            if (writeRequest instanceof UpdateRequest) {
                collation = ((UpdateRequest)writeRequest).getCollation();
            } else if (writeRequest instanceof DeleteRequest) {
                collation = ((DeleteRequest)writeRequest).getCollation();
            }
            if (collation == null) continue;
            break;
        }
        OperationHelper.validateCollationAndWriteConcern(collation, writeConcern);
    }

    private static void validateUpdateRequestArrayFilters(List<? extends WriteRequest> requests, WriteConcern writeConcern) {
        for (WriteRequest writeRequest : requests) {
            List<BsonDocument> arrayFilters = null;
            if (writeRequest instanceof UpdateRequest) {
                arrayFilters = ((UpdateRequest)writeRequest).getArrayFilters();
            }
            if (arrayFilters == null) continue;
            OperationHelper.validateArrayFilters(writeConcern);
            break;
        }
    }

    private static void validateWriteRequestHints(ConnectionDescription connectionDescription, List<? extends WriteRequest> requests, WriteConcern writeConcern) {
        for (WriteRequest writeRequest : requests) {
            BsonDocument hint = null;
            String hintString = null;
            if (writeRequest instanceof UpdateRequest) {
                hint = ((UpdateRequest)writeRequest).getHint();
                hintString = ((UpdateRequest)writeRequest).getHintString();
            } else if (writeRequest instanceof DeleteRequest) {
                hint = ((DeleteRequest)writeRequest).getHint();
                hintString = ((DeleteRequest)writeRequest).getHintString();
            }
            if (hint == null && hintString == null) continue;
            OperationHelper.validateWriteRequestHint(connectionDescription, writeConcern, writeRequest);
            break;
        }
    }

    static void validateWriteRequests(ConnectionDescription connectionDescription, Boolean bypassDocumentValidation, List<? extends WriteRequest> requests, WriteConcern writeConcern) {
        OperationHelper.checkBypassDocumentValidationIsSupported(bypassDocumentValidation, writeConcern);
        OperationHelper.validateWriteRequestCollations(requests, writeConcern);
        OperationHelper.validateUpdateRequestArrayFilters(requests, writeConcern);
        OperationHelper.validateWriteRequestHints(connectionDescription, requests, writeConcern);
    }

    static <R> boolean validateWriteRequestsAndCompleteIfInvalid(ConnectionDescription connectionDescription, Boolean bypassDocumentValidation, List<? extends WriteRequest> requests, WriteConcern writeConcern, SingleResultCallback<R> callback) {
        try {
            OperationHelper.validateWriteRequests(connectionDescription, bypassDocumentValidation, requests, writeConcern);
            return false;
        }
        catch (Throwable validationT) {
            callback.onResult(null, validationT);
            return true;
        }
    }

    private static void checkBypassDocumentValidationIsSupported(@Nullable Boolean bypassDocumentValidation, WriteConcern writeConcern) {
        if (bypassDocumentValidation != null && !writeConcern.isAcknowledged()) {
            throw new MongoClientException("Specifying bypassDocumentValidation with an unacknowledged WriteConcern is not supported");
        }
    }

    static boolean isRetryableWrite(boolean retryWrites, WriteConcern writeConcern, ConnectionDescription connectionDescription, SessionContext sessionContext) {
        if (!retryWrites) {
            return false;
        }
        if (!writeConcern.isAcknowledged()) {
            LOGGER.debug("retryWrites set to true but the writeConcern is unacknowledged.");
            return false;
        }
        if (sessionContext.hasActiveTransaction()) {
            LOGGER.debug("retryWrites set to true but in an active transaction.");
            return false;
        }
        return OperationHelper.canRetryWrite(connectionDescription, sessionContext);
    }

    static boolean canRetryWrite(ConnectionDescription connectionDescription, SessionContext sessionContext) {
        if (connectionDescription.getLogicalSessionTimeoutMinutes() == null) {
            LOGGER.debug("retryWrites set to true but the server does not support sessions.");
            return false;
        }
        if (connectionDescription.getServerType().equals((Object)ServerType.STANDALONE)) {
            LOGGER.debug("retryWrites set to true but the server is a standalone server.");
            return false;
        }
        return true;
    }

    static boolean canRetryRead(ServerDescription serverDescription, OperationContext operationContext) {
        if (operationContext.getSessionContext().hasActiveTransaction()) {
            LOGGER.debug("retryReads set to true but in an active transaction.");
            return false;
        }
        return true;
    }

    static void setNonTailableCursorMaxTimeSupplier(TimeoutMode timeoutMode, OperationContext operationContext) {
        if (timeoutMode == TimeoutMode.ITERATION) {
            operationContext.getTimeoutContext().disableMaxTimeOverride();
        }
    }

    public static MongoException unwrap(MongoException exception) {
        MongoException result = exception;
        if (exception instanceof ClientBulkWriteException) {
            MongoException topLevelError = ((ClientBulkWriteException)exception).getCause();
            result = topLevelError == null ? exception : topLevelError;
        }
        return result;
    }

    private OperationHelper() {
    }

    public static final class ResourceSupplierInternalException
    extends RuntimeException {
        private static final long serialVersionUID = 0L;

        ResourceSupplierInternalException(Throwable cause) {
            super(Assertions.assertNotNull(cause));
        }

        @Override
        @NonNull
        public Throwable getCause() {
            return Assertions.assertNotNull(super.getCause());
        }
    }
}

