/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.trackers;

import java.util.ArrayList;
import java.util.Arrays;
import org.bukkit.Material;

public class BlockTracker {
    private static final byte[] bitCache = new byte[Material.values().length];
    private static final byte TOGGLEABLE_FLAG = 1;
    private static final byte PLACEABLE_FLAG = 2;
    private static final byte VINE_FLAG = 4;
    private static final byte SCULK_FLAG = 8;
    private static final byte CHORUS_FLAG = 16;
    private static final byte BAMBOO_FLAG = 32;
    private static final byte AMETHYST_FLAG = 64;
    private static boolean initialized = false;

    public static void initializeCache() {
        Material material2;
        if (initialized) {
            return;
        }
        Arrays.fill(bitCache, (byte)0);
        ArrayList<String> toggleableList = new ArrayList<String>();
        String[] doorMats = new String[]{"ACACIA", "BIRCH", "DARK_OAK", "JUNGLE", "OAK", "SPRUCE", "CHERRY", "BAMBOO", "MANGROVE", "CRIMSON", "WARPED", "IRON"};
        String[] fenceMats = new String[]{"ACACIA", "BIRCH", "DARK_OAK", "JUNGLE", "OAK", "SPRUCE", "CHERRY", "BAMBOO", "MANGROVE", "CRIMSON", "WARPED"};
        String[] buttonMats = new String[]{"ACACIA", "BIRCH", "DARK_OAK", "JUNGLE", "OAK", "SPRUCE", "CHERRY", "BAMBOO", "MANGROVE", "CRIMSON", "WARPED", "STONE", "POLISHED_BLACKSTONE"};
        String[] plateMats = new String[]{"ACACIA", "BIRCH", "DARK_OAK", "JUNGLE", "OAK", "SPRUCE", "CHERRY", "BAMBOO", "MANGROVE", "CRIMSON", "WARPED", "STONE", "POLISHED_BLACKSTONE", "LIGHT_WEIGHTED", "HEAVY_WEIGHTED"};
        for (String mat : doorMats) {
            toggleableList.add(mat + "_DOOR");
            toggleableList.add(mat + "_TRAPDOOR");
        }
        for (String mat : fenceMats) {
            toggleableList.add(mat + "_FENCE_GATE");
        }
        for (String mat : buttonMats) {
            toggleableList.add(mat + "_BUTTON");
        }
        for (String mat : plateMats) {
            toggleableList.add(mat + "_PRESSURE_PLATE");
        }
        toggleableList.add("LEVER");
        toggleableList.add("TRIPWIRE_HOOK");
        toggleableList.add("REDSTONE_TORCH");
        toggleableList.add("REDSTONE_WALL_TORCH");
        toggleableList.add("DAYLIGHT_DETECTOR");
        toggleableList.add("REPEATER");
        toggleableList.add("COMPARATOR");
        ArrayList<String> placeableList = new ArrayList<String>();
        placeableList.add("COMPOSTER");
        placeableList.add("CHISELED_BOOKSHELF");
        placeableList.add("CAMPFIRE");
        placeableList.add("SOUL_CAMPFIRE");
        placeableList.add("LECTERN");
        placeableList.add("JUKEBOX");
        placeableList.add("CAULDRON");
        placeableList.add("WATER_CAULDRON");
        placeableList.add("LAVA_CAULDRON");
        placeableList.add("POWDER_SNOW_CAULDRON");
        ArrayList<String> VINES = new ArrayList<String>();
        VINES.add("VINE");
        VINES.add("TWISTING_VINES");
        VINES.add("WEEPING_VINES");
        ArrayList<String> SCULK = new ArrayList<String>();
        SCULK.add("SCULK");
        SCULK.add("SCULK_VEIN");
        ArrayList<String> CHORUS = new ArrayList<String>();
        CHORUS.add("CHORUS_FLOWER");
        ArrayList<String> BAMBOO = new ArrayList<String>();
        BAMBOO.add("BAMBOO");
        ArrayList<String> AMETHYST = new ArrayList<String>();
        AMETHYST.add("SMALL_AMETHYST_BUD");
        for (String block : toggleableList) {
            try {
                material2 = Material.valueOf((String)block);
                int n = material2.ordinal();
                bitCache[n] = (byte)(bitCache[n] | 1);
            }
            catch (IllegalArgumentException material2) {}
        }
        for (String block : placeableList) {
            try {
                material2 = Material.valueOf((String)block);
                int n = material2.ordinal();
                bitCache[n] = (byte)(bitCache[n] | 2);
            }
            catch (IllegalArgumentException material3) {}
        }
        for (String block : VINES) {
            try {
                material2 = Material.valueOf((String)block);
                int n = material2.ordinal();
                bitCache[n] = (byte)(bitCache[n] | 4);
            }
            catch (IllegalArgumentException material4) {}
        }
        for (String block : SCULK) {
            try {
                material2 = Material.valueOf((String)block);
                int n = material2.ordinal();
                bitCache[n] = (byte)(bitCache[n] | 8);
            }
            catch (IllegalArgumentException material5) {}
        }
        for (String block : CHORUS) {
            try {
                material2 = Material.valueOf((String)block);
                int n = material2.ordinal();
                bitCache[n] = (byte)(bitCache[n] | 0x10);
            }
            catch (IllegalArgumentException material6) {}
        }
        for (String block : BAMBOO) {
            try {
                material2 = Material.valueOf((String)block);
                int n = material2.ordinal();
                bitCache[n] = (byte)(bitCache[n] | 0x20);
            }
            catch (IllegalArgumentException material7) {}
        }
        for (String block : AMETHYST) {
            try {
                material2 = Material.valueOf((String)block);
                int n = material2.ordinal();
                bitCache[n] = (byte)(bitCache[n] | 0x40);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        initialized = true;
    }

    public static boolean isToggleableState(Material material) {
        int ordinal = material.ordinal();
        return (bitCache[ordinal] & 1) != 0;
    }

    public static boolean isPlaceableState(Material material) {
        int ordinal = material.ordinal();
        return (bitCache[ordinal] & 2) != 0;
    }

    public static boolean isSculkState(Material material) {
        int ordinal = material.ordinal();
        return (bitCache[ordinal] & 8) != 0;
    }

    public static boolean isVineState(Material material) {
        int ordinal = material.ordinal();
        return (bitCache[ordinal] & 4) != 0;
    }

    public static boolean isChorusState(Material material) {
        int ordinal = material.ordinal();
        return (bitCache[ordinal] & 0x10) != 0;
    }

    public static boolean isAmethystState(Material material) {
        int ordinal = material.ordinal();
        return (bitCache[ordinal] & 0x40) != 0;
    }

    public static boolean isBambooState(Material material) {
        int ordinal = material.ordinal();
        return (bitCache[ordinal] & 0x20) != 0;
    }
}

