/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.database.entries.hooks;

import com.google.gson.JsonObject;
import io.github.insideranh.stellarprotect.StellarProtect;
import io.github.insideranh.stellarprotect.database.entries.LogEntry;
import io.github.insideranh.stellarprotect.enums.ActionType;
import io.github.insideranh.stellarprotect.items.ItemReference;
import io.github.insideranh.stellarprotect.items.ItemTemplate;
import io.github.insideranh.stellarprotect.libs.bson.Document;
import java.sql.ResultSet;
import lombok.Generated;
import org.bukkit.Location;

public class PlayerShopGUIEntry
extends LogEntry {
    private final long itemId;
    private final int amount;
    private final double price;
    private final byte shopAction;

    public PlayerShopGUIEntry(Document document, JsonObject jsonObject) {
        super(document);
        this.itemId = jsonObject.get("i").getAsLong();
        this.amount = jsonObject.get("a").getAsInt();
        this.price = jsonObject.get("p").getAsDouble();
        this.shopAction = jsonObject.get("s").getAsByte();
    }

    public PlayerShopGUIEntry(ResultSet resultSet, JsonObject jsonObject) {
        super(resultSet);
        this.itemId = jsonObject.get("i").getAsLong();
        this.amount = jsonObject.get("a").getAsInt();
        this.price = jsonObject.get("p").getAsDouble();
        this.shopAction = jsonObject.get("s").getAsByte();
    }

    public PlayerShopGUIEntry(long playerId, Location location, ItemReference itemReference, int amount, double price, byte shopAction) {
        super(playerId, ActionType.SHOP_GUI.getId(), location, System.currentTimeMillis());
        this.itemId = itemReference.getTemplateId();
        this.amount = amount;
        this.price = price;
        this.shopAction = shopAction;
    }

    @Override
    public String getDataString() {
        ItemTemplate itemTemplate = StellarProtect.getInstance().getItemsManager().getItemTemplate(this.itemId);
        return itemTemplate.getBukkitItem().getType().name();
    }

    @Override
    public String toSaveJson() {
        return "{\"i\":\"" + this.itemId + "\",\"a\":" + this.amount + "\",\"p\":" + this.price + ",\"s\":" + this.shopAction + "}";
    }

    @Generated
    public long getItemId() {
        return this.itemId;
    }

    @Generated
    public int getAmount() {
        return this.amount;
    }

    @Generated
    public double getPrice() {
        return this.price;
    }

    @Generated
    public byte getShopAction() {
        return this.shopAction;
    }
}

