/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.database.types;

import io.github.insideranh.stellarprotect.StellarProtect;
import io.github.insideranh.stellarprotect.database.repositories.BlocksRepository;
import io.github.insideranh.stellarprotect.database.repositories.DatabaseConnection;
import io.github.insideranh.stellarprotect.database.repositories.IdsRepository;
import io.github.insideranh.stellarprotect.database.repositories.ItemsRepository;
import io.github.insideranh.stellarprotect.database.repositories.LoggerRepository;
import io.github.insideranh.stellarprotect.database.repositories.PlayerRepository;
import io.github.insideranh.stellarprotect.database.repositories.RestoreRepository;
import io.github.insideranh.stellarprotect.database.types.mongo.BlocksRepositoryMongo;
import io.github.insideranh.stellarprotect.database.types.mongo.IdsRepositoryMongo;
import io.github.insideranh.stellarprotect.database.types.mongo.ItemsRepositoryMongo;
import io.github.insideranh.stellarprotect.database.types.mongo.LoggerRepositoryMongo;
import io.github.insideranh.stellarprotect.database.types.mongo.PlayerRepositoryMongo;
import io.github.insideranh.stellarprotect.database.types.mongo.RestoreRepositoryMongo;
import io.github.insideranh.stellarprotect.libs.bson.Document;
import io.github.insideranh.stellarprotect.libs.mongodb.ConnectionString;
import io.github.insideranh.stellarprotect.libs.mongodb.client.MongoClient;
import io.github.insideranh.stellarprotect.libs.mongodb.client.MongoClients;
import io.github.insideranh.stellarprotect.libs.mongodb.client.MongoCollection;
import io.github.insideranh.stellarprotect.libs.mongodb.client.MongoDatabase;
import io.github.insideranh.stellarprotect.libs.mongodb.client.model.IndexOptions;
import io.github.insideranh.stellarprotect.libs.mongodb.client.model.Indexes;
import lombok.Generated;

public class MongoConnection
implements DatabaseConnection {
    private final StellarProtect stellarProtect = StellarProtect.getInstance();
    private MongoClient mongoClient;
    private MongoCollection<Document> logEntries;
    private MongoCollection<Document> players;
    private MongoCollection<Document> itemTemplates;
    private PlayerRepository playerRepository;
    private LoggerRepository loggerRepository;
    private IdsRepository idsRepository;
    private ItemsRepository itemsRepository;
    private BlocksRepository blocksRepository;
    private RestoreRepository restoreRepository;

    @Override
    public void connect() {
        String connectionString = "mongodb://" + this.stellarProtect.getConfig().getString("databases.mongodb.user") + ":" + this.stellarProtect.getConfig().getString("databases.mongodb.password") + "@" + this.stellarProtect.getConfig().getString("databases.mongodb.host") + ":" + this.stellarProtect.getConfig().getInt("databases.mongodb.port");
        try {
            this.mongoClient = MongoClients.create(new ConnectionString(connectionString));
            MongoDatabase database = this.mongoClient.getDatabase(this.stellarProtect.getConfig().getString("databases.mongodb.database", "StellarProtect"));
            this.logEntries = database.getCollection(this.stellarProtect.getConfigManager().getTablesLogEntries());
            this.players = database.getCollection(this.stellarProtect.getConfigManager().getTablesPlayers());
            this.itemTemplates = database.getCollection(this.stellarProtect.getConfigManager().getTablesItemTemplates());
            this.playerRepository = new PlayerRepositoryMongo(database);
            this.loggerRepository = new LoggerRepositoryMongo(database);
            this.idsRepository = new IdsRepositoryMongo(database);
            this.itemsRepository = new ItemsRepositoryMongo(database);
            this.blocksRepository = new BlocksRepositoryMongo(database);
            this.restoreRepository = new RestoreRepositoryMongo(database);
            this.stellarProtect.getLogger().info("Connected to Mongo database correctly.");
        }
        catch (Exception exception) {
            this.stellarProtect.getLogger().warning("Error on connect to Mongo database.");
        }
    }

    @Override
    public void createIndexes() {
        try {
            this.logEntries.createIndex(Indexes.compoundIndex(Indexes.ascending("created_at"), Indexes.ascending("action_type"), Indexes.ascending("x"), Indexes.ascending("y"), Indexes.ascending("z")), new IndexOptions().background(true).name("idx_query_main"));
            this.logEntries.createIndex(Indexes.compoundIndex(Indexes.descending("created_at"), Indexes.ascending("action_type"), Indexes.ascending("x"), Indexes.ascending("y"), Indexes.ascending("z"), Indexes.ascending("player_id")), new IndexOptions().background(true).name("idx_log_entries_optimized"));
            this.logEntries.createIndex(Indexes.compoundIndex(Indexes.ascending("action_type"), Indexes.ascending("created_at"), Indexes.ascending("x"), Indexes.ascending("y"), Indexes.ascending("z")), new IndexOptions().background(true).name("idx_action_time_coords"));
            this.logEntries.createIndex(Indexes.compoundIndex(Indexes.ascending("created_at"), Indexes.ascending("x"), Indexes.ascending("y"), Indexes.ascending("z")), new IndexOptions().background(true).name("idx_log_entries_filtering"));
            this.logEntries.createIndex(Indexes.compoundIndex(Indexes.ascending("created_at"), Indexes.ascending("action_type")), new IndexOptions().background(true).name("idx_time_action"));
            this.logEntries.createIndex(Indexes.compoundIndex(Indexes.ascending("player_id"), Indexes.ascending("created_at")), new IndexOptions().background(true).name("idx_player_time"));
            this.logEntries.createIndex(Indexes.compoundIndex(Indexes.ascending("world_id"), Indexes.ascending("created_at")), new IndexOptions().background(true).name("idx_world_time"));
            this.logEntries.createIndex(Indexes.compoundIndex(Indexes.ascending("x"), Indexes.ascending("y"), Indexes.ascending("z"), Indexes.descending("created_at"), Indexes.ascending("action_type"), Indexes.ascending("player_id")), new IndexOptions().background(true).name("idx_query_optimized"));
            this.logEntries.createIndex(Indexes.compoundIndex(Indexes.ascending("x"), Indexes.ascending("y"), Indexes.ascending("z"), Indexes.ascending("created_at"), Indexes.ascending("action_type"), Indexes.ascending("player_id"), Indexes.ascending("id")), new IndexOptions().background(true).name("idx_covering_query"));
            this.logEntries.createIndex(Indexes.compoundIndex(Indexes.ascending("x"), Indexes.ascending("y"), Indexes.ascending("z"), Indexes.descending("created_at")), new IndexOptions().background(true).name("idx_coords_time"));
            this.players.createIndex(Indexes.ascending("id"), new IndexOptions().background(true).name("idx_players_id"));
            this.itemTemplates.createIndex(Indexes.ascending("base64"), new IndexOptions().background(true).name("idx_item_hash"));
            this.itemTemplates.createIndex(Indexes.descending("access_count"), new IndexOptions().background(true).name("idx_item_access_count"));
            this.itemTemplates.createIndex(Indexes.descending("last_accessed"), new IndexOptions().background(true).name("idx_item_last_accessed"));
            this.itemTemplates.createIndex(Indexes.descending("total_quantity_used"), new IndexOptions().background(true).name("idx_item_total_used"));
            this.logEntries.createIndex(Indexes.text("extra_json"), new IndexOptions().background(true).name("text_search"));
            this.logEntries.createIndex(Indexes.compoundIndex(Indexes.text("extra_json"), Indexes.descending("created_at")), new IndexOptions().background(true).name("text_search_date"));
            this.stellarProtect.getLogger().info("All MongoDB indexes created successfully");
        }
        catch (Exception e) {
            this.stellarProtect.getLogger().info("Failed to create MongoDB indexes: " + e.getMessage());
            e.printStackTrace();
        }
    }

    @Override
    public void close() {
        if (this.mongoClient != null) {
            this.mongoClient.close();
        }
    }

    @Generated
    public StellarProtect getStellarProtect() {
        return this.stellarProtect;
    }

    @Generated
    public MongoClient getMongoClient() {
        return this.mongoClient;
    }

    @Generated
    public MongoCollection<Document> getLogEntries() {
        return this.logEntries;
    }

    @Generated
    public MongoCollection<Document> getPlayers() {
        return this.players;
    }

    @Generated
    public MongoCollection<Document> getItemTemplates() {
        return this.itemTemplates;
    }

    @Override
    @Generated
    public PlayerRepository getPlayerRepository() {
        return this.playerRepository;
    }

    @Override
    @Generated
    public LoggerRepository getLoggerRepository() {
        return this.loggerRepository;
    }

    @Override
    @Generated
    public IdsRepository getIdsRepository() {
        return this.idsRepository;
    }

    @Override
    @Generated
    public ItemsRepository getItemsRepository() {
        return this.itemsRepository;
    }

    @Override
    @Generated
    public BlocksRepository getBlocksRepository() {
        return this.blocksRepository;
    }

    @Override
    @Generated
    public RestoreRepository getRestoreRepository() {
        return this.restoreRepository;
    }
}

