/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.mongodb;

import io.github.insideranh.stellarprotect.libs.bson.codecs.BsonTypeClassMap;
import io.github.insideranh.stellarprotect.libs.bson.codecs.Codec;
import io.github.insideranh.stellarprotect.libs.bson.codecs.DateCodec;
import io.github.insideranh.stellarprotect.libs.bson.codecs.configuration.CodecProvider;
import io.github.insideranh.stellarprotect.libs.bson.codecs.configuration.CodecRegistry;
import io.github.insideranh.stellarprotect.libs.bson.types.BSONTimestamp;
import io.github.insideranh.stellarprotect.libs.mongodb.BSONTimestampCodec;
import io.github.insideranh.stellarprotect.libs.mongodb.DBObject;
import io.github.insideranh.stellarprotect.libs.mongodb.DBObjectCodec;
import io.github.insideranh.stellarprotect.libs.mongodb.assertions.Assertions;
import java.util.Date;
import java.util.List;

public class DBObjectCodecProvider
implements CodecProvider {
    private final BsonTypeClassMap bsonTypeClassMap;

    public DBObjectCodecProvider() {
        this(DBObjectCodec.getDefaultBsonTypeClassMap());
    }

    public DBObjectCodecProvider(BsonTypeClassMap bsonTypeClassMap) {
        this.bsonTypeClassMap = Assertions.notNull("bsonTypeClassMap", bsonTypeClassMap);
    }

    @Override
    public <T> Codec<T> get(Class<T> clazz, CodecRegistry registry) {
        if (clazz == BSONTimestamp.class) {
            return new BSONTimestampCodec();
        }
        if (DBObject.class.isAssignableFrom(clazz) && !List.class.isAssignableFrom(clazz)) {
            return new DBObjectCodec(registry, this.bsonTypeClassMap);
        }
        if (Date.class.isAssignableFrom(clazz)) {
            return new DateCodec();
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o != null && this.getClass() == o.getClass();
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public String toString() {
        return "DBObjectCodecProvider{}";
    }
}

