/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.mongodb.client;

import io.github.insideranh.stellarprotect.libs.bson.Document;
import io.github.insideranh.stellarprotect.libs.bson.codecs.configuration.CodecRegistry;
import io.github.insideranh.stellarprotect.libs.bson.conversions.Bson;
import io.github.insideranh.stellarprotect.libs.mongodb.ClientBulkWriteException;
import io.github.insideranh.stellarprotect.libs.mongodb.ClientSessionOptions;
import io.github.insideranh.stellarprotect.libs.mongodb.ReadConcern;
import io.github.insideranh.stellarprotect.libs.mongodb.ReadPreference;
import io.github.insideranh.stellarprotect.libs.mongodb.WriteConcern;
import io.github.insideranh.stellarprotect.libs.mongodb.annotations.Alpha;
import io.github.insideranh.stellarprotect.libs.mongodb.annotations.Immutable;
import io.github.insideranh.stellarprotect.libs.mongodb.annotations.Reason;
import io.github.insideranh.stellarprotect.libs.mongodb.client.ChangeStreamIterable;
import io.github.insideranh.stellarprotect.libs.mongodb.client.ClientSession;
import io.github.insideranh.stellarprotect.libs.mongodb.client.ListDatabasesIterable;
import io.github.insideranh.stellarprotect.libs.mongodb.client.MongoDatabase;
import io.github.insideranh.stellarprotect.libs.mongodb.client.MongoIterable;
import io.github.insideranh.stellarprotect.libs.mongodb.client.model.bulk.ClientBulkWriteOptions;
import io.github.insideranh.stellarprotect.libs.mongodb.client.model.bulk.ClientBulkWriteResult;
import io.github.insideranh.stellarprotect.libs.mongodb.client.model.bulk.ClientNamespacedWriteModel;
import io.github.insideranh.stellarprotect.libs.mongodb.lang.Nullable;
import java.util.List;
import java.util.concurrent.TimeUnit;

@Immutable
public interface MongoCluster {
    public CodecRegistry getCodecRegistry();

    public ReadPreference getReadPreference();

    public WriteConcern getWriteConcern();

    public ReadConcern getReadConcern();

    @Nullable
    @Alpha(value={Reason.CLIENT})
    public Long getTimeout(TimeUnit var1);

    public MongoCluster withCodecRegistry(CodecRegistry var1);

    public MongoCluster withReadPreference(ReadPreference var1);

    public MongoCluster withWriteConcern(WriteConcern var1);

    public MongoCluster withReadConcern(ReadConcern var1);

    @Alpha(value={Reason.CLIENT})
    public MongoCluster withTimeout(long var1, TimeUnit var3);

    public MongoDatabase getDatabase(String var1);

    public ClientSession startSession();

    public ClientSession startSession(ClientSessionOptions var1);

    public MongoIterable<String> listDatabaseNames();

    public MongoIterable<String> listDatabaseNames(ClientSession var1);

    public ListDatabasesIterable<Document> listDatabases();

    public ListDatabasesIterable<Document> listDatabases(ClientSession var1);

    public <TResult> ListDatabasesIterable<TResult> listDatabases(Class<TResult> var1);

    public <TResult> ListDatabasesIterable<TResult> listDatabases(ClientSession var1, Class<TResult> var2);

    public ChangeStreamIterable<Document> watch();

    public <TResult> ChangeStreamIterable<TResult> watch(Class<TResult> var1);

    public ChangeStreamIterable<Document> watch(List<? extends Bson> var1);

    public <TResult> ChangeStreamIterable<TResult> watch(List<? extends Bson> var1, Class<TResult> var2);

    public ChangeStreamIterable<Document> watch(ClientSession var1);

    public <TResult> ChangeStreamIterable<TResult> watch(ClientSession var1, Class<TResult> var2);

    public ChangeStreamIterable<Document> watch(ClientSession var1, List<? extends Bson> var2);

    public <TResult> ChangeStreamIterable<TResult> watch(ClientSession var1, List<? extends Bson> var2, Class<TResult> var3);

    public ClientBulkWriteResult bulkWrite(List<? extends ClientNamespacedWriteModel> var1) throws ClientBulkWriteException;

    public ClientBulkWriteResult bulkWrite(List<? extends ClientNamespacedWriteModel> var1, ClientBulkWriteOptions var2) throws ClientBulkWriteException;

    public ClientBulkWriteResult bulkWrite(ClientSession var1, List<? extends ClientNamespacedWriteModel> var2) throws ClientBulkWriteException;

    public ClientBulkWriteResult bulkWrite(ClientSession var1, List<? extends ClientNamespacedWriteModel> var2, ClientBulkWriteOptions var3) throws ClientBulkWriteException;
}

