/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.mongodb.internal;

import io.github.insideranh.stellarprotect.libs.mongodb.MongoClientSettings;
import io.github.insideranh.stellarprotect.libs.mongodb.assertions.Assertions;
import io.github.insideranh.stellarprotect.libs.mongodb.lang.Nullable;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class TimeoutSettings {
    private static final AtomicLong NEXT_ID = new AtomicLong(0L);
    private final long generationId;
    private final long serverSelectionTimeoutMS;
    private final long connectTimeoutMS;
    @Nullable
    private final Long timeoutMS;
    private final long readTimeoutMS;
    private final long maxWaitTimeMS;
    @Nullable
    private final Long wTimeoutMS;
    private final long maxTimeMS;
    private final long maxAwaitTimeMS;
    @Nullable
    private final Long maxCommitTimeMS;
    public static final TimeoutSettings DEFAULT = TimeoutSettings.create(MongoClientSettings.builder().build());

    @Nullable
    public static Long convertAndValidateTimeoutNullable(@Nullable Long timeout, TimeUnit timeUnit) {
        return timeout == null ? null : Long.valueOf(TimeoutSettings.convertAndValidateTimeout(timeout, timeUnit, "timeout"));
    }

    public static long convertAndValidateTimeout(long timeout, TimeUnit timeUnit) {
        return TimeoutSettings.convertAndValidateTimeout(timeout, timeUnit, "timeout");
    }

    public static long convertAndValidateTimeout(long timeout, TimeUnit timeUnit, String fieldName) {
        return Assertions.isTrueArgument(fieldName + " was too small. After conversion it was rounded to 0 milliseconds,  which would result in an unintended infinite timeout.", () -> TimeUnit.MILLISECONDS.convert(timeout, timeUnit), timeoutMS -> timeout == 0L && timeoutMS == 0L || timeoutMS > 0L);
    }

    public static TimeoutSettings create(MongoClientSettings settings) {
        return new TimeoutSettings(settings.getClusterSettings().getServerSelectionTimeout(TimeUnit.MILLISECONDS), settings.getSocketSettings().getConnectTimeout(TimeUnit.MILLISECONDS), settings.getSocketSettings().getReadTimeout(TimeUnit.MILLISECONDS), settings.getTimeout(TimeUnit.MILLISECONDS), settings.getConnectionPoolSettings().getMaxWaitTime(TimeUnit.MILLISECONDS));
    }

    public static TimeoutSettings createHeartbeatSettings(MongoClientSettings settings) {
        return new TimeoutSettings(settings.getClusterSettings().getServerSelectionTimeout(TimeUnit.MILLISECONDS), settings.getHeartbeatSocketSettings().getConnectTimeout(TimeUnit.MILLISECONDS), settings.getHeartbeatSocketSettings().getReadTimeout(TimeUnit.MILLISECONDS), settings.getTimeout(TimeUnit.MILLISECONDS), settings.getConnectionPoolSettings().getMaxWaitTime(TimeUnit.MILLISECONDS));
    }

    public TimeoutSettings(long serverSelectionTimeoutMS, long connectTimeoutMS, long readTimeoutMS, @Nullable Long timeoutMS, long maxWaitTimeMS) {
        this(-1L, timeoutMS, serverSelectionTimeoutMS, connectTimeoutMS, readTimeoutMS, 0L, 0L, null, null, maxWaitTimeMS);
    }

    TimeoutSettings(@Nullable Long timeoutMS, long serverSelectionTimeoutMS, long connectTimeoutMS, long readTimeoutMS, long maxAwaitTimeMS, long maxTimeMS, @Nullable Long maxCommitTimeMS, @Nullable Long wTimeoutMS, long maxWaitTimeMS) {
        this(timeoutMS != null ? NEXT_ID.incrementAndGet() : -1L, timeoutMS, serverSelectionTimeoutMS, connectTimeoutMS, readTimeoutMS, maxAwaitTimeMS, maxTimeMS, maxCommitTimeMS, wTimeoutMS, maxWaitTimeMS);
    }

    private TimeoutSettings(long generationId, @Nullable Long timeoutMS, long serverSelectionTimeoutMS, long connectTimeoutMS, long readTimeoutMS, long maxAwaitTimeMS, long maxTimeMS, @Nullable Long maxCommitTimeMS, @Nullable Long wTimeoutMS, long maxWaitTimeMS) {
        Assertions.isTrueArgument("timeoutMS must be >= 0", timeoutMS == null || timeoutMS >= 0L);
        Assertions.isTrueArgument("maxAwaitTimeMS must be >= 0", maxAwaitTimeMS >= 0L);
        Assertions.isTrueArgument("maxTimeMS must be >= 0", maxTimeMS >= 0L);
        Assertions.isTrueArgument("timeoutMS must be greater than maxAwaitTimeMS", timeoutMS == null || timeoutMS == 0L || timeoutMS > maxAwaitTimeMS);
        Assertions.isTrueArgument("maxCommitTimeMS must be >= 0", maxCommitTimeMS == null || maxCommitTimeMS >= 0L);
        this.generationId = generationId;
        this.serverSelectionTimeoutMS = serverSelectionTimeoutMS;
        this.connectTimeoutMS = connectTimeoutMS;
        this.timeoutMS = timeoutMS;
        this.maxAwaitTimeMS = maxAwaitTimeMS;
        this.readTimeoutMS = readTimeoutMS;
        this.maxTimeMS = maxTimeMS;
        this.maxCommitTimeMS = maxCommitTimeMS;
        this.wTimeoutMS = wTimeoutMS;
        this.maxWaitTimeMS = maxWaitTimeMS;
    }

    public TimeoutSettings connectionOnly() {
        return new TimeoutSettings(this.serverSelectionTimeoutMS, this.connectTimeoutMS, this.readTimeoutMS, null, this.maxWaitTimeMS);
    }

    public TimeoutSettings withTimeout(@Nullable Long timeout, TimeUnit timeUnit) {
        return this.withTimeoutMS(TimeoutSettings.convertAndValidateTimeoutNullable(timeout, timeUnit));
    }

    TimeoutSettings withTimeoutMS(@Nullable Long timeoutMS) {
        return new TimeoutSettings(timeoutMS, this.serverSelectionTimeoutMS, this.connectTimeoutMS, this.readTimeoutMS, this.maxAwaitTimeMS, this.maxTimeMS, this.maxCommitTimeMS, this.wTimeoutMS, this.maxWaitTimeMS);
    }

    public TimeoutSettings withMaxTimeMS(long maxTimeMS) {
        return new TimeoutSettings(this.generationId, this.timeoutMS, this.serverSelectionTimeoutMS, this.connectTimeoutMS, this.readTimeoutMS, this.maxAwaitTimeMS, maxTimeMS, this.maxCommitTimeMS, this.wTimeoutMS, this.maxWaitTimeMS);
    }

    public TimeoutSettings withMaxAwaitTimeMS(long maxAwaitTimeMS) {
        return new TimeoutSettings(this.generationId, this.timeoutMS, this.serverSelectionTimeoutMS, this.connectTimeoutMS, this.readTimeoutMS, maxAwaitTimeMS, this.maxTimeMS, this.maxCommitTimeMS, this.wTimeoutMS, this.maxWaitTimeMS);
    }

    public TimeoutSettings withMaxTimeAndMaxAwaitTimeMS(long maxTimeMS, long maxAwaitTimeMS) {
        return new TimeoutSettings(this.generationId, this.timeoutMS, this.serverSelectionTimeoutMS, this.connectTimeoutMS, this.readTimeoutMS, maxAwaitTimeMS, maxTimeMS, this.maxCommitTimeMS, this.wTimeoutMS, this.maxWaitTimeMS);
    }

    public TimeoutSettings withMaxCommitMS(@Nullable Long maxCommitTimeMS) {
        return new TimeoutSettings(this.generationId, this.timeoutMS, this.serverSelectionTimeoutMS, this.connectTimeoutMS, this.readTimeoutMS, this.maxAwaitTimeMS, this.maxTimeMS, maxCommitTimeMS, this.wTimeoutMS, this.maxWaitTimeMS);
    }

    public TimeoutSettings withWTimeoutMS(@Nullable Long wTimeoutMS) {
        return new TimeoutSettings(this.timeoutMS, this.serverSelectionTimeoutMS, this.connectTimeoutMS, this.readTimeoutMS, this.maxAwaitTimeMS, this.maxTimeMS, this.maxCommitTimeMS, wTimeoutMS, this.maxWaitTimeMS);
    }

    public TimeoutSettings withReadTimeoutMS(long readTimeoutMS) {
        return new TimeoutSettings(this.generationId, this.timeoutMS, this.serverSelectionTimeoutMS, this.connectTimeoutMS, readTimeoutMS, this.maxAwaitTimeMS, this.maxTimeMS, this.maxCommitTimeMS, this.wTimeoutMS, this.maxWaitTimeMS);
    }

    public TimeoutSettings withConnectTimeoutMS(long connectTimeoutMS) {
        return new TimeoutSettings(this.generationId, this.timeoutMS, this.serverSelectionTimeoutMS, connectTimeoutMS, this.readTimeoutMS, this.maxAwaitTimeMS, this.maxTimeMS, this.maxCommitTimeMS, this.wTimeoutMS, this.maxWaitTimeMS);
    }

    public TimeoutSettings withServerSelectionTimeoutMS(long serverSelectionTimeoutMS) {
        return new TimeoutSettings(this.timeoutMS, serverSelectionTimeoutMS, this.connectTimeoutMS, this.readTimeoutMS, this.maxAwaitTimeMS, this.maxTimeMS, this.maxCommitTimeMS, this.wTimeoutMS, this.maxWaitTimeMS);
    }

    public TimeoutSettings withMaxWaitTimeMS(long maxWaitTimeMS) {
        return new TimeoutSettings(this.timeoutMS, this.serverSelectionTimeoutMS, this.connectTimeoutMS, this.readTimeoutMS, this.maxAwaitTimeMS, this.maxTimeMS, this.maxCommitTimeMS, this.wTimeoutMS, maxWaitTimeMS);
    }

    public long getServerSelectionTimeoutMS() {
        return this.serverSelectionTimeoutMS;
    }

    public long getConnectTimeoutMS() {
        return this.connectTimeoutMS;
    }

    @Nullable
    public Long getTimeoutMS() {
        return this.timeoutMS;
    }

    public long getMaxAwaitTimeMS() {
        return this.maxAwaitTimeMS;
    }

    public long getReadTimeoutMS() {
        return this.readTimeoutMS;
    }

    public long getMaxTimeMS() {
        return this.maxTimeMS;
    }

    @Nullable
    public Long getWTimeoutMS() {
        return this.wTimeoutMS;
    }

    public long getMaxWaitTimeMS() {
        return this.maxWaitTimeMS;
    }

    @Nullable
    public Long getMaxCommitTimeMS() {
        return this.maxCommitTimeMS;
    }

    public long getGenerationId() {
        return this.generationId;
    }

    public String toString() {
        return "TimeoutSettings{generationId=" + this.generationId + ", timeoutMS=" + this.timeoutMS + ", serverSelectionTimeoutMS=" + this.serverSelectionTimeoutMS + ", connectTimeoutMS=" + this.connectTimeoutMS + ", readTimeoutMS=" + this.readTimeoutMS + ", maxWaitTimeMS=" + this.maxWaitTimeMS + ", wTimeoutMS=" + this.wTimeoutMS + ", maxTimeMS=" + this.maxTimeMS + ", maxAwaitTimeMS=" + this.maxAwaitTimeMS + ", maxCommitTimeMS=" + this.maxCommitTimeMS + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeoutSettings that = (TimeoutSettings)o;
        return this.serverSelectionTimeoutMS == that.serverSelectionTimeoutMS && this.connectTimeoutMS == that.connectTimeoutMS && this.readTimeoutMS == that.readTimeoutMS && this.maxWaitTimeMS == that.maxWaitTimeMS && this.maxTimeMS == that.maxTimeMS && this.maxAwaitTimeMS == that.maxAwaitTimeMS && Objects.equals(this.timeoutMS, that.timeoutMS) && Objects.equals(this.wTimeoutMS, that.wTimeoutMS) && Objects.equals(this.maxCommitTimeMS, that.maxCommitTimeMS);
    }

    public int hashCode() {
        return Objects.hash(this.generationId, this.serverSelectionTimeoutMS, this.connectTimeoutMS, this.timeoutMS, this.readTimeoutMS, this.maxWaitTimeMS, this.wTimeoutMS, this.maxTimeMS, this.maxAwaitTimeMS, this.maxCommitTimeMS);
    }
}

