/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.mongodb.internal.client.model;

import io.github.insideranh.stellarprotect.libs.bson.BsonDocument;
import io.github.insideranh.stellarprotect.libs.bson.Document;
import io.github.insideranh.stellarprotect.libs.bson.codecs.configuration.CodecRegistry;
import io.github.insideranh.stellarprotect.libs.bson.conversions.Bson;
import io.github.insideranh.stellarprotect.libs.bson.internal.BsonUtil;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.client.model.ToMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public abstract class AbstractConstructibleBson<S extends AbstractConstructibleBson<S>>
implements Bson,
ToMap {
    private static final Document EMPTY_DOC = new Document();
    public static final AbstractConstructibleBson<?> EMPTY_IMMUTABLE = AbstractConstructibleBson.of(EMPTY_DOC);
    private final Bson base;
    private final Document appended;

    protected AbstractConstructibleBson(Bson base) {
        this(base, EMPTY_DOC);
    }

    protected AbstractConstructibleBson(Bson base, Document appended) {
        this.base = base;
        this.appended = appended;
    }

    protected abstract S newSelf(Bson var1, Document var2);

    @Override
    public final <TDocument> BsonDocument toBsonDocument(Class<TDocument> documentClass, CodecRegistry codecRegistry) {
        BsonDocument baseDoc = this.base.toBsonDocument(documentClass, codecRegistry);
        return baseDoc.isEmpty() && this.appended.isEmpty() ? new BsonDocument() : (this.appended.isEmpty() ? baseDoc : AbstractConstructibleBson.newMerged(baseDoc, this.appended.toBsonDocument(documentClass, codecRegistry)));
    }

    protected final S newAppended(String name, Object value) {
        return this.newMutated(doc -> doc.append(name, value));
    }

    protected final S newMutated(Consumer<Document> mutator) {
        Document newAppended = new Document(this.appended);
        mutator.accept(newAppended);
        return this.newSelf(this.base, newAppended);
    }

    @Override
    public Optional<Map<String, ?>> tryToMap() {
        return ToMap.tryToMap(this.base).map(baseMap -> {
            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>((Map<String, Object>)baseMap);
            result.putAll(this.appended);
            return result;
        });
    }

    public static AbstractConstructibleBson<?> of(Bson doc) {
        return doc instanceof AbstractConstructibleBson ? (AbstractConstructibleBson)doc : new ConstructibleBson(doc);
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractConstructibleBson that = (AbstractConstructibleBson)o;
        return Objects.equals(this.base, that.base) && Objects.equals(this.appended, that.appended);
    }

    public final int hashCode() {
        return Objects.hash(this.base, this.appended);
    }

    public String toString() {
        return this.tryToMap().map(Document::new).map(Document::toString).orElseGet(() -> "ConstructibleBson{base=" + this.base + ", appended=" + this.appended + '}');
    }

    static BsonDocument newMerged(BsonDocument base, BsonDocument appended) {
        BsonDocument result = BsonUtil.mutableDeepCopy(base);
        result.putAll(appended);
        return result;
    }

    private static final class ConstructibleBson
    extends AbstractConstructibleBson<ConstructibleBson> {
        private ConstructibleBson(Bson base) {
            super(base);
        }

        private ConstructibleBson(Bson base, Document appended) {
            super(base, appended);
        }

        @Override
        protected ConstructibleBson newSelf(Bson base, Document appended) {
            return new ConstructibleBson(base, appended);
        }
    }
}

