/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.mongodb.internal.connection;

import io.github.insideranh.stellarprotect.libs.bson.BsonDocument;
import io.github.insideranh.stellarprotect.libs.bson.FieldNameValidator;
import io.github.insideranh.stellarprotect.libs.bson.codecs.Decoder;
import io.github.insideranh.stellarprotect.libs.mongodb.MongoException;
import io.github.insideranh.stellarprotect.libs.mongodb.MongoServerUnavailableException;
import io.github.insideranh.stellarprotect.libs.mongodb.ReadPreference;
import io.github.insideranh.stellarprotect.libs.mongodb.assertions.Assertions;
import io.github.insideranh.stellarprotect.libs.mongodb.connection.ClusterConnectionMode;
import io.github.insideranh.stellarprotect.libs.mongodb.connection.ConnectionDescription;
import io.github.insideranh.stellarprotect.libs.mongodb.connection.ServerId;
import io.github.insideranh.stellarprotect.libs.mongodb.event.CommandListener;
import io.github.insideranh.stellarprotect.libs.mongodb.event.ServerClosedEvent;
import io.github.insideranh.stellarprotect.libs.mongodb.event.ServerListener;
import io.github.insideranh.stellarprotect.libs.mongodb.event.ServerOpeningEvent;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.async.ErrorHandlingResultCallback;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.async.SingleResultCallback;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.AbstractProtocolExecutor;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.AsyncConnection;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.ClusterClock;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.ClusterClockAdvancingSessionContext;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.ClusterableServer;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.CommandProtocol;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.Connection;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.ConnectionFactory;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.ConnectionPool;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.InternalConnection;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.MessageSequences;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.MongoWriteConcernWithResponseException;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.OperationContext;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.SdamServerDescriptionManager;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.ServerDescriptionHelper;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.ServerMonitor;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.diagnostics.logging.Logger;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.diagnostics.logging.Loggers;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.session.SessionContext;
import io.github.insideranh.stellarprotect.libs.mongodb.lang.Nullable;
import java.util.concurrent.atomic.AtomicInteger;

class DefaultServer
implements ClusterableServer {
    private static final Logger LOGGER = Loggers.getLogger("connection");
    private final ServerId serverId;
    private final ConnectionPool connectionPool;
    private final ClusterConnectionMode clusterConnectionMode;
    private final ConnectionFactory connectionFactory;
    private final ServerMonitor serverMonitor;
    private final SdamServerDescriptionManager sdam;
    private final ServerListener serverListener;
    private final CommandListener commandListener;
    private final ClusterClock clusterClock;
    @Nullable
    private final AtomicInteger operationCount;
    private volatile boolean isClosed;

    DefaultServer(ServerId serverId, ClusterConnectionMode clusterConnectionMode, ConnectionPool connectionPool, ConnectionFactory connectionFactory, ServerMonitor serverMonitor, SdamServerDescriptionManager sdam, ServerListener serverListener, CommandListener commandListener, ClusterClock clusterClock, boolean trackOperationCount) {
        this.sdam = Assertions.assertNotNull(sdam);
        this.serverListener = Assertions.notNull("serverListener", serverListener);
        this.commandListener = commandListener;
        this.clusterClock = Assertions.notNull("clusterClock", clusterClock);
        Assertions.notNull("serverAddress", serverId);
        this.clusterConnectionMode = Assertions.notNull("clusterConnectionMode", clusterConnectionMode);
        this.connectionFactory = Assertions.notNull("connectionFactory", connectionFactory);
        this.connectionPool = Assertions.notNull("connectionPool", connectionPool);
        this.serverId = serverId;
        serverListener.serverOpening(new ServerOpeningEvent(this.serverId));
        this.serverMonitor = serverMonitor;
        this.operationCount = trackOperationCount ? new AtomicInteger() : null;
    }

    @Override
    public Connection getConnection(OperationContext operationContext) {
        if (this.isClosed) {
            throw new MongoServerUnavailableException(String.format("The server at %s is no longer available", this.serverId.getAddress()));
        }
        SdamServerDescriptionManager.SdamIssue.Context exceptionContext = this.sdam.context();
        this.operationBegin();
        try {
            return OperationCountTrackingConnection.decorate(this, this.connectionFactory.create(this.connectionPool.get(operationContext), new DefaultServerProtocolExecutor(), this.clusterConnectionMode));
        }
        catch (Throwable e) {
            try {
                this.operationEnd();
                if (e instanceof MongoException) {
                    this.sdam.handleExceptionBeforeHandshake(SdamServerDescriptionManager.SdamIssue.specific(e, exceptionContext));
                }
            }
            catch (Exception suppressed) {
                e.addSuppressed(suppressed);
            }
            throw e;
        }
    }

    @Override
    public void getConnectionAsync(OperationContext operationContext, SingleResultCallback<AsyncConnection> callback) {
        if (this.isClosed) {
            callback.onResult(null, new MongoServerUnavailableException(String.format("The server at %s is no longer available", this.serverId.getAddress())));
            return;
        }
        SdamServerDescriptionManager.SdamIssue.Context exceptionContext = this.sdam.context();
        this.operationBegin();
        this.connectionPool.getAsync(operationContext, (result, t) -> {
            if (t != null) {
                try {
                    this.operationEnd();
                    this.sdam.handleExceptionBeforeHandshake(SdamServerDescriptionManager.SdamIssue.specific(t, exceptionContext));
                }
                catch (Exception suppressed) {
                    t.addSuppressed(suppressed);
                }
                finally {
                    callback.onResult(null, t);
                }
            } else {
                callback.onResult(AsyncOperationCountTrackingConnection.decorate(this, this.connectionFactory.createAsync(Assertions.assertNotNull(result), new DefaultServerProtocolExecutor(), this.clusterConnectionMode)), null);
            }
        });
    }

    @Override
    public int operationCount() {
        return this.operationCount == null ? -1 : this.operationCount.get();
    }

    private void operationBegin() {
        if (this.operationCount != null) {
            this.operationCount.incrementAndGet();
        }
    }

    private void operationEnd() {
        if (this.operationCount != null) {
            Assertions.assertTrue(this.operationCount.decrementAndGet() >= 0);
        }
    }

    @Override
    public void resetToConnecting() {
        this.sdam.update(ServerDescriptionHelper.unknownConnectingServerDescription(this.serverId, null));
    }

    @Override
    public void invalidate() {
        if (!this.isClosed()) {
            this.sdam.handleExceptionAfterHandshake(SdamServerDescriptionManager.SdamIssue.unspecified(this.sdam.context()));
        }
    }

    @Override
    public void close() {
        if (!this.isClosed()) {
            this.connectionPool.close();
            this.serverMonitor.close();
            this.isClosed = true;
            this.serverListener.serverClosed(new ServerClosedEvent(this.serverId));
        }
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public void connect() {
        this.serverMonitor.connect();
    }

    ConnectionPool getConnectionPool() {
        return this.connectionPool;
    }

    SdamServerDescriptionManager sdamServerDescriptionManager() {
        return this.sdam;
    }

    ServerId serverId() {
        return this.serverId;
    }

    private class DefaultServerProtocolExecutor
    extends AbstractProtocolExecutor {
        private DefaultServerProtocolExecutor() {
        }

        @Override
        public <T> T execute(CommandProtocol<T> protocol, InternalConnection connection, SessionContext sessionContext) {
            try {
                return protocol.withSessionContext(new ClusterClockAdvancingSessionContext(sessionContext, DefaultServer.this.clusterClock)).execute(connection);
            }
            catch (MongoException e) {
                try {
                    DefaultServer.this.sdam.handleExceptionAfterHandshake(SdamServerDescriptionManager.SdamIssue.specific(e, DefaultServer.this.sdam.context(connection)));
                }
                catch (Exception suppressed) {
                    e.addSuppressed(suppressed);
                }
                if (e instanceof MongoWriteConcernWithResponseException) {
                    return (T)((MongoWriteConcernWithResponseException)e).getResponse();
                }
                if (this.shouldMarkSessionDirty(e, sessionContext)) {
                    sessionContext.markSessionDirty();
                }
                throw e;
            }
        }

        @Override
        public <T> void executeAsync(CommandProtocol<T> protocol, InternalConnection connection, SessionContext sessionContext, SingleResultCallback<T> callback) {
            protocol.withSessionContext(new ClusterClockAdvancingSessionContext(sessionContext, DefaultServer.this.clusterClock)).executeAsync(connection, ErrorHandlingResultCallback.errorHandlingCallback((result, t) -> {
                if (t != null) {
                    try {
                        DefaultServer.this.sdam.handleExceptionAfterHandshake(SdamServerDescriptionManager.SdamIssue.specific(t, DefaultServer.this.sdam.context(connection)));
                    }
                    catch (Exception suppressed) {
                        t.addSuppressed(suppressed);
                    }
                    finally {
                        if (t instanceof MongoWriteConcernWithResponseException) {
                            callback.onResult(((MongoWriteConcernWithResponseException)t).getResponse(), null);
                        } else {
                            if (this.shouldMarkSessionDirty(t, sessionContext)) {
                                sessionContext.markSessionDirty();
                            }
                            callback.onResult(null, t);
                        }
                    }
                } else {
                    callback.onResult(result, null);
                }
            }, LOGGER));
        }
    }

    private static final class OperationCountTrackingConnection
    implements Connection {
        private final DefaultServer server;
        private final Connection wrapped;

        static Connection decorate(DefaultServer server, Connection connection) {
            return server.operationCount() < 0 ? connection : new OperationCountTrackingConnection(server, connection);
        }

        private OperationCountTrackingConnection(DefaultServer server, Connection connection) {
            this.server = server;
            this.wrapped = connection;
        }

        @Override
        public int getCount() {
            return this.wrapped.getCount();
        }

        @Override
        public int release() {
            int count = this.wrapped.release();
            if (count == 0) {
                this.server.operationEnd();
            }
            return count;
        }

        @Override
        public Connection retain() {
            this.wrapped.retain();
            return this;
        }

        @Override
        public ConnectionDescription getDescription() {
            return this.wrapped.getDescription();
        }

        @Override
        public <T> T command(String database, BsonDocument command, FieldNameValidator fieldNameValidator, @Nullable ReadPreference readPreference, Decoder<T> commandResultDecoder, OperationContext operationContext) {
            return this.wrapped.command(database, command, fieldNameValidator, readPreference, commandResultDecoder, operationContext);
        }

        @Override
        public <T> T command(String database, BsonDocument command, FieldNameValidator commandFieldNameValidator, @Nullable ReadPreference readPreference, Decoder<T> commandResultDecoder, OperationContext operationContext, boolean responseExpected, MessageSequences sequences) {
            return this.wrapped.command(database, command, commandFieldNameValidator, readPreference, commandResultDecoder, operationContext, responseExpected, sequences);
        }

        @Override
        public void markAsPinned(Connection.PinningMode pinningMode) {
            this.wrapped.markAsPinned(pinningMode);
        }
    }

    private static final class AsyncOperationCountTrackingConnection
    implements AsyncConnection {
        private final DefaultServer server;
        private final AsyncConnection wrapped;

        static AsyncConnection decorate(DefaultServer server, AsyncConnection connection) {
            return server.operationCount() < 0 ? connection : new AsyncOperationCountTrackingConnection(server, connection);
        }

        AsyncOperationCountTrackingConnection(DefaultServer server, AsyncConnection connection) {
            this.server = server;
            this.wrapped = connection;
        }

        @Override
        public int getCount() {
            return this.wrapped.getCount();
        }

        @Override
        public int release() {
            int count = this.wrapped.release();
            if (count == 0) {
                this.server.operationEnd();
            }
            return count;
        }

        @Override
        public AsyncConnection retain() {
            this.wrapped.retain();
            return this;
        }

        @Override
        public ConnectionDescription getDescription() {
            return this.wrapped.getDescription();
        }

        @Override
        public <T> void commandAsync(String database, BsonDocument command, FieldNameValidator fieldNameValidator, @Nullable ReadPreference readPreference, Decoder<T> commandResultDecoder, OperationContext operationContext, SingleResultCallback<T> callback) {
            this.wrapped.commandAsync(database, command, fieldNameValidator, readPreference, commandResultDecoder, operationContext, callback);
        }

        @Override
        public <T> void commandAsync(String database, BsonDocument command, FieldNameValidator commandFieldNameValidator, @Nullable ReadPreference readPreference, Decoder<T> commandResultDecoder, OperationContext operationContext, boolean responseExpected, MessageSequences sequences, SingleResultCallback<T> callback) {
            this.wrapped.commandAsync(database, command, commandFieldNameValidator, readPreference, commandResultDecoder, operationContext, responseExpected, sequences, callback);
        }

        @Override
        public void markAsPinned(Connection.PinningMode pinningMode) {
            this.wrapped.markAsPinned(pinningMode);
        }
    }
}

