/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.mongodb.internal.operation;

import io.github.insideranh.stellarprotect.libs.bson.BsonDocument;
import io.github.insideranh.stellarprotect.libs.bson.BsonValue;
import io.github.insideranh.stellarprotect.libs.bson.codecs.Decoder;
import io.github.insideranh.stellarprotect.libs.mongodb.ExplainVerbosity;
import io.github.insideranh.stellarprotect.libs.mongodb.MongoNamespace;
import io.github.insideranh.stellarprotect.libs.mongodb.client.cursor.TimeoutMode;
import io.github.insideranh.stellarprotect.libs.mongodb.client.model.Collation;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.async.AsyncBatchCursor;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.async.SingleResultCallback;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.binding.AsyncReadBinding;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.binding.ReadBinding;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.client.model.AggregationLevel;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.CommandHelper;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.AggregateOperationImpl;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.AsyncExplainableReadOperation;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.AsyncReadOperation;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.BatchCursor;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.CommandReadOperation;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.ExplainHelper;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.ExplainableReadOperation;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.ReadOperation;
import io.github.insideranh.stellarprotect.libs.mongodb.lang.Nullable;
import java.util.List;

public class AggregateOperation<T>
implements AsyncExplainableReadOperation<AsyncBatchCursor<T>>,
ExplainableReadOperation<BatchCursor<T>> {
    private final AggregateOperationImpl<T> wrapped;

    public AggregateOperation(MongoNamespace namespace, List<BsonDocument> pipeline, Decoder<T> decoder) {
        this(namespace, pipeline, decoder, AggregationLevel.COLLECTION);
    }

    public AggregateOperation(MongoNamespace namespace, List<BsonDocument> pipeline, Decoder<T> decoder, AggregationLevel aggregationLevel) {
        this.wrapped = new AggregateOperationImpl<T>(namespace, pipeline, decoder, aggregationLevel);
    }

    public List<BsonDocument> getPipeline() {
        return this.wrapped.getPipeline();
    }

    public Boolean getAllowDiskUse() {
        return this.wrapped.getAllowDiskUse();
    }

    public AggregateOperation<T> allowDiskUse(@Nullable Boolean allowDiskUse) {
        this.wrapped.allowDiskUse(allowDiskUse);
        return this;
    }

    public Integer getBatchSize() {
        return this.wrapped.getBatchSize();
    }

    public AggregateOperation<T> batchSize(@Nullable Integer batchSize) {
        this.wrapped.batchSize(batchSize);
        return this;
    }

    public Collation getCollation() {
        return this.wrapped.getCollation();
    }

    public AggregateOperation<T> collation(@Nullable Collation collation) {
        this.wrapped.collation(collation);
        return this;
    }

    @Nullable
    public BsonValue getComment() {
        return this.wrapped.getComment();
    }

    public AggregateOperation<T> comment(@Nullable BsonValue comment) {
        this.wrapped.comment(comment);
        return this;
    }

    public AggregateOperation<T> let(@Nullable BsonDocument variables) {
        this.wrapped.let(variables);
        return this;
    }

    public AggregateOperation<T> retryReads(boolean retryReads) {
        this.wrapped.retryReads(retryReads);
        return this;
    }

    public boolean getRetryReads() {
        return this.wrapped.getRetryReads();
    }

    @Nullable
    public BsonDocument getHint() {
        BsonValue hint = this.wrapped.getHint();
        if (hint == null) {
            return null;
        }
        if (!hint.isDocument()) {
            throw new IllegalArgumentException("Hint is not a BsonDocument please use the #getHintBsonValue() method. ");
        }
        return hint.asDocument();
    }

    @Nullable
    public BsonValue getHintBsonValue() {
        return this.wrapped.getHint();
    }

    public AggregateOperation<T> hint(@Nullable BsonValue hint) {
        this.wrapped.hint(hint);
        return this;
    }

    public AggregateOperation<T> timeoutMode(@Nullable TimeoutMode timeoutMode) {
        this.wrapped.timeoutMode(timeoutMode);
        return this;
    }

    @Override
    public BatchCursor<T> execute(ReadBinding binding) {
        return this.wrapped.execute(binding);
    }

    @Override
    public void executeAsync(AsyncReadBinding binding, SingleResultCallback<AsyncBatchCursor<T>> callback) {
        this.wrapped.executeAsync(binding, callback);
    }

    @Override
    public <R> ReadOperation<R> asExplainableOperation(@Nullable ExplainVerbosity verbosity, Decoder<R> resultDecoder) {
        return this.createExplainableOperation(verbosity, resultDecoder);
    }

    @Override
    public <R> AsyncReadOperation<R> asAsyncExplainableOperation(@Nullable ExplainVerbosity verbosity, Decoder<R> resultDecoder) {
        return this.createExplainableOperation(verbosity, resultDecoder);
    }

    <R> CommandReadOperation<R> createExplainableOperation(@Nullable ExplainVerbosity verbosity, Decoder<R> resultDecoder) {
        return new CommandReadOperation<R>(this.getNamespace().getDatabaseName(), (operationContext, serverDescription, connectionDescription) -> {
            BsonDocument command = this.wrapped.getCommand(operationContext, 0);
            CommandHelper.applyMaxTimeMS(operationContext.getTimeoutContext(), command);
            return ExplainHelper.asExplainCommand(command, verbosity);
        }, resultDecoder);
    }

    MongoNamespace getNamespace() {
        return this.wrapped.getNamespace();
    }
}

