/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.mongodb.internal.operation;

import io.github.insideranh.stellarprotect.libs.bson.BsonArray;
import io.github.insideranh.stellarprotect.libs.bson.BsonBoolean;
import io.github.insideranh.stellarprotect.libs.bson.BsonDocument;
import io.github.insideranh.stellarprotect.libs.bson.BsonInt32;
import io.github.insideranh.stellarprotect.libs.bson.BsonString;
import io.github.insideranh.stellarprotect.libs.bson.BsonTimestamp;
import io.github.insideranh.stellarprotect.libs.bson.BsonValue;
import io.github.insideranh.stellarprotect.libs.bson.RawBsonDocument;
import io.github.insideranh.stellarprotect.libs.bson.codecs.Decoder;
import io.github.insideranh.stellarprotect.libs.bson.codecs.RawBsonDocumentCodec;
import io.github.insideranh.stellarprotect.libs.mongodb.CursorType;
import io.github.insideranh.stellarprotect.libs.mongodb.MongoNamespace;
import io.github.insideranh.stellarprotect.libs.mongodb.assertions.Assertions;
import io.github.insideranh.stellarprotect.libs.mongodb.client.cursor.TimeoutMode;
import io.github.insideranh.stellarprotect.libs.mongodb.client.model.Collation;
import io.github.insideranh.stellarprotect.libs.mongodb.client.model.changestream.FullDocument;
import io.github.insideranh.stellarprotect.libs.mongodb.client.model.changestream.FullDocumentBeforeChange;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.TimeoutContext;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.async.AsyncBatchCursor;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.async.SingleResultCallback;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.binding.AsyncReadBinding;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.binding.ReadBinding;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.client.model.changestream.ChangeStreamLevel;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.AggregateOperationImpl;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.AsyncChangeStreamBatchCursor;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.AsyncCommandBatchCursor;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.AsyncReadOperation;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.BatchCursor;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.ChangeStreamBatchCursor;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.CommandBatchCursor;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.ReadOperation;
import io.github.insideranh.stellarprotect.libs.mongodb.lang.Nullable;
import java.util.ArrayList;
import java.util.List;

public class ChangeStreamOperation<T>
implements AsyncReadOperation<AsyncBatchCursor<T>>,
ReadOperation<BatchCursor<T>> {
    private static final RawBsonDocumentCodec RAW_BSON_DOCUMENT_CODEC = new RawBsonDocumentCodec();
    private final AggregateOperationImpl<RawBsonDocument> wrapped;
    private final FullDocument fullDocument;
    private final FullDocumentBeforeChange fullDocumentBeforeChange;
    private final Decoder<T> decoder;
    private final ChangeStreamLevel changeStreamLevel;
    private BsonDocument resumeAfter;
    private BsonDocument startAfter;
    private BsonTimestamp startAtOperationTime;
    private boolean showExpandedEvents;

    public ChangeStreamOperation(MongoNamespace namespace, FullDocument fullDocument, FullDocumentBeforeChange fullDocumentBeforeChange, List<BsonDocument> pipeline, Decoder<T> decoder) {
        this(namespace, fullDocument, fullDocumentBeforeChange, pipeline, decoder, ChangeStreamLevel.COLLECTION);
    }

    public ChangeStreamOperation(MongoNamespace namespace, FullDocument fullDocument, FullDocumentBeforeChange fullDocumentBeforeChange, List<BsonDocument> pipeline, Decoder<T> decoder, ChangeStreamLevel changeStreamLevel) {
        this.wrapped = new AggregateOperationImpl<RawBsonDocument>(namespace, pipeline, RAW_BSON_DOCUMENT_CODEC, this.getAggregateTarget(), this.getPipelineCreator()).cursorType(CursorType.TailableAwait);
        this.fullDocument = Assertions.notNull("fullDocument", fullDocument);
        this.fullDocumentBeforeChange = Assertions.notNull("fullDocumentBeforeChange", fullDocumentBeforeChange);
        this.decoder = Assertions.notNull("decoder", decoder);
        this.changeStreamLevel = Assertions.notNull("changeStreamLevel", changeStreamLevel);
    }

    public MongoNamespace getNamespace() {
        return this.wrapped.getNamespace();
    }

    public Decoder<T> getDecoder() {
        return this.decoder;
    }

    public FullDocument getFullDocument() {
        return this.fullDocument;
    }

    public BsonDocument getResumeAfter() {
        return this.resumeAfter;
    }

    public ChangeStreamOperation<T> resumeAfter(BsonDocument resumeAfter) {
        this.resumeAfter = resumeAfter;
        return this;
    }

    public BsonDocument getStartAfter() {
        return this.startAfter;
    }

    public ChangeStreamOperation<T> startAfter(BsonDocument startAfter) {
        this.startAfter = startAfter;
        return this;
    }

    public List<BsonDocument> getPipeline() {
        return this.wrapped.getPipeline();
    }

    public Integer getBatchSize() {
        return this.wrapped.getBatchSize();
    }

    public ChangeStreamOperation<T> batchSize(@Nullable Integer batchSize) {
        this.wrapped.batchSize(batchSize);
        return this;
    }

    public Collation getCollation() {
        return this.wrapped.getCollation();
    }

    public ChangeStreamOperation<T> collation(Collation collation) {
        this.wrapped.collation(collation);
        return this;
    }

    public ChangeStreamOperation<T> startAtOperationTime(BsonTimestamp startAtOperationTime) {
        this.startAtOperationTime = startAtOperationTime;
        return this;
    }

    public BsonTimestamp getStartAtOperationTime() {
        return this.startAtOperationTime;
    }

    public ChangeStreamOperation<T> retryReads(boolean retryReads) {
        this.wrapped.retryReads(retryReads);
        return this;
    }

    public boolean getRetryReads() {
        return this.wrapped.getRetryReads();
    }

    @Nullable
    public BsonValue getComment() {
        return this.wrapped.getComment();
    }

    public ChangeStreamOperation<T> comment(BsonValue comment) {
        this.wrapped.comment(comment);
        return this;
    }

    public boolean getShowExpandedEvents() {
        return this.showExpandedEvents;
    }

    public ChangeStreamOperation<T> showExpandedEvents(boolean showExpandedEvents) {
        this.showExpandedEvents = showExpandedEvents;
        return this;
    }

    private AggregateOperationImpl<RawBsonDocument> getAggregateOperation(TimeoutContext timeoutContext) {
        if (timeoutContext.hasTimeoutMS()) {
            return this.wrapped.timeoutMode(TimeoutMode.CURSOR_LIFETIME);
        }
        return this.wrapped;
    }

    @Override
    public BatchCursor<T> execute(ReadBinding binding) {
        TimeoutContext timeoutContext = binding.getOperationContext().getTimeoutContext();
        CommandBatchCursor<RawBsonDocument> cursor = ((CommandBatchCursor)this.getAggregateOperation(timeoutContext).execute(binding)).disableTimeoutResetWhenClosing();
        return new ChangeStreamBatchCursor(this, cursor, binding, this.setChangeStreamOptions(cursor.getPostBatchResumeToken(), cursor.getOperationTime(), cursor.getMaxWireVersion(), cursor.isFirstBatchEmpty()), cursor.getMaxWireVersion());
    }

    @Override
    public void executeAsync(AsyncReadBinding binding, SingleResultCallback<AsyncBatchCursor<T>> callback) {
        TimeoutContext timeoutContext = binding.getOperationContext().getTimeoutContext();
        this.getAggregateOperation(timeoutContext).executeAsync(binding, (result, t) -> {
            if (t != null) {
                callback.onResult(null, t);
            } else {
                AsyncCommandBatchCursor<RawBsonDocument> cursor = ((AsyncCommandBatchCursor)Assertions.assertNotNull(result)).disableTimeoutResetWhenClosing();
                callback.onResult(new AsyncChangeStreamBatchCursor(this, cursor, binding, this.setChangeStreamOptions(cursor.getPostBatchResumeToken(), cursor.getOperationTime(), cursor.getMaxWireVersion(), cursor.isFirstBatchEmpty()), cursor.getMaxWireVersion()), null);
            }
        });
    }

    @Nullable
    private BsonDocument setChangeStreamOptions(@Nullable BsonDocument postBatchResumeToken, @Nullable BsonTimestamp operationTime, int maxWireVersion, boolean firstBatchEmpty) {
        BsonDocument resumeToken = null;
        if (this.startAfter != null) {
            resumeToken = this.startAfter;
        } else if (this.resumeAfter != null) {
            resumeToken = this.resumeAfter;
        } else if (this.startAtOperationTime == null && postBatchResumeToken == null && firstBatchEmpty && maxWireVersion >= 7) {
            this.startAtOperationTime = operationTime;
        }
        return resumeToken;
    }

    public void setChangeStreamOptionsForResume(@Nullable BsonDocument resumeToken, int maxWireVersion) {
        this.startAfter = null;
        if (resumeToken != null) {
            this.startAtOperationTime = null;
            this.resumeAfter = resumeToken;
        } else if (this.startAtOperationTime != null && maxWireVersion >= 7) {
            this.resumeAfter = null;
        } else {
            this.resumeAfter = null;
            this.startAtOperationTime = null;
        }
    }

    private AggregateOperationImpl.AggregateTarget getAggregateTarget() {
        return () -> this.changeStreamLevel == ChangeStreamLevel.COLLECTION ? new BsonString(this.getNamespace().getCollectionName()) : new BsonInt32(1);
    }

    private AggregateOperationImpl.PipelineCreator getPipelineCreator() {
        return () -> {
            ArrayList<BsonDocument> changeStreamPipeline = new ArrayList<BsonDocument>();
            BsonDocument changeStream = new BsonDocument();
            if (this.fullDocument != FullDocument.DEFAULT) {
                changeStream.append("fullDocument", new BsonString(this.fullDocument.getValue()));
            }
            if (this.fullDocumentBeforeChange != FullDocumentBeforeChange.DEFAULT) {
                changeStream.append("fullDocumentBeforeChange", new BsonString(this.fullDocumentBeforeChange.getValue()));
            }
            if (this.changeStreamLevel == ChangeStreamLevel.CLIENT) {
                changeStream.append("allChangesForCluster", BsonBoolean.TRUE);
            }
            if (this.showExpandedEvents) {
                changeStream.append("showExpandedEvents", BsonBoolean.TRUE);
            }
            if (this.resumeAfter != null) {
                changeStream.append("resumeAfter", this.resumeAfter);
            }
            if (this.startAfter != null) {
                changeStream.append("startAfter", this.startAfter);
            }
            if (this.startAtOperationTime != null) {
                changeStream.append("startAtOperationTime", this.startAtOperationTime);
            }
            changeStreamPipeline.add(new BsonDocument("$changeStream", changeStream));
            changeStreamPipeline.addAll(this.getPipeline());
            return new BsonArray(changeStreamPipeline);
        };
    }
}

