/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.mongodb.internal.operation;

import io.github.insideranh.stellarprotect.libs.bson.BsonDocument;
import io.github.insideranh.stellarprotect.libs.bson.BsonString;
import io.github.insideranh.stellarprotect.libs.mongodb.ExplainVerbosity;
import io.github.insideranh.stellarprotect.libs.mongodb.MongoInternalException;
import io.github.insideranh.stellarprotect.libs.mongodb.lang.Nullable;

final class ExplainHelper {
    static BsonDocument asExplainCommand(BsonDocument command, @Nullable ExplainVerbosity explainVerbosity) {
        BsonDocument explainCommand = new BsonDocument("explain", command);
        if (explainVerbosity != null) {
            explainCommand.append("verbosity", ExplainHelper.getVerbosityAsString(explainVerbosity));
        }
        return explainCommand;
    }

    private static BsonString getVerbosityAsString(ExplainVerbosity explainVerbosity) {
        switch (explainVerbosity) {
            case QUERY_PLANNER: {
                return new BsonString("queryPlanner");
            }
            case EXECUTION_STATS: {
                return new BsonString("executionStats");
            }
            case ALL_PLANS_EXECUTIONS: {
                return new BsonString("allPlansExecution");
            }
        }
        throw new MongoInternalException(String.format("Unsupported explain verbosity %s", new Object[]{explainVerbosity}));
    }

    private ExplainHelper() {
    }
}

