/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.mongodb.internal.operation;

import io.github.insideranh.stellarprotect.libs.bson.BsonDocument;
import io.github.insideranh.stellarprotect.libs.bson.BsonInt32;
import io.github.insideranh.stellarprotect.libs.bson.codecs.BsonDocumentCodec;
import io.github.insideranh.stellarprotect.libs.mongodb.Function;
import io.github.insideranh.stellarprotect.libs.mongodb.WriteConcern;
import io.github.insideranh.stellarprotect.libs.mongodb.assertions.Assertions;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.TimeoutContext;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.async.ErrorHandlingResultCallback;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.async.SingleResultCallback;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.binding.AsyncWriteBinding;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.binding.WriteBinding;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.AsyncOperationHelper;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.AsyncWriteOperation;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.CommandOperationHelper;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.OperationHelper;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.SyncOperationHelper;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.WriteOperation;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.validator.NoOpFieldNameValidator;

public abstract class TransactionOperation
implements WriteOperation<Void>,
AsyncWriteOperation<Void> {
    private final WriteConcern writeConcern;

    TransactionOperation(WriteConcern writeConcern) {
        this.writeConcern = Assertions.notNull("writeConcern", writeConcern);
    }

    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    @Override
    public Void execute(WriteBinding binding) {
        Assertions.isTrue("in transaction", binding.getOperationContext().getSessionContext().hasActiveTransaction());
        TimeoutContext timeoutContext = binding.getOperationContext().getTimeoutContext();
        return SyncOperationHelper.executeRetryableWrite(binding, "admin", null, NoOpFieldNameValidator.INSTANCE, new BsonDocumentCodec(), this.getCommandCreator(), SyncOperationHelper.writeConcernErrorTransformer(timeoutContext), this.getRetryCommandModifier(timeoutContext));
    }

    @Override
    public void executeAsync(AsyncWriteBinding binding, SingleResultCallback<Void> callback) {
        Assertions.isTrue("in transaction", binding.getOperationContext().getSessionContext().hasActiveTransaction());
        TimeoutContext timeoutContext = binding.getOperationContext().getTimeoutContext();
        AsyncOperationHelper.executeRetryableWriteAsync(binding, "admin", null, NoOpFieldNameValidator.INSTANCE, new BsonDocumentCodec(), this.getCommandCreator(), AsyncOperationHelper.writeConcernErrorTransformerAsync(timeoutContext), this.getRetryCommandModifier(timeoutContext), ErrorHandlingResultCallback.errorHandlingCallback(callback, OperationHelper.LOGGER));
    }

    CommandOperationHelper.CommandCreator getCommandCreator() {
        return (operationContext, serverDescription, connectionDescription) -> {
            BsonDocument command = new BsonDocument(this.getCommandName(), new BsonInt32(1));
            if (!this.writeConcern.isServerDefault()) {
                command.put("writeConcern", this.writeConcern.asDocument());
            }
            return command;
        };
    }

    protected abstract String getCommandName();

    protected abstract Function<BsonDocument, BsonDocument> getRetryCommandModifier(TimeoutContext var1);
}

