/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.utils;

import java.util.ArrayList;
import java.util.Arrays;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.block.banner.Pattern;
import org.bukkit.block.banner.PatternType;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class ItemUtils {
    private final ItemMeta itemMeta;
    private ItemStack item;

    public ItemUtils(Material material) {
        this(material, 1, 0);
    }

    public ItemUtils(Material material, int amount) {
        this(material, amount, 0);
    }

    public ItemUtils(Material material, int amount, short data) {
        this.item = new ItemStack(material, amount, data);
        this.itemMeta = this.item.getItemMeta();
    }

    public ItemUtils(ItemStack item) {
        this.item = item.clone();
        if (item.getType().name().equals("AIR")) {
            item.setType(Material.STONE);
        }
        this.itemMeta = item.getItemMeta();
    }

    public ItemUtils type(Material material) {
        this.item.setType(material);
        return this;
    }

    public ItemUtils data(short data) {
        this.item = new ItemStack(this.item.getType(), this.item.getAmount(), data);
        return this;
    }

    public ItemUtils displayName(String displayName) {
        this.itemMeta.setDisplayName(displayName);
        return this;
    }

    public int enchantLevel(Enchantment enchantment) {
        return this.item.getEnchantments().getOrDefault(enchantment, 0);
    }

    public ItemUtils unEnchant(Enchantment enchantment) {
        this.itemMeta.removeEnchant(enchantment);
        return this;
    }

    public ItemUtils durability(int damage) {
        this.item.setDurability((short)Math.max(this.item.getType().getMaxDurability() - Math.max(damage, 1), 0));
        return this;
    }

    public int durability() {
        return this.item.getType().getMaxDurability() - this.item.getDurability();
    }

    public int maxDurability() {
        return this.item.getType().getMaxDurability();
    }

    public ItemUtils amount(int amount) {
        this.item.setAmount(amount);
        return this;
    }

    public int amount() {
        return this.item.getAmount();
    }

    public ItemUtils lore(String lore) {
        this.itemMeta.setLore(lore.isEmpty() ? new ArrayList() : Arrays.asList(lore.split("\\n")));
        return this;
    }

    public ItemUtils owner(String owner) {
        if (!this.item.getType().name().contains("SKULL_ITEM") && !this.item.getType().name().contains("PLAYER_HEAD")) {
            return this;
        }
        if (owner.isEmpty()) {
            return this;
        }
        SkullMeta headMeta = (SkullMeta)this.itemMeta;
        headMeta.setOwner(owner);
        this.item.setItemMeta((ItemMeta)headMeta);
        return this;
    }

    public ItemUtils item(ItemStack item) {
        this.item = item;
        return this;
    }

    public ItemUtils enchant(Enchantment enchantment, int level) {
        this.itemMeta.addEnchant(enchantment, level, true);
        return this;
    }

    public ItemUtils addPattern(DyeColor dyeColor, PatternType patternType) {
        BannerMeta bannerMeta = (BannerMeta)this.itemMeta;
        if (bannerMeta != null) {
            bannerMeta.addPattern(new Pattern(dyeColor, patternType));
        }
        return this;
    }

    public ItemUtils addPattern(Pattern pattern) {
        BannerMeta bannerMeta = (BannerMeta)this.itemMeta;
        if (bannerMeta != null) {
            bannerMeta.addPattern(pattern);
        }
        return this;
    }

    public ItemStack build() {
        this.item.setItemMeta(this.itemMeta);
        return this.item;
    }
}

