/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.utils;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import io.github.insideranh.stellarprotect.StellarProtect;
import io.github.insideranh.stellarprotect.cache.PlayerCache;
import io.github.insideranh.stellarprotect.data.PlayerProtect;
import java.util.concurrent.atomic.AtomicLong;
import lombok.NonNull;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;

public class PlayerUtils {
    private static final BiMap<String, Long> specialIds = HashBiMap.create();
    private static long lastLogId = 0L;

    public static long getNextLogId() {
        return ++lastLogId;
    }

    public static void setNextLogId(long id) {
        lastLogId = id;
    }

    public static void loadEntityIds() {
        AtomicLong entityId = new AtomicLong(-200L);
        for (EntityType entityType : EntityType.values()) {
            long id;
            String keyId = "=" + entityType.name().toLowerCase();
            if (specialIds.containsKey((Object)keyId) || specialIds.containsValue((Object)(id = entityId.getAndDecrement()))) continue;
            specialIds.put((Object)keyId, (Object)id);
            StellarProtect.getInstance().getProtectDatabase().saveEntityId(keyId, id);
        }
    }

    public static void cacheEntityId(String entityType, long entityId) {
        specialIds.put((Object)entityType, (Object)entityId);
    }

    public static long getPlayerOrConsoleId(CommandSender sender) {
        if (sender instanceof ConsoleCommandSender) {
            return -1L;
        }
        Player player = (Player)sender;
        PlayerProtect playerProtect = PlayerProtect.getPlayer(player);
        if (playerProtect == null) {
            return -2L;
        }
        return playerProtect.getPlayerId();
    }

    public static long getPlayerOrEntityId(String name) {
        long id = PlayerProtect.getPlayerId(name);
        if (id != -2L) {
            return id;
        }
        long directId = PlayerUtils.getEntityByDirectId(name);
        if (directId != -2L) {
            return directId;
        }
        return PlayerUtils.getSearchByDirectId(name);
    }

    public static long getEntityByDirectId(String entityType) {
        if (specialIds.containsKey((Object)entityType)) {
            return (Long)specialIds.get((Object)entityType);
        }
        return -2L;
    }

    public static long getSearchByDirectId(String entityType) {
        String keyId = "=" + entityType.toLowerCase();
        if (specialIds.containsKey((Object)keyId)) {
            return (Long)specialIds.get((Object)keyId);
        }
        return -2L;
    }

    public static String getNameOfEntity(long entityId) {
        if (entityId < 0L) {
            return PlayerUtils.getEntityType(entityId);
        }
        return PlayerCache.getName(entityId);
    }

    @NonNull
    public static String getEntityType(long entityId) {
        if (specialIds.inverse().containsKey((Object)entityId)) {
            return (String)specialIds.inverse().get((Object)entityId);
        }
        return "=none";
    }

    static {
        specialIds.put((Object)"=natural", (Object)-2L);
        specialIds.put((Object)"=fire", (Object)-3L);
        specialIds.put((Object)"=water", (Object)-4L);
        specialIds.put((Object)"=lava", (Object)-5L);
        specialIds.put((Object)"=ice_melt", (Object)-6L);
        specialIds.put((Object)"=snow_fall", (Object)-7L);
        specialIds.put((Object)"=lightning", (Object)-8L);
        specialIds.put((Object)"=dripstone", (Object)-9L);
        specialIds.put((Object)"=piston", (Object)-10L);
        specialIds.put((Object)"=explosion", (Object)-11L);
        specialIds.put((Object)"=redstone", (Object)-12L);
        specialIds.put((Object)"=gravity", (Object)-13L);
        specialIds.put((Object)"=dispenser", (Object)-14L);
        specialIds.put((Object)"=observer", (Object)-15L);
        specialIds.put((Object)"=decay", (Object)-16L);
        specialIds.put((Object)"=portal", (Object)-17L);
        specialIds.put((Object)"=tree", (Object)-18L);
        specialIds.put((Object)"=vine", (Object)-19L);
        specialIds.put((Object)"=sculk", (Object)-20L);
        specialIds.put((Object)"=chorus", (Object)-21L);
        specialIds.put((Object)"=bamboo", (Object)-22L);
        specialIds.put((Object)"=amethyst", (Object)-23L);
        specialIds.put((Object)"=frost_walker", (Object)-24L);
        specialIds.put((Object)"=dragon", (Object)-25L);
        specialIds.put((Object)"=warden", (Object)-26L);
        specialIds.put((Object)"=evoker", (Object)-27L);
        specialIds.put((Object)"=ravager", (Object)-28L);
    }
}

