/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect;

import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import io.github.insideranh.stellarprotect.api.ColorUtils;
import io.github.insideranh.stellarprotect.api.ItemsProviderRegistry;
import io.github.insideranh.stellarprotect.api.ProtectNMS;
import io.github.insideranh.stellarprotect.api.events.DecorativeLogicHandler;
import io.github.insideranh.stellarprotect.api.events.EventLogicHandler;
import io.github.insideranh.stellarprotect.blocks.DataBlock;
import io.github.insideranh.stellarprotect.blocks.adjacents.AdjacentType;
import io.github.insideranh.stellarprotect.bstats.MetricsLite;
import io.github.insideranh.stellarprotect.commands.StellarProtectCMD;
import io.github.insideranh.stellarprotect.database.ProtectDatabase;
import io.github.insideranh.stellarprotect.entities.DataEntity;
import io.github.insideranh.stellarprotect.enums.MinecraftVersion;
import io.github.insideranh.stellarprotect.hooks.ShopGUIHookListener;
import io.github.insideranh.stellarprotect.hooks.StellarTaskHook;
import io.github.insideranh.stellarprotect.hooks.WorldEditHook;
import io.github.insideranh.stellarprotect.hooks.XPlayerKitsListener;
import io.github.insideranh.stellarprotect.hooks.itemsadder.ItemsAdderHook;
import io.github.insideranh.stellarprotect.hooks.itemsadder.ItemsAdderHookListener;
import io.github.insideranh.stellarprotect.hooks.nexo.NexoDefaultHook;
import io.github.insideranh.stellarprotect.hooks.nexo.NexoHook;
import io.github.insideranh.stellarprotect.hooks.nexo.NexoHookListener;
import io.github.insideranh.stellarprotect.hooks.tasks.BukkitTaskHook;
import io.github.insideranh.stellarprotect.hooks.tasks.FoliaTaskHook;
import io.github.insideranh.stellarprotect.hooks.vault.DefaultVaultHook;
import io.github.insideranh.stellarprotect.hooks.vault.VaultHook;
import io.github.insideranh.stellarprotect.inspect.InspectHandler;
import io.github.insideranh.stellarprotect.libs.foliascheduler.util.MinecraftVersions;
import io.github.insideranh.stellarprotect.libs.foliascheduler.util.ServerVersions;
import io.github.insideranh.stellarprotect.listeners.BlockFormListener;
import io.github.insideranh.stellarprotect.listeners.BlockListener;
import io.github.insideranh.stellarprotect.listeners.BucketListener;
import io.github.insideranh.stellarprotect.listeners.ChatListener;
import io.github.insideranh.stellarprotect.listeners.CraftListener;
import io.github.insideranh.stellarprotect.listeners.EntityListener;
import io.github.insideranh.stellarprotect.listeners.ExplodeListener;
import io.github.insideranh.stellarprotect.listeners.InspectListener;
import io.github.insideranh.stellarprotect.listeners.JoinQuitListener;
import io.github.insideranh.stellarprotect.listeners.PickUpDropListener;
import io.github.insideranh.stellarprotect.listeners.PlayerLogListener;
import io.github.insideranh.stellarprotect.listeners.SignListener;
import io.github.insideranh.stellarprotect.listeners.blocks.CropGrowListener;
import io.github.insideranh.stellarprotect.listeners.versions.DecorativeEventHandler;
import io.github.insideranh.stellarprotect.listeners.versions.EventVersionHandler;
import io.github.insideranh.stellarprotect.managers.BlocksManager;
import io.github.insideranh.stellarprotect.managers.CacheManager;
import io.github.insideranh.stellarprotect.managers.ConfigManager;
import io.github.insideranh.stellarprotect.managers.HooksManager;
import io.github.insideranh.stellarprotect.managers.ItemsManager;
import io.github.insideranh.stellarprotect.managers.LangManager;
import io.github.insideranh.stellarprotect.managers.RestoreManager;
import io.github.insideranh.stellarprotect.managers.RestoreSessionManager;
import io.github.insideranh.stellarprotect.managers.TrackManager;
import io.github.insideranh.stellarprotect.nms.v1_12_R2.ColorUtils_v1_12_R2;
import io.github.insideranh.stellarprotect.nms.v1_12_R2.ProtectNMS_v1_12_R2;
import io.github.insideranh.stellarprotect.nms.v1_13_R2.ColorUtils_v1_13_R2;
import io.github.insideranh.stellarprotect.nms.v1_13_R2.ProtectNMS_v1_13_R2;
import io.github.insideranh.stellarprotect.nms.v1_16_R5.ColorUtils_v1_16_R5;
import io.github.insideranh.stellarprotect.nms.v1_16_R5.ProtectNMS_v1_16_R5;
import io.github.insideranh.stellarprotect.nms.v1_17_R1.ProtectNMS_v1_17_R1;
import io.github.insideranh.stellarprotect.nms.v1_8_R3.ColorUtils_v1_8_R3;
import io.github.insideranh.stellarprotect.nms.v1_8_R3.ProtectNMS_v1_8_R3;
import io.github.insideranh.stellarprotect.nms.v1_9_R4.ColorUtils_v1_9_R4;
import io.github.insideranh.stellarprotect.nms.v1_9_R4.ProtectNMS_v1_9_R4;
import io.github.insideranh.stellarprotect.providers.ItemsProviderImpl;
import io.github.insideranh.stellarprotect.restore.BlockRestore;
import io.github.insideranh.stellarprotect.trackers.BlockTracker;
import io.github.insideranh.stellarprotect.trackers.ChestTransactionTracker;
import io.github.insideranh.stellarprotect.utils.UpdateChecker;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.command.CommandExecutor;
import org.bukkit.entity.Entity;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.Nullable;

public class StellarProtect
extends JavaPlugin {
    private static StellarProtect instance;
    private final ConfigManager configManager;
    private final LangManager langManager;
    private final CacheManager cacheManager;
    private final ItemsManager itemsManager;
    private final RestoreManager restoreManager;
    private final RestoreSessionManager restoreSessionManager;
    private final TrackManager trackManager;
    private final BlocksManager blocksManager;
    private final ProtectDatabase protectDatabase;
    private final HooksManager hooksManager;
    private final InspectHandler inspectHandler;
    private final EventLogicHandler eventLogicHandler;
    private final DecorativeLogicHandler decorativeLogicHandler;
    @Nullable
    private NexoDefaultHook nexoHook;
    @Nullable
    private ItemsAdderHook itemsAdderHook;
    @Nullable
    private WorldEditHook worldEditHook;
    private DefaultVaultHook vaultHook = new DefaultVaultHook();
    private ChestTransactionTracker chestTransactionTracker;
    private ListeningExecutorService executor;
    private ListeningExecutorService lookupExecutor;
    private ListeningExecutorService joinExecutor;
    private ProtectNMS protectNMS;
    private ColorUtils colorUtils;
    private String version;
    private MinecraftVersion localVersion;
    private String completer;
    private MetricsLite bStats;
    private UpdateChecker updateChecker;
    private boolean isFolia;

    public StellarProtect() {
        instance = this;
        this.configManager = new ConfigManager();
        this.langManager = new LangManager();
        this.cacheManager = new CacheManager();
        this.itemsManager = new ItemsManager();
        this.restoreManager = new RestoreManager();
        this.restoreSessionManager = new RestoreSessionManager();
        this.trackManager = new TrackManager();
        this.blocksManager = new BlocksManager();
        this.hooksManager = new HooksManager();
        this.protectDatabase = new ProtectDatabase();
        this.inspectHandler = new InspectHandler();
        this.eventLogicHandler = new EventVersionHandler();
        this.decorativeLogicHandler = new DecorativeEventHandler();
    }

    public void onEnable() {
        this.getConfig().options().copyDefaults(true);
        this.saveConfig();
        this.isFolia = MinecraftVersions.WILD_UPDATE.isAtLeast() && ServerVersions.isFolia();
        this.loadNMS();
        this.lookupExecutor = MoreExecutors.listeningDecorator((ExecutorService)new ThreadPoolExecutor(2, 2, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1024)));
        this.joinExecutor = MoreExecutors.listeningDecorator((ExecutorService)new ThreadPoolExecutor(2, 2, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1024)));
        this.lookupExecutor.execute(() -> {
            AdjacentType.initializeCache();
            BlockTracker.initializeCache();
        });
        this.configManager.load();
        this.hooksManager.load();
        this.protectDatabase.connect();
        if (this.getServer().getPluginManager().isPluginEnabled("Vault")) {
            this.vaultHook = new VaultHook();
            this.vaultHook.setupEconomy();
            this.getLogger().info("Vault detected, enabling Vault hook...");
        }
        this.reload();
        this.executor = MoreExecutors.listeningDecorator((ExecutorService)new ThreadPoolExecutor(this.configManager.getMaxCores(), this.configManager.getMaxCores(), 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1024)));
        this.protectDatabase.load();
        this.cacheManager.load();
        ItemsProviderRegistry.register(new ItemsProviderImpl(this));
        this.chestTransactionTracker = new ChestTransactionTracker();
        for (Listener listener : this.getListeners()) {
            this.getServer().getPluginManager().registerEvents(listener, (Plugin)this);
        }
        this.getServer().getPluginManager().registerEvents((Listener)this.chestTransactionTracker, (Plugin)this);
        this.getCommand("stellarprotect").setExecutor((CommandExecutor)new StellarProtectCMD());
        this.bStats = new MetricsLite((Plugin)this, 26624);
        this.bStats.addCustomChart(new MetricsLite.SimplePie("databases", () -> this.getConfig().getString("databases.type", "h2").toLowerCase()));
        this.loadLastHooks();
        if (!this.configManager.isCheckUpdates()) {
            return;
        }
        this.updateChecker = new UpdateChecker();
    }

    public void reload() {
        this.reloadConfig();
        this.hooksManager.load();
        this.configManager.load();
        this.langManager.load();
        this.itemsManager.load();
        this.blocksManager.load();
        this.cacheManager.load();
        this.vaultHook.load();
        this.trackManager.load();
    }

    public void onDisable() {
        this.protectDatabase.close();
        this.bStats.shutdown();
    }

    void loadLastHooks() {
        this.getStellarTaskHook(() -> {
            if (this.hooksManager.isShopGuiHook() && this.getServer().getPluginManager().isPluginEnabled("ShopGUIPlus")) {
                Bukkit.getPluginManager().registerEvents((Listener)new ShopGUIHookListener(), (Plugin)this);
                this.getLogger().info("ShopGUIPlus detected, enabling ShopGUIPlus hook...");
            }
            if (this.hooksManager.isNexoHook() && this.getServer().getPluginManager().isPluginEnabled("Nexo")) {
                this.nexoHook = new NexoHook();
                Bukkit.getPluginManager().registerEvents((Listener)new NexoHookListener(), (Plugin)this);
                this.getLogger().info("Nexo detected, enabling Nexo hook...");
            }
            if (this.hooksManager.isItemsAdderHook() && this.getServer().getPluginManager().isPluginEnabled("ItemsAdder")) {
                this.itemsAdderHook = new ItemsAdderHook();
                Bukkit.getPluginManager().registerEvents((Listener)new ItemsAdderHookListener(), (Plugin)this);
                this.getLogger().info("ItemsAdder detected, enabling ItemsAdder hook...");
            }
            if (this.hooksManager.isXPlayerKitsHook() && this.getServer().getPluginManager().isPluginEnabled("XPlayerKits")) {
                Bukkit.getPluginManager().registerEvents((Listener)new XPlayerKitsListener(), (Plugin)this);
                this.getLogger().info("XPlayerKits detected, enabling XPlayerKits hook...");
            }
            if (this.hooksManager.isWorldEditHook() && this.getServer().getPluginManager().isPluginEnabled("WorldEdit")) {
                this.worldEditHook = new WorldEditHook();
                this.getLogger().info("WorldEdit detected, enabling WorldEdit hook...");
            }
        }).runTask(10L);
    }

    HashSet<Listener> getListeners() {
        return new HashSet<Listener>(Arrays.asList(new BlockFormListener(), new SignListener(), new ExplodeListener(), new BucketListener(), new BlockListener(), new CropGrowListener(), new JoinQuitListener(), new InspectListener(), new CraftListener(), new ChatListener(), new PickUpDropListener(), new PlayerLogListener(), new EntityListener()));
    }

    public ProtectNMS getProtectNMS() {
        if (this.protectNMS == null) {
            this.loadNMS();
        }
        return this.protectNMS;
    }

    public ColorUtils getColorUtils() {
        if (this.colorUtils == null) {
            this.loadNMS();
        }
        return this.colorUtils;
    }

    public void loadNMS() {
        String cbPackage = Bukkit.getServer().getClass().getPackage().getName();
        String detectedVersion = cbPackage.substring(cbPackage.lastIndexOf(46) + 1);
        if (!detectedVersion.startsWith("v")) {
            detectedVersion = Bukkit.getServer().getBukkitVersion();
        }
        this.version = detectedVersion;
        this.getLogger().info("Detected Minecraft version: " + this.version);
        this.localVersion = MinecraftVersion.get(this.version);
        if (this.localVersion == null) {
            Bukkit.getLogger().warning("[StellarProtect] No found Minecraft version " + this.version + ". If you want to support this version, contact InsiderAnh.");
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        if (this.localVersion.equals((Object)MinecraftVersion.v1_8)) {
            this.completer = "v1_8_R3";
            this.protectNMS = new ProtectNMS_v1_8_R3();
            this.colorUtils = new ColorUtils_v1_8_R3();
        } else if (this.localVersion.equals((Object)MinecraftVersion.v1_9)) {
            this.completer = "v1_9_R4";
            this.protectNMS = new ProtectNMS_v1_9_R4();
            this.colorUtils = new ColorUtils_v1_9_R4();
        } else if (this.localVersion.equals((Object)MinecraftVersion.v1_12)) {
            this.completer = "v1_12_R2";
            this.protectNMS = new ProtectNMS_v1_12_R2();
            this.colorUtils = new ColorUtils_v1_12_R2();
        } else if (this.localVersion.equals((Object)MinecraftVersion.v1_13)) {
            this.completer = "v1_13_R2";
            this.protectNMS = new ProtectNMS_v1_13_R2();
            this.colorUtils = new ColorUtils_v1_13_R2();
        } else if (this.localVersion.equals((Object)MinecraftVersion.v1_16)) {
            this.completer = "v1_16_R5";
            this.protectNMS = new ProtectNMS_v1_16_R5();
            this.colorUtils = new ColorUtils_v1_16_R5();
        } else if (this.localVersion.equals((Object)MinecraftVersion.v1_17)) {
            this.completer = "v1_17_R1";
            this.protectNMS = new ProtectNMS_v1_17_R1();
            this.colorUtils = new ColorUtils_v1_16_R5();
        } else {
            this.completer = this.localVersion.name();
            this.protectNMS = new ProtectNMS_v1_17_R1();
            this.colorUtils = new ColorUtils_v1_16_R5();
        }
        this.getLogger().info("Loaded " + this.completer + " version.");
        Listener listener = Class.forName("io.github.insideranh.stellarprotect.nms." + this.completer + ".listeners.BlockListener_" + this.completer).asSubclass(Listener.class).getConstructor(EventLogicHandler.class).newInstance(this.eventLogicHandler);
        this.getServer().getPluginManager().registerEvents(listener, (Plugin)this);
    }

    public BlockRestore getBlockRestore(String data) {
        return Class.forName("io.github.insideranh.stellarprotect.nms." + this.completer + ".BlockRestore_" + this.completer).asSubclass(BlockRestore.class).getConstructor(String.class).newInstance(data);
    }

    public BlockRestore getBlockRestore(String data, byte extraType, String extraData) {
        return Class.forName("io.github.insideranh.stellarprotect.nms." + this.completer + ".BlockRestore_" + this.completer).asSubclass(BlockRestore.class).getConstructor(String.class, Byte.TYPE, String.class).newInstance(data, extraType, extraData);
    }

    public DataBlock getDataBlock(Block block) {
        return Class.forName("io.github.insideranh.stellarprotect.nms." + this.completer + ".DataBlock_" + this.completer).asSubclass(DataBlock.class).getConstructor(Block.class).newInstance(block);
    }

    public DataBlock getDataBlock(BlockState blockState) {
        return Class.forName("io.github.insideranh.stellarprotect.nms." + this.completer + ".DataBlock_" + this.completer).asSubclass(DataBlock.class).getConstructor(BlockState.class).newInstance(blockState);
    }

    public DataBlock getDataBlock(String blockDataString) {
        return Class.forName("io.github.insideranh.stellarprotect.nms." + this.completer + ".DataBlock_" + this.completer).asSubclass(DataBlock.class).getConstructor(String.class).newInstance(blockDataString);
    }

    public DataEntity getDataEntity(Entity entity) {
        return Class.forName("io.github.insideranh.stellarprotect.nms." + this.completer + ".DataEntity_" + this.completer).asSubclass(DataEntity.class).getConstructor(Entity.class).newInstance(entity);
    }

    public DataEntity getDataEntity(HashMap<String, Object> map) {
        return Class.forName("io.github.insideranh.stellarprotect.nms." + this.completer + ".DataEntity_" + this.completer).asSubclass(DataEntity.class).getConstructor(HashMap.class).newInstance(map);
    }

    public StellarTaskHook getStellarTaskHook(Runnable runnable) {
        if (this.isFolia) {
            return new FoliaTaskHook(runnable);
        }
        return new BukkitTaskHook(runnable);
    }

    @Generated
    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    @Generated
    public LangManager getLangManager() {
        return this.langManager;
    }

    @Generated
    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    @Generated
    public ItemsManager getItemsManager() {
        return this.itemsManager;
    }

    @Generated
    public RestoreManager getRestoreManager() {
        return this.restoreManager;
    }

    @Generated
    public RestoreSessionManager getRestoreSessionManager() {
        return this.restoreSessionManager;
    }

    @Generated
    public TrackManager getTrackManager() {
        return this.trackManager;
    }

    @Generated
    public BlocksManager getBlocksManager() {
        return this.blocksManager;
    }

    @Generated
    public ProtectDatabase getProtectDatabase() {
        return this.protectDatabase;
    }

    @Generated
    public HooksManager getHooksManager() {
        return this.hooksManager;
    }

    @Generated
    public InspectHandler getInspectHandler() {
        return this.inspectHandler;
    }

    @Generated
    public EventLogicHandler getEventLogicHandler() {
        return this.eventLogicHandler;
    }

    @Generated
    public DecorativeLogicHandler getDecorativeLogicHandler() {
        return this.decorativeLogicHandler;
    }

    @Nullable
    @Generated
    public NexoDefaultHook getNexoHook() {
        return this.nexoHook;
    }

    @Nullable
    @Generated
    public ItemsAdderHook getItemsAdderHook() {
        return this.itemsAdderHook;
    }

    @Nullable
    @Generated
    public WorldEditHook getWorldEditHook() {
        return this.worldEditHook;
    }

    @Generated
    public DefaultVaultHook getVaultHook() {
        return this.vaultHook;
    }

    @Generated
    public ChestTransactionTracker getChestTransactionTracker() {
        return this.chestTransactionTracker;
    }

    @Generated
    public ListeningExecutorService getExecutor() {
        return this.executor;
    }

    @Generated
    public ListeningExecutorService getLookupExecutor() {
        return this.lookupExecutor;
    }

    @Generated
    public ListeningExecutorService getJoinExecutor() {
        return this.joinExecutor;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public MinecraftVersion getLocalVersion() {
        return this.localVersion;
    }

    @Generated
    public String getCompleter() {
        return this.completer;
    }

    @Generated
    public MetricsLite getBStats() {
        return this.bStats;
    }

    @Generated
    public UpdateChecker getUpdateChecker() {
        return this.updateChecker;
    }

    @Generated
    public boolean isFolia() {
        return this.isFolia;
    }

    @Generated
    public static StellarProtect getInstance() {
        return instance;
    }
}

