/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.arguments;

import io.github.insideranh.stellarprotect.StellarProtect;
import io.github.insideranh.stellarprotect.arguments.LocationArg;
import io.github.insideranh.stellarprotect.arguments.PageArg;
import io.github.insideranh.stellarprotect.arguments.RadiusArg;
import io.github.insideranh.stellarprotect.arguments.TimeArg;
import io.github.insideranh.stellarprotect.arguments.UsersArg;
import io.github.insideranh.stellarprotect.enums.ActionType;
import io.github.insideranh.stellarprotect.enums.TimesType;
import io.github.insideranh.stellarprotect.utils.PlayerUtils;
import io.github.insideranh.stellarprotect.utils.WorldUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class ArgumentsParser {
    public static final String MATERIAL_TYPE = "material_type";
    public static final String DISPLAY = "display";
    public static final String LORE = "lore";
    private static final Pattern TIME_PATTERN = Pattern.compile("([\\d.]+)(mo|[ywdhms])");
    private static final Pattern INCLUDE_PATTERN = Pattern.compile("(?:mi:|material_includes:)(\\[([^:]+):([^\\]]+)\\]|([^\\s\\[]+))");
    private static final Pattern EXCLUDE_PATTERN = Pattern.compile("(?:me:|material_excludes:)(\\[([^:]+):([^\\]]+)\\]|([^\\s\\[]+))");

    static int parseDuration(String input) {
        Matcher matcher = TIME_PATTERN.matcher(input.toLowerCase(Locale.ROOT));
        int totalSeconds = 0;
        block0: while (matcher.find()) {
            double value = ArgumentsParser.parseSafeDouble(matcher.group(1));
            String symbol = matcher.group(2);
            for (TimesType unit : TimesType.values()) {
                if (!unit.getSymbol().equals(symbol)) continue;
                totalSeconds += (int)(value * (double)unit.getSeconds());
                continue block0;
            }
        }
        return totalSeconds;
    }

    static double parseSafeDouble(String str) {
        try {
            return Double.parseDouble(str);
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    static int parseSafeInteger(String str, int defaultValue) {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static List<ActionType> parseActionTypes(String[] arguments) {
        String joined = String.join((CharSequence)" ", arguments).toLowerCase(Locale.ROOT).replace("\\", "").replace("'", "");
        ArrayList<ActionType> actionTypes = new ArrayList<ActionType>();
        for (String part : joined.split("\\s+")) {
            if (!part.startsWith("a:") && !part.startsWith("action:")) continue;
            String actionType = part.replaceFirst("^(a:|action:)", "");
            for (String action : actionType.split(",")) {
                actionTypes.add(ActionType.getByName(action));
            }
        }
        return actionTypes;
    }

    public static List<String> parseIncludesMaterials(String[] arguments) {
        String joined = String.join((CharSequence)" ", arguments).toLowerCase(Locale.ROOT).replace("\\", "").replace("'", "").replace(",", "");
        ArrayList<String> actionTypes = new ArrayList<String>();
        for (String part : joined.split("\\s+")) {
            if (!part.startsWith("i:") && !part.startsWith("include:")) continue;
            String actionType = part.replaceFirst("^(i:|include:)", "");
            actionTypes.addAll(Arrays.asList(actionType.split(",")));
        }
        return actionTypes;
    }

    public static List<String> parseExcludesMaterials(String[] arguments) {
        String joined = String.join((CharSequence)" ", arguments).toLowerCase(Locale.ROOT).replace("\\", "").replace("'", "").replace(",", "");
        ArrayList<String> actionTypes = new ArrayList<String>();
        for (String part : joined.split("\\s+")) {
            if (!part.startsWith("e:") && !part.startsWith("exclude:")) continue;
            String actionType = part.replaceFirst("^(e:|exclude:)", "");
            actionTypes.addAll(Arrays.asList(actionType.split(",")));
        }
        return actionTypes;
    }

    @Nullable
    public static LocationArg parseLocation(String[] arguments) {
        String joined = String.join((CharSequence)" ", arguments).toLowerCase(Locale.ROOT).replace("\\", "").replace("'", "").replace(",", "");
        for (String part : joined.split("\\s+")) {
            String locationSegment;
            String[] data;
            if (!part.startsWith("l:") && !part.startsWith("location:") || (data = (locationSegment = part.replaceFirst("^(l:|location:)", "")).split(";")).length != 4) continue;
            return new LocationArg(data[0], Integer.parseInt(data[1]), Integer.parseInt(data[2]), Integer.parseInt(data[3]));
        }
        return null;
    }

    @NonNull
    public static TimeArg parseTime(String[] arguments) {
        String joined = String.join((CharSequence)" ", arguments).toLowerCase(Locale.ROOT).replace("\\", "").replace("'", "");
        for (String part : joined.split("\\s+")) {
            long timeEnd;
            if (!part.startsWith("t:") && !part.startsWith("time:")) continue;
            String timeSegment = part.replaceFirst("^(t:|time:)", "");
            String[] rangeParts = (timeSegment = timeSegment.replace(",", "")).split("-");
            if (rangeParts.length == 0) {
                return new TimeArg("", "", System.currentTimeMillis() - TimeUnit.DAYS.toMillis(1L), System.currentTimeMillis());
            }
            String startString = rangeParts[0];
            String endString = rangeParts.length > 1 ? rangeParts[1] : "";
            long startDurationMs = ArgumentsParser.parseEnhancedDuration(rangeParts[0]) * 1000L;
            long endDurationMs = rangeParts.length > 1 ? ArgumentsParser.parseEnhancedDuration(rangeParts[1]) * 1000L : 0L;
            long timeStart = System.currentTimeMillis() - startDurationMs;
            long l = timeEnd = endDurationMs > 0L ? System.currentTimeMillis() - endDurationMs : System.currentTimeMillis();
            if (timeStart > timeEnd) {
                long temp = timeStart;
                timeStart = timeEnd;
                timeEnd = temp;
            }
            return new TimeArg(startString, endString, timeStart, timeEnd);
        }
        return new TimeArg("", "", 0L, System.currentTimeMillis());
    }

    private static long parseEnhancedDuration(String duration) {
        if (duration == null || duration.isEmpty()) {
            return 0L;
        }
        duration = duration.toLowerCase().trim();
        long totalSeconds = 0L;
        Pattern pattern = Pattern.compile("(\\d*\\.?\\d+)(mo|[ywdhms])");
        Matcher matcher = pattern.matcher(duration);
        while (matcher.find()) {
            String unit;
            double value = Double.parseDouble(matcher.group(1));
            switch (unit = matcher.group(2)) {
                case "y": {
                    totalSeconds += (long)(value * 365.0 * 24.0 * 3600.0);
                    break;
                }
                case "mo": {
                    totalSeconds += (long)(value * 30.0 * 24.0 * 3600.0);
                    break;
                }
                case "w": {
                    totalSeconds += (long)(value * 7.0 * 24.0 * 3600.0);
                    break;
                }
                case "d": {
                    totalSeconds += (long)(value * 24.0 * 3600.0);
                    break;
                }
                case "h": {
                    totalSeconds += (long)(value * 3600.0);
                    break;
                }
                case "m": {
                    totalSeconds += (long)(value * 60.0);
                    break;
                }
                case "s": {
                    totalSeconds += (long)value;
                }
            }
        }
        if (totalSeconds == 0L) {
            try {
                totalSeconds = (long)Double.parseDouble(duration);
            }
            catch (NumberFormatException e) {
                return 0L;
            }
        }
        return totalSeconds;
    }

    @NonNull
    public static PageArg parsePage(String[] arguments) {
        String joined = String.join((CharSequence)" ", arguments).toLowerCase(Locale.ROOT).replace("\\", "").replace("'", "").replace(",", "");
        for (String part : joined.split("\\s+")) {
            if (!part.startsWith("p:") && !part.startsWith("page:")) continue;
            String timeSegment = part.replaceFirst("^(p:|page:)", "");
            String[] rangeParts = timeSegment.split("-");
            if (rangeParts.length == 0) {
                rangeParts = new String[]{"1", "10"};
            }
            if (rangeParts.length == 1) {
                rangeParts = new String[]{rangeParts[0], "10"};
            }
            int page = ArgumentsParser.parseSafeInteger(rangeParts[0], 1);
            int perPage = ArgumentsParser.parseSafeInteger(rangeParts[1], 10);
            return new PageArg(page, perPage);
        }
        return new PageArg(1, 10);
    }

    @NonNull
    public static CompletableFuture<UsersArg> parseUsers(String[] arguments) {
        String joined = String.join((CharSequence)" ", arguments).toLowerCase(Locale.ROOT).replace("\\", "").replace("'", "");
        for (String part : joined.split("\\s+")) {
            if (!part.startsWith("u:") && !part.startsWith("users:")) continue;
            String usersSegment = part.replaceFirst("^(u:|users:)", "");
            String[] userNames = usersSegment.split(",");
            return CompletableFuture.supplyAsync(() -> {
                HashSet<Long> userIds = new HashSet<Long>();
                ArrayList<String> notFoundNames = new ArrayList<String>();
                for (String userName : userNames) {
                    if ((userName = userName.trim()).isEmpty()) continue;
                    long userId = PlayerUtils.getPlayerOrEntityId(userName);
                    if (userId != -2L) {
                        userIds.add(userId);
                        continue;
                    }
                    notFoundNames.add(userName);
                }
                List<Long> dbUserIds = StellarProtect.getInstance().getProtectDatabase().getIdsByNames(notFoundNames);
                userIds.addAll(dbUserIds);
                return new UsersArg(userIds);
            });
        }
        return CompletableFuture.completedFuture(new UsersArg(new long[0]));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static RadiusArg parseRadiusOrNull(Player player, String[] arguments, @NonNull Location location) {
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        String joined = String.join((CharSequence)" ", arguments).toLowerCase(Locale.ROOT).replace("\\", "").replace("'", "");
        for (String part : joined.split("\\s+")) {
            String[] radiusParts;
            int worldId;
            String radiusSegment;
            if (!part.startsWith("r:") && !part.startsWith("radius:") || (radiusSegment = part.replaceFirst("^(r:|radius:)", "")).isEmpty()) continue;
            if (radiusSegment.startsWith("#")) {
                if (radiusSegment.startsWith("#we") && StellarProtect.getInstance().getWorldEditHook() != null) {
                    return StellarProtect.getInstance().getWorldEditHook().getRadiusArgWorldEdit(player);
                }
                if (radiusSegment.equals("#global")) {
                    return new RadiusArg(-1, 100000.0, location.getBlockX() - 100000, location.getBlockX() + 100000, location.getBlockY() - 100000, location.getBlockY() + 100000, location.getBlockZ() - 100000, location.getBlockZ() + 100000);
                }
                String[] worldParts = radiusSegment.substring(1).split(",");
                String worldName = worldParts[0];
                worldId = WorldUtils.searchWorldId(worldName);
                if (worldParts.length <= 1) return new RadiusArg(worldId, 10000.0, location.getBlockX() - 10000, location.getBlockX() + 10000, location.getBlockY() - 10000, location.getBlockY() + 10000, location.getBlockZ() - 10000, location.getBlockZ() + 10000);
                radiusParts = new String[worldParts.length - 1];
                System.arraycopy(worldParts, 1, radiusParts, 0, worldParts.length - 1);
            } else {
                worldId = WorldUtils.searchWorldId(location.getWorld().getName());
                radiusParts = radiusSegment.split(",");
            }
            try {
                double radiusZ;
                double radiusY;
                double radiusX;
                double d = radiusX = radiusParts.length > 0 ? Double.parseDouble(radiusParts[0].trim()) : 10.0;
                if (radiusParts.length >= 3) {
                    radiusY = Double.parseDouble(radiusParts[1].trim());
                    radiusZ = Double.parseDouble(radiusParts[2].trim());
                } else if (radiusParts.length == 2) {
                    radiusY = Double.parseDouble(radiusParts[1].trim());
                    radiusZ = radiusX;
                } else {
                    radiusY = radiusX;
                    radiusZ = radiusX;
                }
                double maxRadius = Math.max(Math.max(radiusX, radiusY), radiusZ);
                return new RadiusArg(worldId, maxRadius, (double)location.getBlockX() - radiusX, (double)location.getBlockX() + radiusX, (double)location.getBlockY() - radiusY, (double)location.getBlockY() + radiusY, (double)location.getBlockZ() - radiusZ, (double)location.getBlockZ() + radiusZ);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public static Map<String, List<String>> parseIncludeMaterials(String[] arguments) {
        String joined = String.join((CharSequence)" ", arguments).replace("\\", "").replace("'", "");
        return ArgumentsParser.parseFilterArguments(joined, INCLUDE_PATTERN);
    }

    public static Map<String, List<String>> parseExcludeMaterials(String[] arguments) {
        String joined = String.join((CharSequence)" ", arguments).replace("\\", "").replace("'", "");
        return ArgumentsParser.parseFilterArguments(joined, EXCLUDE_PATTERN);
    }

    private static Map<String, List<String>> parseFilterArguments(String joined, Pattern pattern) {
        HashMap<String, List<String>> filterMap = new HashMap<String, List<String>>();
        Matcher matcher = pattern.matcher(joined);
        while (matcher.find()) {
            if (matcher.group(2) != null && matcher.group(3) != null) {
                String filterType = matcher.group(2).trim();
                String filterValue = matcher.group(3).trim();
                String mappedFilterType = ArgumentsParser.mapFilterType(filterType);
                filterMap.computeIfAbsent(mappedFilterType, k -> new ArrayList()).add(filterValue);
                continue;
            }
            if (matcher.group(4) == null) continue;
            String values = matcher.group(4);
            String[] valueArray = values.split(",");
            List materialList = filterMap.computeIfAbsent(MATERIAL_TYPE, k -> new ArrayList());
            for (String value : valueArray) {
                String trimmedValue = value.trim();
                if (trimmedValue.isEmpty()) continue;
                materialList.add(trimmedValue);
            }
        }
        return filterMap;
    }

    private static String mapFilterType(String filterType) {
        switch (filterType.toLowerCase()) {
            case "display": {
                return DISPLAY;
            }
            case "lore": {
                return LORE;
            }
        }
        return filterType;
    }
}

