/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.cache.keys;

import io.github.insideranh.stellarprotect.database.entries.LogEntry;
import io.github.insideranh.stellarprotect.utils.WorldUtils;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;

public class LocationCache {
    private final int worldId;
    private final int x;
    private final int y;
    private final int z;

    public LocationCache(int worldId, int x, int y, int z) {
        this.worldId = worldId;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static LocationCache of(LogEntry logEntry) {
        return LocationCache.of(logEntry.getWorldId(), (int)logEntry.getX(), (int)logEntry.getY(), (int)logEntry.getZ());
    }

    public static LocationCache of(Location location) {
        return new LocationCache(WorldUtils.getShortId(location.getWorld().getName()), location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    public static LocationCache of(int worldId, int x, int y, int z) {
        return new LocationCache(worldId, x, y, z);
    }

    public Location asLocation() {
        World world = Bukkit.getWorld((String)WorldUtils.getWorld(this.worldId));
        if (world == null) {
            return null;
        }
        return new Location(world, (double)this.x, (double)this.y, (double)this.z);
    }

    public boolean isInside(double minX, double maxX, double minY, double maxY, double minZ, double maxZ) {
        return minX <= (double)this.x && maxX >= (double)this.x && minY <= (double)this.y && maxY >= (double)this.y && minZ <= (double)this.z && maxZ >= (double)this.z;
    }

    public boolean isInside(int worldId, double minX, double maxX, double minY, double maxY, double minZ, double maxZ) {
        if (worldId > 0 && worldId != this.worldId) {
            return false;
        }
        return minX <= (double)this.x && maxX >= (double)this.x && minY <= (double)this.y && maxY >= (double)this.y && minZ <= (double)this.z && maxZ >= (double)this.z;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocationCache that = (LocationCache)o;
        return this.worldId == that.worldId && this.x == that.x && this.y == that.y && this.z == that.z;
    }

    public int hashCode() {
        int result = this.worldId;
        result = 31 * result + this.x;
        result = 31 * result + this.y;
        result = 31 * result + this.z;
        return result;
    }

    public String toString() {
        return "LocationCache{worldId=" + this.worldId + ", x=" + this.x + ", y=" + this.y + ", z=" + this.z + '}';
    }

    @Generated
    public int getWorldId() {
        return this.worldId;
    }

    @Generated
    public int getX() {
        return this.x;
    }

    @Generated
    public int getY() {
        return this.y;
    }

    @Generated
    public int getZ() {
        return this.z;
    }
}

