/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.database.entries;

import io.github.insideranh.stellarprotect.cache.keys.LocationCache;
import io.github.insideranh.stellarprotect.utils.PlayerUtils;
import io.github.insideranh.stellarprotect.utils.WorldUtils;
import java.sql.ResultSet;
import java.util.Objects;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.Location;

public class LogEntry {
    protected final long id;
    protected final long playerId;
    protected final int worldId;
    protected final double x;
    protected final double y;
    protected final double z;
    protected final int actionType;
    protected final long createdAt;
    private byte restored;

    public LogEntry(ResultSet resultSet) {
        this.id = resultSet.getLong("id");
        this.playerId = resultSet.getLong("player_id");
        this.worldId = resultSet.getInt("world_id");
        this.x = resultSet.getDouble("x");
        this.y = resultSet.getDouble("y");
        this.z = resultSet.getDouble("z");
        this.actionType = resultSet.getInt("action_type");
        this.createdAt = resultSet.getLong("created_at");
        this.restored = resultSet.getByte("restored");
    }

    public LogEntry(long playerId, int actionType, int worldId, double x, double y, double z, long createdAt) {
        this.id = PlayerUtils.getNextLogId();
        this.playerId = playerId;
        this.worldId = worldId;
        this.x = (double)Math.round(x * 100.0) / 100.0;
        this.y = (double)Math.round(y * 100.0) / 100.0;
        this.z = (double)Math.round(z * 100.0) / 100.0;
        this.actionType = actionType;
        this.createdAt = createdAt;
    }

    public LogEntry(long playerId, int actionType, Location location, long createdAt) {
        this.id = PlayerUtils.getNextLogId();
        this.playerId = playerId;
        this.actionType = actionType;
        this.worldId = WorldUtils.getShortId(location.getWorld().getName());
        this.x = (double)Math.round(location.getX() * 100.0) / 100.0;
        this.y = (double)Math.round(location.getY() * 100.0) / 100.0;
        this.z = (double)Math.round(location.getZ() * 100.0) / 100.0;
        this.createdAt = createdAt;
    }

    public LocationCache asLocation() {
        return LocationCache.of(this.worldId, (int)this.x, (int)this.y, (int)this.z);
    }

    public Location asBukkitLocation() {
        return new Location(Bukkit.getWorld((String)WorldUtils.getWorld(this.worldId)), this.x, this.y, this.z);
    }

    public String toString() {
        return "LogEntry{worldId=" + this.worldId + ", x=" + this.x + ", y=" + this.y + ", z=" + this.z + ", actionType=" + this.actionType + ", created_at=" + this.createdAt + '}';
    }

    public String getDataString() {
        return "";
    }

    public String toSaveJson() {
        return "";
    }

    public boolean isRestored() {
        return this.restored != 0;
    }

    public void setRestored(boolean restored) {
        this.restored = (byte)(restored ? 1 : 0);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogEntry logEntry = (LogEntry)o;
        return this.playerId == logEntry.playerId && this.worldId == logEntry.worldId && Double.compare(this.x, logEntry.x) == 0 && Double.compare(this.y, logEntry.y) == 0 && Double.compare(this.z, logEntry.z) == 0 && this.actionType == logEntry.actionType && this.createdAt == logEntry.createdAt;
    }

    public int hashCode() {
        return Objects.hash(this.playerId, this.worldId, this.x, this.y, this.z, this.actionType, this.createdAt);
    }

    @Generated
    public long getId() {
        return this.id;
    }

    @Generated
    public long getPlayerId() {
        return this.playerId;
    }

    @Generated
    public int getWorldId() {
        return this.worldId;
    }

    @Generated
    public double getX() {
        return this.x;
    }

    @Generated
    public double getY() {
        return this.y;
    }

    @Generated
    public double getZ() {
        return this.z;
    }

    @Generated
    public int getActionType() {
        return this.actionType;
    }

    @Generated
    public long getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public byte getRestored() {
        return this.restored;
    }
}

