/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.database.types.mysql;

import io.github.insideranh.stellarprotect.StellarProtect;
import io.github.insideranh.stellarprotect.database.repositories.IdsRepository;
import io.github.insideranh.stellarprotect.libs.hikaricp.HikariDataSource;
import io.github.insideranh.stellarprotect.utils.Debugger;
import io.github.insideranh.stellarprotect.utils.PlayerUtils;
import io.github.insideranh.stellarprotect.utils.WorldUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class IdsRepositoryMySQL
implements IdsRepository {
    private final StellarProtect stellarProtect = StellarProtect.getInstance();
    private final HikariDataSource dataSource;

    public IdsRepositoryMySQL(HikariDataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public void loadWorlds() {
        try (Connection connection = this.getConnection();
             PreparedStatement stmt = connection.prepareStatement("SELECT * FROM " + this.stellarProtect.getConfigManager().getTablesWorlds());){
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                String world = rs.getString("name");
                int id = rs.getInt("id");
                WorldUtils.cacheWorld(world, id);
                Debugger.debugExtras("Loaded world " + world + " with id " + id);
            }
        }
        catch (SQLException e) {
            this.stellarProtect.getLogger().warning("Error on loadWorlds: " + e.getMessage());
        }
    }

    @Override
    public void loadEntityIds() {
        try (Connection connection = this.getConnection();
             PreparedStatement stmt = connection.prepareStatement("SELECT * FROM " + this.stellarProtect.getConfigManager().getTablesEntityIds());){
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                String entityType = rs.getString("entityType");
                int id = rs.getInt("id");
                PlayerUtils.cacheEntityId(entityType, id);
                Debugger.debugExtras("Loaded entity " + entityType + " with id " + id);
            }
            PlayerUtils.loadEntityIds();
        }
        catch (SQLException e) {
            this.stellarProtect.getLogger().warning("Error on loadEntityIds: " + e.getMessage());
        }
    }

    @Override
    public void saveWorld(String world, int id) {
        try (Connection connection = this.getConnection();
             PreparedStatement stmt = connection.prepareStatement("INSERT INTO " + this.stellarProtect.getConfigManager().getTablesWorlds() + " (id, name) VALUES (?, ?)");){
            stmt.setInt(1, id);
            stmt.setString(2, world);
            stmt.executeUpdate();
            Debugger.debugExtras("Saved world " + world + " with id " + id);
        }
        catch (SQLException e) {
            this.stellarProtect.getLogger().warning("Error on saveWorld: " + e.getMessage());
        }
    }

    @Override
    public void saveEntityId(String entityType, long id) {
        try (Connection connection = this.getConnection();
             PreparedStatement stmt = connection.prepareStatement("INSERT INTO " + this.stellarProtect.getConfigManager().getTablesEntityIds() + " (entityType, id) VALUES (?, ?)");){
            stmt.setString(1, entityType);
            stmt.setLong(2, id);
            stmt.executeUpdate();
            Debugger.debugExtras("Saved entity " + entityType + " with id " + id);
        }
        catch (SQLException e) {
            this.stellarProtect.getLogger().warning("Error on saveEntityId: " + e.getMessage());
        }
    }

    public Connection getConnection() {
        return this.dataSource.getConnection();
    }
}

