/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.listeners;

import io.github.insideranh.stellarprotect.StellarProtect;
import io.github.insideranh.stellarprotect.cache.LoggerCache;
import io.github.insideranh.stellarprotect.data.PlayerProtect;
import io.github.insideranh.stellarprotect.database.entries.players.PlayerArmorStandManipulateEntry;
import io.github.insideranh.stellarprotect.database.entries.players.PlayerHangingEntry;
import io.github.insideranh.stellarprotect.database.entries.players.PlayerKillLogEntry;
import io.github.insideranh.stellarprotect.database.entries.players.PlayerShootEntry;
import io.github.insideranh.stellarprotect.enums.ActionType;
import io.github.insideranh.stellarprotect.items.ItemReference;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.player.PlayerArmorStandManipulateEvent;
import org.bukkit.inventory.ItemStack;

public class EntityListener
implements Listener {
    private final StellarProtect plugin = StellarProtect.getInstance();

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEntityDeath(EntityDeathEvent event) {
        long playerId;
        LivingEntity entity = event.getEntity();
        if (ActionType.KILL_ENTITY.shouldSkipLog(entity.getWorld().getName(), entity.getType().name())) {
            return;
        }
        if (entity.getKiller() != null) {
            Player killer = entity.getKiller();
            PlayerProtect playerProtect = PlayerProtect.getPlayer(killer);
            if (playerProtect == null) {
                return;
            }
            playerId = playerProtect.getPlayerId();
        } else {
            playerId = -2L;
        }
        LoggerCache.addLog(new PlayerKillLogEntry(playerId, (Entity)entity, ActionType.KILL_ENTITY));
    }

    @EventHandler
    public void onDamageByEntity(EntityDamageByEntityEvent event) {
        if (!(event.getDamager() instanceof Projectile)) {
            return;
        }
        Projectile projectile = (Projectile)event.getDamager();
        if (ActionType.SHOOT.shouldSkipLog(projectile.getWorld().getName(), projectile.getType().name())) {
            return;
        }
        if (!(projectile.getShooter() instanceof Player)) {
            return;
        }
        Player player = (Player)projectile.getShooter();
        PlayerProtect playerProtect = PlayerProtect.getPlayer(player);
        if (playerProtect == null) {
            return;
        }
        PlayerShootEntry shootEntry = new PlayerShootEntry(playerProtect.getPlayerId(), player.getLocation(), (Entity)projectile, event.getEntity(), true);
        LoggerCache.addLog(shootEntry);
    }

    @EventHandler
    public void onHangingBreak(HangingBreakByEntityEvent event) {
        if (!(event.getRemover() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getRemover();
        if (ActionType.HANGING.shouldSkipLog(player.getWorld().getName(), event.getEntity().getType().name())) {
            return;
        }
        PlayerProtect playerProtect = PlayerProtect.getPlayer(player);
        if (playerProtect == null) {
            return;
        }
        PlayerHangingEntry hangingEntry = new PlayerHangingEntry(playerProtect.getPlayerId(), player.getLocation(), (Entity)event.getEntity());
        LoggerCache.addLog(hangingEntry);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onArmorStand(PlayerArmorStandManipulateEvent event) {
        Player player = event.getPlayer();
        PlayerProtect playerProtect = PlayerProtect.getPlayer(player);
        if (playerProtect == null) {
            return;
        }
        if (ActionType.ARMOR_STAND_MANIPULATE.shouldSkipLog(player.getWorld().getName(), event.getSlot().name())) {
            return;
        }
        ItemStack playerItem = event.getPlayerItem();
        ItemStack armorStandItem = event.getArmorStandItem();
        int slot = event.getSlot().ordinal();
        ItemReference newItemReference = this.plugin.getItemsManager().getItemReference(playerItem);
        ItemReference oldItemReference = this.plugin.getItemsManager().getItemReference(armorStandItem);
        LoggerCache.addLog(new PlayerArmorStandManipulateEntry(playerProtect.getPlayerId(), player.getLocation(), oldItemReference, newItemReference, slot));
    }
}

