/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.maps;

public final class StringByteMap {
    private static final int DEFAULT_CAPACITY = 16;
    private static final float LOAD_FACTOR = 0.75f;
    private String[] keys;
    private byte[] values;
    private byte[] distances;
    private int size;
    private int threshold;
    private int mask;
    private byte defaultReturnValue;

    public StringByteMap(int initialCapacity) {
        int capacity = Integer.highestOneBit(initialCapacity - 1) << 1;
        if (capacity < 16) {
            capacity = 16;
        }
        this.keys = new String[capacity];
        this.values = new byte[capacity];
        this.distances = new byte[capacity];
        this.mask = capacity - 1;
        this.threshold = (int)((float)capacity * 0.75f);
        this.defaultReturnValue = 0;
    }

    private static int hash(String key) {
        int h = key.hashCode();
        h ^= h >>> 16;
        return h;
    }

    public void defaultReturnValue(byte defaultValue) {
        this.defaultReturnValue = defaultValue;
    }

    public byte getByte(String key) {
        if (key == null) {
            return this.defaultReturnValue;
        }
        int hash = StringByteMap.hash(key);
        int idx = hash & this.mask;
        for (byte distance = 0; this.keys[idx] != null && distance <= this.distances[idx]; distance = (byte)(distance + 1)) {
            if (this.keys[idx].equals(key)) {
                return this.values[idx];
            }
            idx = idx + 1 & this.mask;
        }
        return this.defaultReturnValue;
    }

    public byte put(String key, byte value) {
        if (key == null) {
            return this.defaultReturnValue;
        }
        if (this.size >= this.threshold) {
            this.resize();
        }
        int hash = StringByteMap.hash(key);
        int idx = hash & this.mask;
        String insertKey = key;
        byte insertValue = value;
        byte insertDistance = 0;
        while (true) {
            if (this.keys[idx] == null) {
                this.keys[idx] = insertKey;
                this.values[idx] = insertValue;
                this.distances[idx] = insertDistance;
                ++this.size;
                return this.defaultReturnValue;
            }
            if (this.keys[idx].equals(insertKey)) {
                byte oldValue = this.values[idx];
                this.values[idx] = insertValue;
                return oldValue;
            }
            if (insertDistance > this.distances[idx]) {
                String tempKey = this.keys[idx];
                byte tempValue = this.values[idx];
                byte tempDistance = this.distances[idx];
                this.keys[idx] = insertKey;
                this.values[idx] = insertValue;
                this.distances[idx] = insertDistance;
                insertKey = tempKey;
                insertValue = tempValue;
                insertDistance = tempDistance;
            }
            idx = idx + 1 & this.mask;
            insertDistance = (byte)(insertDistance + 1);
        }
    }

    private void resize() {
        String[] oldKeys = this.keys;
        byte[] oldValues = this.values;
        int oldCapacity = this.keys.length;
        int newCapacity = oldCapacity << 1;
        this.keys = new String[newCapacity];
        this.values = new byte[newCapacity];
        this.distances = new byte[newCapacity];
        this.mask = newCapacity - 1;
        this.threshold = (int)((float)newCapacity * 0.75f);
        this.size = 0;
        for (int i = 0; i < oldCapacity; ++i) {
            if (oldKeys[i] == null) continue;
            this.put(oldKeys[i], oldValues[i]);
        }
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void clear() {
        for (int i = 0; i < this.keys.length; ++i) {
            this.keys[i] = null;
            this.values[i] = 0;
            this.distances[i] = 0;
        }
        this.size = 0;
    }
}

