/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.nms.v1_8_R3;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import io.github.insideranh.stellarprotect.blocks.DataBlock;
import java.util.Objects;
import lombok.Generated;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;

public class DataBlock_v1_8_R3
implements DataBlock {
    private static final Gson gson = new Gson();
    private final Material material;
    private final byte data;
    private final String blockDataString;

    public DataBlock_v1_8_R3(String blockDataString) {
        this.blockDataString = blockDataString;
        JsonObject jsonObject = (JsonObject)gson.fromJson(blockDataString, JsonObject.class);
        this.material = Material.getMaterial((String)jsonObject.get("m").getAsString());
        this.data = jsonObject.get("d").getAsByte();
    }

    public DataBlock_v1_8_R3(Block block) {
        this.material = block.getType();
        this.data = block.getData();
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("m", this.material.name());
        jsonObject.addProperty("d", (Number)this.data);
        this.blockDataString = jsonObject.toString();
    }

    public DataBlock_v1_8_R3(BlockState block) {
        this.material = block.getType();
        this.data = block.getData().getData();
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("m", this.material.name());
        jsonObject.addProperty("d", (Number)this.data);
        this.blockDataString = jsonObject.toString();
    }

    @Override
    public String getTypeMaterial() {
        return this.material.name();
    }

    public int hashCode() {
        return this.blockDataString.hashCode();
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataBlock_v1_8_R3 that = (DataBlock_v1_8_R3)o;
        return Objects.equals(this.blockDataString, that.blockDataString);
    }

    @Override
    @Generated
    public String getBlockDataString() {
        return this.blockDataString;
    }
}

