/*
 * Decompiled with CFR 0.152.
 */
package com.example.musicmod.server;

public class MusicZone {
    private final double x;
    private final double y;
    private final double z;
    private final double range;
    private final String videoId;
    private final double volume;
    private final boolean loop;
    private final String name;
    private final String dimension;

    public MusicZone(String name, String dimension, double x, double y, double z, double range, String videoId, double volume, boolean loop) {
        this.name = name;
        this.dimension = dimension;
        this.x = x;
        this.y = y;
        this.z = z;
        this.range = range;
        this.videoId = videoId;
        this.volume = volume;
        this.loop = loop;
    }

    public String getName() {
        return this.name;
    }

    public String getDimension() {
        return this.dimension;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public double getRange() {
        return this.range;
    }

    public String getVideoId() {
        return this.videoId;
    }

    public double getVolume() {
        return this.volume;
    }

    public boolean isLoop() {
        return this.loop;
    }

    public boolean contains(double px, double py, double pz, String playerDimension) {
        if (!this.dimension.equals(playerDimension)) {
            return false;
        }
        double dx = px - this.x;
        double dy = py - this.y;
        double dz = pz - this.z;
        return dx * dx + dy * dy + dz * dz <= this.range * this.range;
    }

    public String toString() {
        return "MusicZone{name='" + this.name + "', dimension='" + this.dimension + "', x=" + this.x + ", y=" + this.y + ", z=" + this.z + ", range=" + this.range + ", videoId='" + this.videoId + "', volume=" + this.volume + ", loop=" + this.loop + "}";
    }
}

