/*
 * Decompiled with CFR 0.152.
 */
package com.example.musicmod;

import com.example.musicmod.server.MusicZone;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class MusicManager {
    private static final Set<MusicZone> regions = Collections.synchronizedSet(new HashSet());

    public static void addRegion(MusicZone region) {
        if (region != null) {
            regions.add(region);
        }
    }

    public static void removeRegion(MusicZone region) {
        if (region != null) {
            regions.remove(region);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<MusicZone> getRegions() {
        Set<MusicZone> set = regions;
        synchronized (set) {
            return Collections.unmodifiableSet(new HashSet<MusicZone>(regions));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<MusicZone> getZonesNear(double x, double y, double z, String dimension) {
        HashSet<MusicZone> nearby = new HashSet<MusicZone>();
        Set<MusicZone> set = regions;
        synchronized (set) {
            for (MusicZone zone : regions) {
                double dz;
                double dy;
                double dx;
                double distanceSq;
                if (zone.getDimension() == null || !zone.getDimension().equals(dimension) || !((distanceSq = (dx = x - zone.getX()) * dx + (dy = y - zone.getY()) * dy + (dz = z - zone.getZ()) * dz) <= zone.getRange() * zone.getRange())) continue;
                nearby.add(zone);
            }
        }
        return nearby;
    }
}

