/*
 * Decompiled with CFR 0.152.
 */
package com.example.musicmod;

import com.example.musicmod.MusicManager;
import com.example.musicmod.server.MusicServer;
import com.example.musicmod.server.MusicZone;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URI;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RegisterClientCommandsEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;

@Mod(value="musicmod")
public class MusicMod {
    private MusicServer localServer;
    private boolean serverStarted = false;
    private static MusicMod instance;

    public MusicMod(IEventBus modBus) {
        instance = this;
        NeoForge.EVENT_BUS.addListener(MusicMod::onRegisterClientCommands);
        NeoForge.EVENT_BUS.addListener(MusicMod::onClientTick);
        NeoForge.EVENT_BUS.addListener(MusicMod::onServerStopping);
    }

    public static MusicMod getInstance() {
        return instance;
    }

    private static void onRegisterClientCommands(RegisterClientCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)Commands.literal((String)"minetube").executes(ctx -> MusicMod.getInstance().toggleServerClient()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int toggleServerClient() {
        if (!this.serverStarted) {
            try {
                File gameDir = Minecraft.getInstance().gameDirectory;
                this.localServer = new MusicServer(8080);
                this.localServer.setOnZoneAdded(region -> {
                    MusicManager.addRegion(region);
                    System.out.println("[MineTube][client] Zone dynamically added: " + region.getName());
                });
                this.localServer.startServer();
                this.serverStarted = true;
                if (Minecraft.getInstance().player == null) return 1;
                MutableComponent clickable = Component.literal((String)"MineTube (client) launched! Click here to open web UI").withStyle(style -> style.withClickEvent((ClickEvent)new ClickEvent.OpenUrl(URI.create("http://localhost:8080"))).withHoverEvent((HoverEvent)new HoverEvent.ShowText((Component)Component.literal((String)"Open MineTube in your browser"))));
                Minecraft.getInstance().player.displayClientMessage((Component)clickable, false);
                return 1;
            }
            catch (Exception e) {
                e.printStackTrace();
                if (Minecraft.getInstance().player == null) return 0;
                Minecraft.getInstance().player.displayClientMessage((Component)Component.literal((String)("Failed to start MineTube (client): " + e.getMessage())), false);
                return 0;
            }
        }
        try {
            if (this.localServer != null) {
                this.localServer.stopServer();
            }
            this.localServer = null;
            this.serverStarted = false;
            if (Minecraft.getInstance().player == null) return 1;
            Minecraft.getInstance().player.displayClientMessage((Component)Component.literal((String)"MineTube (client) stopped."), false);
            return 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            if (Minecraft.getInstance().player == null) return 0;
            Minecraft.getInstance().player.displayClientMessage((Component)Component.literal((String)("Failed to stop MineTube (client): " + e.getMessage())), false);
            return 0;
        }
    }

    private static void onClientTick(ClientTickEvent.Post event) {
        MusicMod mod = MusicMod.getInstance();
        if (!mod.serverStarted || mod.localServer == null) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return;
        }
        double x = mc.player.getX();
        double y = mc.player.getY();
        double z = mc.player.getZ();
        String playerId = mc.player.getUUID() != null ? mc.player.getUUID().toString() : mc.player.getName().getString();
        String dimension = mc.player.level().dimension().location().toString();
        try {
            MusicMod.invokeBroadcastCoords(mod.localServer, x, y, z, playerId, dimension);
        }
        catch (Throwable t) {
            System.err.println("[MineTube] broadcastCoords (client) failed: " + String.valueOf(t));
            t.printStackTrace();
        }
    }

    private static void onServerStopping(ServerStoppingEvent event) {
        MusicMod mod = MusicMod.getInstance();
        if (mod.localServer != null) {
            try {
                mod.localServer.stopServer();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void invokeBroadcastCoords(MusicServer srv, double x, double y, double z, String playerId, String dimension) throws Exception {
        if (srv == null) {
            return;
        }
        Class<?> cls = srv.getClass();
        try {
            Method m = cls.getMethod("broadcastCoords", Double.TYPE, Double.TYPE, Double.TYPE, String.class, String.class);
            m.invoke((Object)srv, x, y, z, playerId, dimension);
            return;
        }
        catch (NoSuchMethodException m) {
            try {
                Method m2 = cls.getMethod("broadcastCoords", Double.TYPE, Double.TYPE, Double.TYPE, String.class);
                m2.invoke((Object)srv, x, y, z, playerId);
                return;
            }
            catch (NoSuchMethodException m2) {
                Method m3 = cls.getMethod("broadcastCoords", Double.TYPE, Double.TYPE, Double.TYPE);
                m3.invoke((Object)srv, x, y, z);
                return;
            }
        }
    }

    private static void invokePlaySongForZone(MusicServer srv, MusicZone zone, String playerId) throws Exception {
        if (srv == null) {
            return;
        }
        Class<?> cls = srv.getClass();
        try {
            Method m = cls.getMethod("playSongForZone", MusicZone.class, String.class);
            m.invoke((Object)srv, zone, playerId);
            return;
        }
        catch (NoSuchMethodException m) {
            Method m2 = cls.getMethod("playSongForZone", MusicZone.class);
            m2.invoke((Object)srv, zone);
            return;
        }
    }

    private static void invokeStopSongForZone(MusicServer srv, String playerId) throws Exception {
        if (srv == null) {
            return;
        }
        Class<?> cls = srv.getClass();
        try {
            Method m = cls.getMethod("stopSongForZone", String.class);
            m.invoke((Object)srv, playerId);
            return;
        }
        catch (NoSuchMethodException m) {
            Method m2 = cls.getMethod("stopSongForZone", new Class[0]);
            m2.invoke((Object)srv, new Object[0]);
            return;
        }
    }
}

