/*
 * Decompiled with CFR 0.152.
 */
package minetube.server;

import com.google.gson.Gson;
import com.sun.net.httpserver.HttpServer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import minetube.MusicManager;
import minetube.server.MusicZone;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.java_websocket.WebSocket;
import org.java_websocket.handshake.ClientHandshake;
import org.java_websocket.server.WebSocketServer;

@Environment(value=EnvType.CLIENT)
public class MusicServer {
    private static final Gson GSON = new Gson();
    private HttpServer httpServer;
    private MusicWebSocketServer wsServer;
    private final int port;
    private Timer pingTimer;
    private Consumer<MusicZone> onZoneAdded;

    public MusicServer(int port) {
        this.port = port;
    }

    public void setOnZoneAdded(Consumer<MusicZone> listener) {
        this.onZoneAdded = listener;
    }

    public void startServer() throws Exception {
        this.httpServer = HttpServer.create(new InetSocketAddress(this.port), 0);
        this.httpServer.createContext("/", exchange -> {
            try (InputStream is = this.getClass().getResourceAsStream("/assets/minetube/index.html");){
                if (is == null) {
                    byte[] msg = "404 Not Found".getBytes(StandardCharsets.UTF_8);
                    exchange.sendResponseHeaders(404, msg.length);
                    exchange.getResponseBody().write(msg);
                } else {
                    byte[] bytes = is.readAllBytes();
                    exchange.getResponseHeaders().add("Content-Type", "text/html; charset=utf-8");
                    exchange.sendResponseHeaders(200, bytes.length);
                    exchange.getResponseBody().write(bytes);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                exchange.sendResponseHeaders(500, 0L);
            }
            finally {
                exchange.close();
            }
        });
        this.httpServer.createContext("/favicon.png", exchange -> {
            try (InputStream is = this.getClass().getResourceAsStream("/assets/minetube/favicon.png");){
                if (is == null) {
                    byte[] msg = "404 Not Found".getBytes(StandardCharsets.UTF_8);
                    exchange.sendResponseHeaders(404, msg.length);
                    exchange.getResponseBody().write(msg);
                } else {
                    byte[] bytes = is.readAllBytes();
                    exchange.getResponseHeaders().add("Content-Type", "image/png");
                    exchange.sendResponseHeaders(200, bytes.length);
                    exchange.getResponseBody().write(bytes);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                exchange.sendResponseHeaders(500, 0L);
            }
            finally {
                exchange.close();
            }
        });
        this.httpServer.createContext("/MineTubeV1BGREM.png", exchange -> {
            try (InputStream is = this.getClass().getResourceAsStream("/assets/minetube/MineTubeV1BGREM.png");){
                if (is == null) {
                    byte[] msg = "404 Not Found".getBytes(StandardCharsets.UTF_8);
                    exchange.sendResponseHeaders(404, msg.length);
                    exchange.getResponseBody().write(msg);
                } else {
                    byte[] bytes = is.readAllBytes();
                    exchange.getResponseHeaders().add("Content-Type", "image/png");
                    exchange.sendResponseHeaders(200, bytes.length);
                    exchange.getResponseBody().write(bytes);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                exchange.sendResponseHeaders(500, 0L);
            }
            finally {
                exchange.close();
            }
        });
        this.httpServer.createContext("/zones", exchange -> {
            if (!"GET".equals(exchange.getRequestMethod())) {
                exchange.sendResponseHeaders(405, -1L);
                exchange.close();
                return;
            }
            String json = GSON.toJson(MusicManager.getRegions());
            exchange.getResponseHeaders().add("Content-Type", "application/json; charset=utf-8");
            byte[] bytes = json.getBytes(StandardCharsets.UTF_8);
            exchange.sendResponseHeaders(200, bytes.length);
            exchange.getResponseBody().write(bytes);
            exchange.close();
        });
        this.httpServer.start();
        System.out.println("[MineTube] HTTP server started on port " + this.port);
        new Thread(() -> {
            try {
                this.wsServer = new MusicWebSocketServer(this.port + 1);
                this.wsServer.start();
                System.out.println("[MineTube] WebSocket server started on port " + (this.port + 1));
                this.pingTimer = new Timer(true);
                this.pingTimer.scheduleAtFixedRate(new TimerTask(){

                    @Override
                    public void run() {
                        MusicServer.this.wsServer.broadcastPing();
                    }
                }, 1000L, 1000L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }).start();
    }

    public void stopServer() throws Exception {
        if (this.httpServer != null) {
            this.httpServer.stop(0);
        }
        if (this.wsServer != null) {
            this.wsServer.stop();
            this.wsServer = null;
        }
        if (this.pingTimer != null) {
            this.pingTimer.cancel();
        }
        System.out.println("[MineTube] Local server stopped.");
    }

    public void playSongForZone(MusicZone zone, String playerId) {
        if (this.wsServer != null) {
            HashMap<String, Object> payload = new HashMap<String, Object>();
            payload.put("type", "play_song");
            payload.put("videoId", zone.getVideoId());
            payload.put("volume", zone.getVolume());
            payload.put("loop", zone.isLoop());
            payload.put("range", zone.getRange());
            payload.put("x", zone.getX());
            payload.put("y", zone.getY());
            payload.put("z", zone.getZ());
            payload.put("playerId", playerId);
            this.wsServer.broadcastJson(payload);
        }
    }

    public void stopSongForZone(String playerId) {
        if (this.wsServer != null) {
            this.wsServer.broadcastJson(Map.of("type", "stop_song", "playerId", playerId));
        }
    }

    private String uploadTo0x0(String jsonData) throws IOException {
        String boundary = Long.toHexString(System.currentTimeMillis());
        URL url = new URL("https://0x0.st");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("POST");
        conn.setDoOutput(true);
        conn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
        try (OutputStream os = conn.getOutputStream();
             PrintWriter writer = new PrintWriter(new OutputStreamWriter(os, StandardCharsets.UTF_8));){
            writer.append("--").append(boundary).append("\r\n");
            writer.append("Content-Disposition: form-data; name=\"file\"; filename=\"profile.json\"\r\n");
            writer.append("Content-Type: application/json\r\n\r\n");
            writer.flush();
            os.write(jsonData.getBytes(StandardCharsets.UTF_8));
            os.flush();
            writer.append("\r\n").flush();
            writer.append("--").append(boundary).append("--\r\n").flush();
        }
        int responseCode = conn.getResponseCode();
        if (responseCode != 200) {
            throw new IOException("Upload failed: " + responseCode);
        }
        try (BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));){
            String line;
            String lastLine = null;
            while ((line = in.readLine()) != null) {
                lastLine = line;
            }
            if (lastLine == null) {
                throw new IOException("Empty response from 0x0");
            }
            String string = lastLine;
            return string;
        }
    }

    public void broadcastCoords(double x, double y, double z, String playerId, String dimension) {
        int dimId = this.mapDimensionToId(dimension);
        if (this.wsServer != null) {
            this.wsServer.broadcastJson(Map.of("type", "coords", "x", x, "y", y, "z", z, "dim", dimId, "playerId", playerId, "dimension", dimension));
        }
    }

    private int mapDimensionToId(String dimension) {
        return switch (dimension.toLowerCase(Locale.ROOT)) {
            case "overworld" -> 0;
            case "nether" -> -1;
            case "end" -> 1;
            default -> 1000 + dimension.hashCode() % 1000;
        };
    }

    @Environment(value=EnvType.CLIENT)
    private class MusicWebSocketServer
    extends WebSocketServer {
        private final Set<WebSocket> clients;

        public MusicWebSocketServer(int port) {
            super(new InetSocketAddress(port));
            this.clients = ConcurrentHashMap.newKeySet();
        }

        public void broadcastJson(Object obj) {
            String json = GSON.toJson(obj);
            for (WebSocket client : this.clients) {
                if (!client.isOpen()) continue;
                client.send(json);
            }
        }

        public void broadcastPing() {
            this.broadcastJson(Map.of("type", "ping"));
        }

        @Override
        public void onOpen(WebSocket conn, ClientHandshake handshake) {
            this.clients.add(conn);
            System.out.println("[MineTube] Client connected: " + String.valueOf(conn.getRemoteSocketAddress()));
        }

        @Override
        public void onClose(WebSocket conn, int code, String reason, boolean remote) {
            this.clients.remove(conn);
            System.out.println("[MineTube] Client disconnected: " + String.valueOf(conn.getRemoteSocketAddress()));
        }

        @Override
        public void onMessage(WebSocket conn, String message) {
            try {
                Map data = GSON.fromJson(message, Map.class);
                if (data == null || !data.containsKey("type")) {
                    return;
                }
                String type = data.get("type").toString();
                if (type.equals("add_zone")) {
                    MusicZone zone = GSON.fromJson(message, MusicZone.class);
                    if (MusicServer.this.onZoneAdded != null) {
                        MusicServer.this.onZoneAdded.accept(zone);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void onError(WebSocket conn, Exception ex) {
            ex.printStackTrace();
        }

        @Override
        public void onStart() {
            System.out.println("[MineTube] WebSocket server ready.");
        }
    }
}

