/*
 * Decompiled with CFR 0.152.
 */
package minetube;

import com.google.gson.Gson;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import minetube.MusicManager;
import minetube.server.MusicServer;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_310;
import net.minecraft.class_5250;

@Environment(value=EnvType.CLIENT)
public class MusicModClient
implements ClientModInitializer {
    private MusicServer localServer;
    private boolean serverStarted = false;
    private static MusicModClient instance;

    public static MusicModClient getInstance() {
        return instance;
    }

    public void onInitializeClient() {
        instance = this;
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"minetube").executes(ctx -> this.toggleServerClient())));
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            this.onClientTick();
            if (this.serverStarted && class_310.method_1551().field_1724 == null) {
                this.stopServerIfRunning();
            }
        });
        ClientLifecycleEvents.CLIENT_STOPPING.register(client -> this.stopServerIfRunning());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int toggleServerClient() {
        if (!this.serverStarted) {
            try {
                this.localServer = new MusicServer(8080);
                this.localServer.setOnZoneAdded(region -> {
                    MusicManager.addRegion(region);
                    System.out.println("[MineTube][client] Zone dynamically added: " + region.getName());
                });
                this.localServer.startServer();
                this.serverStarted = true;
                this.localServer.addHttpContext("/session", exchange -> {
                    try {
                        if (!"GET".equalsIgnoreCase(exchange.getRequestMethod())) {
                            exchange.sendResponseHeaders(405, -1L);
                            exchange.close();
                            return;
                        }
                        class_310 mc = class_310.method_1551();
                        if (mc.field_1724 == null) {
                            exchange.sendResponseHeaders(403, -1L);
                            exchange.close();
                            return;
                        }
                        Map<String, String> session = Map.of("username", mc.field_1724.method_5477().getString(), "uuid", mc.field_1724.method_5667().toString());
                        String json = new Gson().toJson(session);
                        exchange.getResponseHeaders().add("Content-Type", "application/json; charset=utf-8");
                        byte[] bytes = json.getBytes(StandardCharsets.UTF_8);
                        exchange.sendResponseHeaders(200, bytes.length);
                        try (OutputStream os = exchange.getResponseBody();){
                            os.write(bytes);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        exchange.sendResponseHeaders(500, 0L);
                        exchange.close();
                    }
                    finally {
                        exchange.close();
                    }
                });
                if (class_310.method_1551().field_1724 == null) return 1;
                class_5250 clickable = class_2561.method_43470((String)"MineTube (client) launched! Click here to open web UI").method_27694(style -> style.method_10958((class_2558)new class_2558.class_10608(URI.create("http://localhost:8080"))).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)"Open MineTube in your browser"))));
                class_310.method_1551().field_1724.method_7353((class_2561)clickable, false);
                return 1;
            }
            catch (Exception e) {
                e.printStackTrace();
                if (class_310.method_1551().field_1724 == null) return 0;
                class_310.method_1551().field_1724.method_7353((class_2561)class_2561.method_43470((String)("Failed to start MineTube (client): " + e.getMessage())), false);
                return 0;
            }
        } else {
            this.stopServerIfRunning();
        }
        return 1;
    }

    private void stopServerIfRunning() {
        try {
            if (this.localServer != null) {
                this.localServer.stopServer();
            }
            this.localServer = null;
            this.serverStarted = false;
            if (class_310.method_1551().field_1724 != null) {
                class_310.method_1551().field_1724.method_7353((class_2561)class_2561.method_43470((String)"MineTube (client) stopped."), false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void onClientTick() {
        if (!this.serverStarted || this.localServer == null) {
            return;
        }
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 == null) {
            return;
        }
        double x = mc.field_1724.method_23317();
        double y = mc.field_1724.method_23318();
        double z = mc.field_1724.method_23321();
        String playerId = mc.field_1724.method_5667() != null ? mc.field_1724.method_5667().toString() : mc.field_1724.method_5477().getString();
        String dimension = mc.field_1687.method_27983().method_29177().toString();
        try {
            MusicModClient.invokeBroadcastCoords(this.localServer, x, y, z, playerId, dimension);
        }
        catch (Throwable t) {
            System.err.println("[MineTube] broadcastCoords (client) failed: " + String.valueOf(t));
            t.printStackTrace();
        }
    }

    private static void invokeBroadcastCoords(MusicServer srv, double x, double y, double z, String playerId, String dimension) throws Exception {
        if (srv == null) {
            return;
        }
        Method m = srv.getClass().getMethod("broadcastCoords", Double.TYPE, Double.TYPE, Double.TYPE, String.class, String.class);
        m.invoke((Object)srv, x, y, z, playerId, dimension);
    }
}

