/*
 * Decompiled with CFR 0.152.
 */
package com.notcharrow.betterflight.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.notcharrow.betterflight.client.ClientData;
import com.notcharrow.betterflight.config.CommonConfig;
import com.notcharrow.betterflight.util.InputHandler;
import java.util.Random;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;

public class ClassicHudOverlay {
    private static final int OFFSET_FROM_CURSOR = 24;
    private static final int OFFSET_TO_HOTBAR_SIDES = 105;
    private static final int OFFSET_ABOVE_HOTBAR = 44;
    private static final int TEXTURE_SIZE = 128;
    private static final int ICON_SIZE = 16;
    private static final int HALF_ICON_SIZE = 8;
    private static final int SPRITE_DURABILITY_FULL = 0;
    private static final int SPRITE_DURABILITY_HALF = 16;
    private static final int SPRITE_DURABILITY_QUARTER = 32;
    private static final int SPRITE_DURABILITY_LOW = 48;
    private static final int SPRITE_BORDER_BLACK = 0;
    private static final int SPRITE_BORDER_RECHARGE = 16;
    private static final int SPRITE_BORDER_DEPLETION = 32;
    private static final int SPRITE_BORDER_FLARE = 48;
    private static final int SPRITE_METER_EMPTY = 64;
    private static final int SPRITE_METER_FULL = 80;
    private static final int SPRITE_ALARM = 96;
    private static final Random random = new Random(System.currentTimeMillis());
    private static final class_2960 ELYTRA_ICONS = class_2960.method_60655((String)"betterflight", (String)"textures/elytraicons.png");
    private static int rechargeBorderTimer = 0;
    private static int depletionBorderTimer = 0;

    public static void init() {
        HudRenderCallback.EVENT.register((context, renderTickCounter) -> {
            if (!ClientData.isFlightEnabled() || !ClientData.isWearingFunctionalWings()) {
                return;
            }
            if (!CommonConfig.CONFIG.classicHud) {
                return;
            }
            class_310 mc = class_310.method_1551();
            if (mc == null || mc.field_1724 == null) {
                return;
            }
            if (mc.field_1724.method_5765()) {
                return;
            }
            ClassicHudOverlay.renderOverlay(context, mc);
        });
    }

    private static void renderOverlay(class_332 context, class_310 mc) {
        int shakeX = 0;
        int shakeY = 0;
        int scaleWidth = mc.method_22683().method_4486();
        int scaleHeight = mc.method_22683().method_4502();
        int widgetPosX = 0;
        int widgetPosY = 0;
        switch (CommonConfig.CONFIG.hudLocation) {
            case "CURSOR_BELOW": {
                widgetPosX = scaleWidth / 2 - 8;
                widgetPosY = scaleHeight / 2 + 24 - 8;
                break;
            }
            case "CURSOR_LEFT": {
                widgetPosX = scaleWidth / 2 - 24 - 8;
                widgetPosY = scaleHeight / 2 - 8;
                break;
            }
            case "CURSOR_RIGHT": {
                widgetPosX = scaleWidth / 2 + 24 - 8;
                widgetPosY = scaleHeight / 2 - 8;
                break;
            }
            case "CURSOR_ABOVE": {
                widgetPosX = scaleWidth / 2 - 8;
                widgetPosY = scaleHeight / 2 - 24 - 8;
                break;
            }
            case "BAR_LEFT": {
                widgetPosX = scaleWidth / 2 - 105 - 8;
                widgetPosY = scaleHeight - 12 - 8;
                break;
            }
            case "BAR_RIGHT": {
                widgetPosX = scaleWidth / 2 + 105 - 8;
                widgetPosY = scaleHeight - 12 - 8;
                break;
            }
            default: {
                widgetPosX = scaleWidth / 2 - 8;
                widgetPosY = scaleHeight - 44 - 8;
            }
        }
        float durability = ClientData.getElytraDurability();
        int durabilityOffset = 0;
        if (durability > 0.5f) {
            durabilityOffset = 16;
        }
        if (durability > 0.75f) {
            durabilityOffset = 32;
        }
        if (durability > 0.9f) {
            durabilityOffset = 48;
        }
        int borderOffset = 0;
        if ((double)durability > 0.95) {
            if (mc.field_1687 != null) {
                long thisTick = mc.field_1687.method_8510();
                borderOffset = (int)(thisTick / 5L % 2L * 16L) + 96;
                if (thisTick / 3L % 2L > 0L) {
                    shakeX = random.nextInt(3) - 1;
                } else {
                    shakeY = random.nextInt(3) - 1;
                }
            }
        } else if (ClientData.isFlaring()) {
            borderOffset = 48;
        } else if (depletionBorderTimer > 0) {
            borderOffset = 32;
        } else if (rechargeBorderTimer > 0) {
            borderOffset = 16;
        }
        int drainedPixels = (int)Math.floor((1.0f - (float)InputHandler.charge / (float)CommonConfig.CONFIG.maxCharge) * 16.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)ELYTRA_ICONS);
        context.method_25290(ELYTRA_ICONS, widgetPosX + shakeX, widgetPosY + shakeY, 80.0f, (float)durabilityOffset, 16, 16, 128, 128);
        context.method_25290(ELYTRA_ICONS, widgetPosX + shakeX, widgetPosY + shakeY, 64.0f, (float)durabilityOffset, 16, drainedPixels, 128, 128);
        context.method_25290(ELYTRA_ICONS, widgetPosX + shakeX, widgetPosY + shakeY, (float)borderOffset, (float)durabilityOffset, 16, 16, 128, 128);
    }

    public static void borderTick() {
        if (depletionBorderTimer > 0) {
            --depletionBorderTimer;
        }
        if (rechargeBorderTimer > 0) {
            --rechargeBorderTimer;
        }
    }

    public static void setDepletionBorderTimer(int ticks) {
        depletionBorderTimer = ticks;
    }

    public static void setRechargeBorderTimer(int ticks) {
        rechargeBorderTimer = ticks;
    }

    public static void cycleWidgetLocation() {
        String currentLocation;
        CommonConfig.CONFIG.hudLocation = switch (currentLocation = CommonConfig.CONFIG.hudLocation) {
            case "BAR_CENTER" -> "BAR_LEFT";
            case "BAR_LEFT" -> "BAR_RIGHT";
            case "BAR_RIGHT" -> "CURSOR_ABOVE";
            case "CURSOR_ABOVE" -> "CURSOR_RIGHT";
            case "CURSOR_RIGHT" -> "CURSOR_BELOW";
            case "CURSOR_BELOW" -> "CURSOR_LEFT";
            case "CURSOR_LEFT" -> "BAR_CENTER";
            default -> "BAR_CENTER";
        };
        CommonConfig.save();
    }
}

